/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions;

import org.apache.flink.streaming.api.functions.IngestionTimeExtractor;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class IngestionTimeExtractorTest {
    IngestionTimeExtractorTest() {
    }

    @Test
    void testMonotonousTimestamps() {
        IngestionTimeExtractor assigner = new IngestionTimeExtractor();
        long maxRecordSoFar = 0L;
        long maxWatermarkSoFar = 0L;
        for (int i = 0; i < 1343; ++i) {
            if (i % 7 == 1) {
                Watermark mark = assigner.getCurrentWatermark();
                Assertions.assertThat((Object)mark).isNotNull();
                Assertions.assertThat((long)mark.getTimestamp()).isGreaterThanOrEqualTo(maxWatermarkSoFar);
                maxWatermarkSoFar = mark.getTimestamp();
                Assertions.assertThat((long)mark.getTimestamp()).isGreaterThanOrEqualTo(maxRecordSoFar - 1L);
            } else {
                long next = assigner.extractTimestamp((Object)"a", Long.MIN_VALUE);
                Assertions.assertThat((long)next).isGreaterThanOrEqualTo(maxRecordSoFar);
                Assertions.assertThat((long)next).isGreaterThanOrEqualTo(maxWatermarkSoFar);
                maxRecordSoFar = next;
            }
            if (i % 9 != 0) continue;
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

