/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.util.Collection;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.core.io.SimpleVersionedSerializerTypeSerializerProxy;
import org.apache.flink.streaming.api.datastream.CustomSinkOperatorUidHashes;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.SinkTransformationTranslatorITCaseBase;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.CommitterOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.SinkWriterOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.TestSink;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class SinkV1TransformationTranslatorITCase
extends SinkTransformationTranslatorITCaseBase<Sink<Integer, ?, ?, ?>> {
    SinkV1TransformationTranslatorITCase() {
    }

    @Override
    Sink<Integer, ?, ?, ?> simpleSink() {
        return TestSink.newBuilder().build();
    }

    @Override
    Sink<Integer, ?, ?, ?> sinkWithCommitter() {
        return TestSink.newBuilder().setDefaultCommitter().build();
    }

    @Override
    DataStreamSink<Integer> sinkTo(DataStream<Integer> stream, Sink<Integer, ?, ?, ?> sink) {
        return stream.sinkTo(sink);
    }

    @TestTemplate
    void generateWriterCommitterGlobalCommitterTopology() {
        StreamGraph streamGraph = this.buildGraph(TestSink.newBuilder().setDefaultCommitter().setDefaultGlobalCommitter().build(), this.runtimeExecutionMode);
        StreamNode sourceNode = this.findNodeName(streamGraph, node -> node.contains("Source"));
        StreamNode writerNode = this.findWriter(streamGraph);
        StreamNode committerNode = this.findCommitter(streamGraph);
        this.validateTopology(sourceNode, IntSerializer.class, writerNode, SinkWriterOperatorFactory.class, 2, -1);
        if (this.runtimeExecutionMode == RuntimeExecutionMode.STREAMING) {
            Assertions.assertThat((Collection)streamGraph.getStreamNodes()).hasSize(4);
        } else {
            Assertions.assertThat((Collection)streamGraph.getStreamNodes()).hasSize(4);
            this.validateTopology(writerNode, SimpleVersionedSerializerTypeSerializerProxy.class, committerNode, CommitterOperatorFactory.class, 2, -1);
        }
        StreamNode lastNode = committerNode;
        StreamNode globalCommitterNode = this.findGlobalCommitter(streamGraph);
        this.validateTopology(lastNode, SimpleVersionedSerializerTypeSerializerProxy.class, globalCommitterNode, SimpleOperatorFactory.class, 1, 1);
    }

    @TestTemplate
    void generateWriterGlobalCommitterTopology() {
        StreamGraph streamGraph = this.buildGraph(TestSink.newBuilder().setCommittableSerializer(TestSink.StringCommittableSerializer.INSTANCE).setGlobalCommittableSerializer(TestSink.StringCommittableSerializer.INSTANCE).setDefaultGlobalCommitter().build(), this.runtimeExecutionMode);
        StreamNode sourceNode = this.findNodeName(streamGraph, node -> node.contains("Source"));
        StreamNode writerNode = this.findWriter(streamGraph);
        this.validateTopology(sourceNode, IntSerializer.class, writerNode, SinkWriterOperatorFactory.class, 2, -1);
        StreamNode committerNode = this.findCommitter(streamGraph);
        StreamNode globalCommitterNode = this.findGlobalCommitter(streamGraph);
        this.validateTopology(writerNode, SimpleVersionedSerializerTypeSerializerProxy.class, committerNode, CommitterOperatorFactory.class, 2, -1);
        this.validateTopology(committerNode, SimpleVersionedSerializerTypeSerializerProxy.class, globalCommitterNode, SimpleOperatorFactory.class, 1, 1);
    }

    @TestTemplate
    void testSettingOperatorUidHash() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource src = env.fromData((Object[])new Integer[]{1, 2});
        String writerHash = "f6b178ce445dc3ffaa06bad27a51fead";
        String committerHash = "68ac8ae79eae4e3135a54f9689c4aa10";
        String globalCommitterHash = "77e6aa6eeb1643b3765e1e4a7a672f37";
        CustomSinkOperatorUidHashes operatorsUidHashes = CustomSinkOperatorUidHashes.builder().setWriterUidHash("f6b178ce445dc3ffaa06bad27a51fead").setCommitterUidHash("68ac8ae79eae4e3135a54f9689c4aa10").setGlobalCommitterUidHash("77e6aa6eeb1643b3765e1e4a7a672f37").build();
        src.sinkTo(TestSink.newBuilder().setDefaultCommitter().setDefaultGlobalCommitter().build(), operatorsUidHashes).name("FileSink");
        StreamGraph streamGraph = env.getStreamGraph();
        Assertions.assertThat((String)this.findWriter(streamGraph).getUserHash()).isEqualTo("f6b178ce445dc3ffaa06bad27a51fead");
        Assertions.assertThat((String)this.findCommitter(streamGraph).getUserHash()).isEqualTo("68ac8ae79eae4e3135a54f9689c4aa10");
        Assertions.assertThat((String)this.findGlobalCommitter(streamGraph).getUserHash()).isEqualTo("77e6aa6eeb1643b3765e1e4a7a672f37");
    }

    @TestTemplate
    void testSettingOperatorUids() {
        String sinkUid = "f6b178ce445dc3ffaa06bad27a51fead";
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource src = env.fromData((Object[])new Integer[]{1, 2});
        src.sinkTo(TestSink.newBuilder().setDefaultCommitter().setDefaultGlobalCommitter().build()).name("FileSink").uid("f6b178ce445dc3ffaa06bad27a51fead");
        StreamGraph streamGraph = env.getStreamGraph();
        Assertions.assertThat((String)this.findWriter(streamGraph).getTransformationUID()).isEqualTo("f6b178ce445dc3ffaa06bad27a51fead");
        Assertions.assertThat((String)this.findCommitter(streamGraph).getTransformationUID()).isEqualTo(String.format("Sink Committer: %s", "f6b178ce445dc3ffaa06bad27a51fead"));
        Assertions.assertThat((String)this.findGlobalCommitter(streamGraph).getTransformationUID()).isEqualTo(String.format("Sink %s Global Committer", "f6b178ce445dc3ffaa06bad27a51fead"));
    }
}

