/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.streaming.api.datastream.CustomSinkOperatorUidHashes;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.SinkTransformationTranslatorITCaseBase;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.runtime.operators.sink.TestSinkV2;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class SinkV2TransformationTranslatorITCase
extends SinkTransformationTranslatorITCaseBase<Sink<Integer>> {
    SinkV2TransformationTranslatorITCase() {
    }

    @Override
    Sink<Integer> simpleSink() {
        return TestSinkV2.newBuilder().build();
    }

    @Override
    Sink<Integer> sinkWithCommitter() {
        return TestSinkV2.newBuilder().setDefaultCommitter().build();
    }

    @Override
    DataStreamSink<Integer> sinkTo(DataStream<Integer> stream, Sink<Integer> sink) {
        return stream.sinkTo(sink);
    }

    @TestTemplate
    void testSettingOperatorUidHash() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource src = env.fromElements((Object[])new Integer[]{1, 2});
        String writerHash = "f6b178ce445dc3ffaa06bad27a51fead";
        String committerHash = "68ac8ae79eae4e3135a54f9689c4aa10";
        CustomSinkOperatorUidHashes operatorsUidHashes = CustomSinkOperatorUidHashes.builder().setWriterUidHash("f6b178ce445dc3ffaa06bad27a51fead").setCommitterUidHash("68ac8ae79eae4e3135a54f9689c4aa10").build();
        src.sinkTo(this.sinkWithCommitter(), operatorsUidHashes).name("FileSink");
        StreamGraph streamGraph = env.getStreamGraph();
        Assertions.assertThat((String)this.findWriter(streamGraph).getUserHash()).isEqualTo("f6b178ce445dc3ffaa06bad27a51fead");
        Assertions.assertThat((String)this.findCommitter(streamGraph).getUserHash()).isEqualTo("68ac8ae79eae4e3135a54f9689c4aa10");
    }

    @TestTemplate
    void testSettingOperatorUids() {
        String sinkUid = "f6b178ce445dc3ffaa06bad27a51fead";
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource src = env.fromElements((Object[])new Integer[]{1, 2});
        src.sinkTo(this.sinkWithCommitter()).name("FileSink").uid("f6b178ce445dc3ffaa06bad27a51fead");
        StreamGraph streamGraph = env.getStreamGraph();
        Assertions.assertThat((String)this.findWriter(streamGraph).getTransformationUID()).isEqualTo("f6b178ce445dc3ffaa06bad27a51fead");
        Assertions.assertThat((String)this.findCommitter(streamGraph).getTransformationUID()).isEqualTo(String.format("Sink Committer: %s", "f6b178ce445dc3ffaa06bad27a51fead"));
    }
}

