/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class LoggerAuditingExtension
implements BeforeEachCallback,
AfterEachCallback {
    private static final LoggerContext LOGGER_CONTEXT = (LoggerContext)LogManager.getContext((boolean)false);
    private final String loggerName;
    private final org.slf4j.event.Level level;
    private ConcurrentLinkedQueue<String> loggingEvents;

    public LoggerAuditingExtension(Class<?> clazz, org.slf4j.event.Level level) {
        this.loggerName = clazz.getCanonicalName();
        this.level = level;
    }

    public List<String> getMessages() {
        return new ArrayList<String>(this.loggingEvents);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.loggingEvents = new ConcurrentLinkedQueue();
        AbstractAppender testAppender = new AbstractAppender("test-appender", null, null, false, Property.EMPTY_ARRAY){

            public void append(LogEvent event) {
                LoggerAuditingExtension.this.loggingEvents.add(event.getMessage().getFormattedMessage());
            }
        };
        testAppender.start();
        AppenderRef appenderRef = AppenderRef.createAppenderRef((String)testAppender.getName(), null, null);
        LoggerConfig logger = LoggerConfig.createLogger((boolean)false, (Level)Level.getLevel((String)this.level.name()), (String)"test", null, (AppenderRef[])new AppenderRef[]{appenderRef}, null, (Configuration)LOGGER_CONTEXT.getConfiguration(), null);
        logger.addAppender((Appender)testAppender, null, null);
        LOGGER_CONTEXT.getConfiguration().addLogger(this.loggerName, logger);
        LOGGER_CONTEXT.updateLoggers();
    }

    public void afterEach(ExtensionContext context) throws Exception {
        LOGGER_CONTEXT.getConfiguration().removeLogger(this.loggerName);
        LOGGER_CONTEXT.updateLoggers();
        this.loggingEvents = null;
    }
}

