/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cli.shutdown;

import java.io.OutputStream;
import org.apache.geronimo.cli.BaseCLParser;
import org.apache.geronimo.cli.PrintHelper;

public class ShutdownCLParser
extends BaseCLParser {
    private static final String ARGUMENT_HOST_SHORTFORM = "host";
    private static final String ARGUMENT_PORT_SHORTFORM = "port";
    private static final String ARGUMENT_PORT = "port";
    private static final String ARGUMENT_USER_SHORTFORM = "u";
    private static final String ARGUMENT_USER = "user";
    private static final String ARGUMENT_PASSWORD_SHORTFORM = "p";
    private static final String ARGUMENT_PASSWORD = "password";
    private static final String ARGUMENT_SECURE_SHORTFORM = "secure";
    private static final String ARGUMENT_SECURE = "secure";

    public ShutdownCLParser(OutputStream out) {
        super(out);
        this.addHost();
        this.addPort();
        this.addUser();
        this.addPassword();
        this.addSecure();
    }

    public String getHost() {
        return this.commandLine.getOptionValue(ARGUMENT_HOST_SHORTFORM);
    }

    public Integer getPort() {
        String port = this.commandLine.getOptionValue("port");
        if (null == port) {
            return null;
        }
        return new Integer(port);
    }

    public String getUser() {
        return this.commandLine.getOptionValue(ARGUMENT_USER_SHORTFORM);
    }

    public String getPassword() {
        return this.commandLine.getOptionValue(ARGUMENT_PASSWORD_SHORTFORM);
    }

    public boolean isSecure() {
        return this.commandLine.hasOption("secure");
    }

    @Override
    public void displayHelp() {
        PrintHelper printHelper = new PrintHelper(System.out);
        printHelper.printHelp("java -jar bin/shutdown.jar $options", "\nThe following options are available:", this.options, "\n", true);
    }

    protected void addSecure() {
        this.options.addOption("secure", "secure", false, "Use secure channel to communicate with the server.  Unsecured channel is used by default.");
    }

    protected void addPassword() {
        this.addOptionWithParam(ARGUMENT_PASSWORD, ARGUMENT_PASSWORD_SHORTFORM, ARGUMENT_PASSWORD, "Specifies a password to use to authenticate to the server.");
    }

    protected void addUser() {
        this.addOptionWithParam(ARGUMENT_USER, ARGUMENT_USER_SHORTFORM, "username", "Specifies a username to use to authenticate to the server.");
    }

    protected void addPort() {
        this.addOptionWithParam("port", "port", "port", "The RMI port of a Geronimo server to stop.");
    }

    protected void addHost() {
        this.addOptionWithParam(ARGUMENT_HOST_SHORTFORM, ARGUMENT_HOST_SHORTFORM, "hostname", "The host name of a Geronimo server to stop.");
    }
}

