/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config.transformer;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationDataTransformer;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.transformer.CollocatedWithConfigInfoLocater;
import org.apache.geronimo.kernel.config.transformer.ConfigurationDataBuilder;
import org.apache.geronimo.kernel.config.transformer.GBeanDataBuilder;
import org.apache.geronimo.kernel.config.transformer.GroovyScriptException;
import org.apache.geronimo.kernel.config.transformer.PatternFilter;
import org.apache.geronimo.kernel.config.transformer.ScriptLocater;
import org.apache.geronimo.kernel.repository.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyTransformer
implements ConfigurationDataTransformer {
    private static final String BINDING_CONFIGURATION_DATA = "configurationData";
    private static final String BINDING_CONFIGURATION_DATA_BUILDER = "configurationDataBuilder";
    private static final Pattern PATTERN_DEPENDENCIES_FILE = Pattern.compile("Dependencies(.*).groovy");
    private static final String BINDING_GBEAN_DATAS = "gbeanDatas";
    private static final String BINDING_GBEAN_DATAS_BUILDER = "gbeanDataBuilder";
    private static final Pattern PATTERN_GBEANS_FILE = Pattern.compile("GBeans(.*).groovy");
    private final ScriptLocater scriptLocater = this.newScriptLocater();

    public void transformDependencies(ConfigurationData configurationData) throws InvalidConfigException {
        configurationData.setConfigurationDataTransformer((ConfigurationDataTransformer)this);
        File scriptDir = this.scriptLocater.locate(configurationData);
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put(BINDING_CONFIGURATION_DATA, configurationData);
        bindings.put(BINDING_CONFIGURATION_DATA_BUILDER, new ConfigurationDataBuilder(configurationData));
        Binding binding = new Binding(bindings);
        GroovyShell shell = new GroovyShell(binding);
        this.executeScripts(shell, scriptDir, PATTERN_DEPENDENCIES_FILE);
    }

    public List<GBeanData> transformGBeans(ClassLoader classLoader, ConfigurationData configurationData, List<GBeanData> gbeanDatas) throws InvalidConfigException {
        gbeanDatas = new ArrayList<GBeanData>(gbeanDatas);
        File scriptDir = this.scriptLocater.locate(configurationData);
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put(BINDING_CONFIGURATION_DATA, configurationData);
        bindings.put(BINDING_GBEAN_DATAS, gbeanDatas);
        bindings.put(BINDING_GBEAN_DATAS_BUILDER, new GBeanDataBuilder(configurationData, gbeanDatas));
        Binding binding = new Binding(bindings);
        GroovyShell shell = new GroovyShell(classLoader, binding);
        this.executeScripts(shell, scriptDir, PATTERN_GBEANS_FILE);
        return gbeanDatas;
    }

    public void remove(Artifact configId) {
    }

    protected ScriptLocater newScriptLocater() {
        return new CollocatedWithConfigInfoLocater();
    }

    protected void executeScripts(GroovyShell shell, File scriptDir, Pattern pattern) throws InvalidConfigException {
        File[] scripts = scriptDir.listFiles(new PatternFilter(pattern));
        this.executeScripts(shell, scripts);
    }

    protected void executeScripts(GroovyShell shell, File[] scripts) throws InvalidConfigException {
        for (File script : scripts) {
            try {
                shell.evaluate(script);
            }
            catch (Exception e) {
                if (e instanceof InvalidConfigException) {
                    throw (InvalidConfigException)e;
                }
                throw new GroovyScriptException("Error while evaluating [" + script.getAbsolutePath() + "]", e);
            }
        }
    }
}

