/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.crypto.asn1.x509;

import org.apache.geronimo.crypto.asn1.ASN1Encodable;
import org.apache.geronimo.crypto.asn1.ASN1EncodableVector;
import org.apache.geronimo.crypto.asn1.ASN1Sequence;
import org.apache.geronimo.crypto.asn1.DEREncodable;
import org.apache.geronimo.crypto.asn1.DERIA5String;
import org.apache.geronimo.crypto.asn1.DERObject;
import org.apache.geronimo.crypto.asn1.DERObjectIdentifier;
import org.apache.geronimo.crypto.asn1.DERSequence;
import org.apache.geronimo.crypto.asn1.x509.PolicyQualifierId;

public class PolicyQualifierInfo
extends ASN1Encodable {
    DERObjectIdentifier policyQualifierId;
    DEREncodable qualifier;

    public PolicyQualifierInfo(DERObjectIdentifier policyQualifierId, DEREncodable qualifier) {
        this.policyQualifierId = policyQualifierId;
        this.qualifier = qualifier;
    }

    public PolicyQualifierInfo(String cps) {
        this.policyQualifierId = PolicyQualifierId.id_qt_cps;
        this.qualifier = new DERIA5String(cps);
    }

    public PolicyQualifierInfo(ASN1Sequence as) {
        this.policyQualifierId = (DERObjectIdentifier)as.getObjectAt(0);
        this.qualifier = as.getObjectAt(1);
    }

    public static PolicyQualifierInfo getInstance(Object as) {
        if (as instanceof PolicyQualifierInfo) {
            return (PolicyQualifierInfo)as;
        }
        if (as instanceof ASN1Sequence) {
            return new PolicyQualifierInfo((ASN1Sequence)as);
        }
        throw new IllegalArgumentException("unknown object in getInstance.");
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector dev = new ASN1EncodableVector();
        dev.add(this.policyQualifierId);
        dev.add(this.qualifier);
        return new DERSequence(dev);
    }
}

