/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.crypto.asn1.x509;

import java.io.IOException;
import org.apache.geronimo.crypto.asn1.DERBMPString;
import org.apache.geronimo.crypto.asn1.DERIA5String;
import org.apache.geronimo.crypto.asn1.DERObject;
import org.apache.geronimo.crypto.asn1.DERObjectIdentifier;
import org.apache.geronimo.crypto.asn1.DERPrintableString;
import org.apache.geronimo.crypto.asn1.DERUTF8String;
import org.apache.geronimo.crypto.asn1.x509.X509Name;
import org.apache.geronimo.crypto.asn1.x509.X509NameEntryConverter;

public class X509DefaultEntryConverter
extends X509NameEntryConverter {
    @Override
    public DERObject getConvertedValue(DERObjectIdentifier oid, String value) {
        if (value.length() != 0 && value.charAt(0) == '#') {
            try {
                return this.convertHexEncoded(value, 1);
            }
            catch (IOException e) {
                throw new RuntimeException("can't recode value for oid " + oid.getId(), e);
            }
        }
        if (oid.equals(X509Name.EmailAddress)) {
            return new DERIA5String(value);
        }
        if (this.canBePrintable(value)) {
            return new DERPrintableString(value);
        }
        if (this.canBeUTF8(value)) {
            return new DERUTF8String(value);
        }
        return new DERBMPString(value);
    }
}

