/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean;

import java.lang.reflect.Method;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GBeanInfoFactoryException;

public class BasicGBeanInfoFactory
implements GBeanInfoFactory {
    public GBeanInfo getGBeanInfo(Class clazz) throws GBeanInfoFactoryException {
        return this.getGBeanInfo(clazz.getName(), clazz.getClassLoader());
    }

    public GBeanInfo getGBeanInfo(String className, ClassLoader classLoader) throws GBeanInfoFactoryException {
        Method method;
        Class<?> clazz;
        try {
            clazz = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new GBeanInfoFactoryException("Could not load class " + className, e);
        }
        catch (NoClassDefFoundError e) {
            throw new GBeanInfoFactoryException("Could not load class " + className, e);
        }
        try {
            method = clazz.getDeclaredMethod("getGBeanInfo", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                clazz = classLoader.loadClass(className + "GBean");
                method = clazz.getDeclaredMethod("getGBeanInfo", new Class[0]);
            }
            catch (Exception ignored) {
                throw new GBeanInfoFactoryException("Class does not have a getGBeanInfo() method: " + className);
            }
        }
        catch (NoClassDefFoundError e) {
            String message = e.getMessage();
            StringBuffer buf = new StringBuffer("Could not load gbean class ").append(className).append(" due to NoClassDefFoundError\n");
            if (message != null) {
                message = message.replace('/', '.');
                buf.append("    problematic class ").append(message);
                try {
                    Class<?> hardToLoad = classLoader.loadClass(message);
                    buf.append(" can be loaded in supplied classloader ").append(classLoader).append("\n");
                    buf.append("    and is found in ").append(hardToLoad.getClassLoader());
                }
                catch (ClassNotFoundException e1) {
                    buf.append(" cannot be loaded in supplied classloader ").append(classLoader).append("\n");
                }
            }
            throw new GBeanInfoFactoryException(buf.toString(), e);
        }
        try {
            return (GBeanInfo)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new GBeanInfoFactoryException("Could not get GBeanInfo from class: " + className, e);
        }
    }
}

