/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.annotation;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.annotation.EncryptionSetting;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.GBeanAnnotationException;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.Persistent;
import org.apache.geronimo.gbean.annotation.Priority;
import org.apache.geronimo.gbean.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationGBeanInfoBuilder {
    private static final String DEFAULT_J2EE_TYPE = "GBean";
    private final Class gbeanClass;

    public AnnotationGBeanInfoBuilder(Class gbeanClass) {
        if (null == gbeanClass) {
            throw new IllegalArgumentException("gbeanClass is required");
        }
        this.gbeanClass = gbeanClass;
    }

    public GBeanInfo buildGBeanInfo() throws GBeanAnnotationException {
        String name = this.getName();
        String j2eeType = this.getJ2eeyType();
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(name, this.gbeanClass, j2eeType);
        this.setPriority(infoBuilder);
        this.setConstructor(infoBuilder);
        this.markPersistent(infoBuilder);
        this.addReferences(infoBuilder);
        return infoBuilder.getBeanInfo();
    }

    protected void setPriority(GBeanInfoBuilder infoBuilder) {
        Priority priority = this.gbeanClass.getAnnotation(Priority.class);
        if (null == priority) {
            return;
        }
        infoBuilder.setPriority(priority.priority());
    }

    protected void setConstructor(GBeanInfoBuilder infoBuilder) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = this.gbeanClass.getDeclaredConstructors()) {
            Annotation[] paramAnnotations;
            Annotation[][] paramsAnnotations = constructor.getParameterAnnotations();
            if (0 >= paramsAnnotations.length) continue;
            for (Annotation paramAnnotation : paramAnnotations = paramsAnnotations[0]) {
                if (!(paramAnnotation instanceof ParamAttribute) && !(paramAnnotation instanceof ParamReference) && !(paramAnnotation instanceof ParamSpecial)) continue;
                this.setConstructor(infoBuilder, constructor);
                return;
            }
        }
        try {
            this.gbeanClass.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new GBeanAnnotationException("Missing default constructor");
        }
        infoBuilder.setConstructor(new String[0]);
    }

    protected void setConstructor(GBeanInfoBuilder infoBuilder, Constructor constructor) {
        Class<?>[] types = constructor.getParameterTypes();
        Type[] genericTypes = constructor.getGenericParameterTypes();
        Annotation[][] parametersAnnotations = constructor.getParameterAnnotations();
        String[] cstrNames = new String[types.length];
        int index = 0;
        for (Annotation[] paramterAnnotations : parametersAnnotations) {
            Class<?> parameterType = types[index];
            boolean annotationFound = false;
            for (Annotation parameterAnnotation : paramterAnnotations) {
                String name;
                Annotation attribute;
                if (parameterAnnotation instanceof ParamAttribute) {
                    attribute = (ParamAttribute)parameterAnnotation;
                    name = attribute.name();
                    boolean persistent = attribute.persistent();
                    boolean manageable = attribute.manageable();
                    if (attribute.encrypted() == EncryptionSetting.ENCRYPTED) {
                        infoBuilder.addAttribute(name, parameterType, persistent, manageable, true);
                    } else if (attribute.encrypted() == EncryptionSetting.PLAINTEXT) {
                        infoBuilder.addAttribute(name, parameterType, persistent, manageable, false);
                    } else {
                        infoBuilder.addAttribute(name, parameterType, persistent, manageable);
                    }
                    cstrNames[index] = name;
                    annotationFound = true;
                    break;
                }
                if (parameterAnnotation instanceof ParamSpecial) {
                    attribute = (ParamSpecial)parameterAnnotation;
                    name = attribute.type().name();
                    infoBuilder.addAttribute(name, parameterType, false);
                    cstrNames[index] = name;
                    annotationFound = true;
                    break;
                }
                if (!(parameterAnnotation instanceof ParamReference)) continue;
                ParamReference reference = (ParamReference)parameterAnnotation;
                name = reference.name();
                Class referenceType = this.getGenericActualType(genericTypes[index], parameterType);
                String namingType = reference.namingType();
                infoBuilder.addReference(name, referenceType, namingType);
                cstrNames[index] = name;
                annotationFound = true;
                break;
            }
            if (!annotationFound) {
                throw new GBeanAnnotationException("Missing constructor parameter annotation for constructor [" + constructor + "] at index [" + index + "]");
            }
            ++index;
        }
        infoBuilder.setConstructor(cstrNames);
    }

    protected Set<Method> filterSettersByAnnotation(Class annotationClass) {
        Method[] methods;
        HashSet<Method> filteredMethods = new HashSet<Method>();
        for (Method method : methods = this.gbeanClass.getMethods()) {
            if (null == method.getAnnotation(annotationClass)) continue;
            if (this.isNotSetter(method)) {
                throw new GBeanAnnotationException("[" + method + "] is not a setter and annotated with [" + annotationClass + "]");
            }
            filteredMethods.add(method);
        }
        return filteredMethods;
    }

    protected void markPersistent(GBeanInfoBuilder infoBuilder) {
        Set<Method> methods = this.filterSettersByAnnotation(Persistent.class);
        for (Method method : methods) {
            Persistent persistent = method.getAnnotation(Persistent.class);
            Class<?> type = method.getParameterTypes()[0];
            String name = this.getName(method);
            name = Introspector.decapitalize(name);
            if (persistent.encrypted() == EncryptionSetting.ENCRYPTED) {
                infoBuilder.addAttribute(name, type, true, persistent.manageable(), true);
                continue;
            }
            if (persistent.encrypted() == EncryptionSetting.PLAINTEXT) {
                infoBuilder.addAttribute(name, type, true, persistent.manageable(), false);
                continue;
            }
            infoBuilder.addAttribute(name, type, true, persistent.manageable());
        }
    }

    protected void addReferences(GBeanInfoBuilder infoBuilder) {
        Set<Method> methods = this.filterSettersByAnnotation(Reference.class);
        for (Method method : methods) {
            Reference reference = method.getAnnotation(Reference.class);
            Class<?> type = method.getParameterTypes()[0];
            Class referenceType = this.getGenericActualType(method.getGenericParameterTypes()[0], type);
            String name = this.getName(method);
            GReferenceInfo referenceInfo = new GReferenceInfo(name, referenceType.getName(), type.getName(), method.getName(), reference.namingType());
            infoBuilder.addReference(referenceInfo);
        }
    }

    protected Class getGenericActualType(Type genericType, Class parameterType) {
        if (Collection.class.isAssignableFrom(parameterType)) {
            if (genericType instanceof ParameterizedType) {
                Type[] upper;
                ParameterizedType parameterizedType = (ParameterizedType)genericType;
                Type componentType = parameterizedType.getActualTypeArguments()[0];
                if (componentType instanceof Class) {
                    return (Class)componentType;
                }
                if (componentType instanceof WildcardType && (upper = ((WildcardType)componentType).getUpperBounds()).length == 1 && upper[0] instanceof Class) {
                    return (Class)upper[0];
                }
                throw new GBeanAnnotationException("Generic type is not a class: " + componentType);
            }
            throw new GBeanAnnotationException(Collection.class + " parameter must be generified");
        }
        return parameterType;
    }

    protected String getName() {
        GBean bean = this.gbeanClass.getAnnotation(GBean.class);
        if (null == bean) {
            return this.gbeanClass.getSimpleName();
        }
        String name = bean.name();
        if (name.equals("")) {
            name = this.gbeanClass.getSimpleName();
        }
        return name;
    }

    protected String getJ2eeyType() {
        GBean bean = this.gbeanClass.getAnnotation(GBean.class);
        if (null == bean) {
            return DEFAULT_J2EE_TYPE;
        }
        return bean.j2eeType();
    }

    protected String getName(Method method) {
        return method.getName().substring(3);
    }

    protected boolean isNotSetter(Method method) {
        return !method.getName().startsWith("set") || method.getParameterTypes().length != 1;
    }
}

