/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.basic;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.reflect.FastClass;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.basic.BasicProxyMap;
import org.apache.geronimo.kernel.basic.ProxyMethodInterceptor;
import org.apache.geronimo.kernel.proxy.ProxyCreationException;
import org.apache.geronimo.kernel.proxy.ProxyFactory;
import org.apache.geronimo.kernel.proxy.ProxyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicProxyManager
implements ProxyManager {
    private static final String MANAGED_BEAN_NAME = "org.apache.geronimo.kernel.proxy.GeronimoManagedBean";
    private static final Logger log = LoggerFactory.getLogger(BasicProxyManager.class);
    private final Kernel kernel;
    private final Map interceptors = Collections.synchronizedMap(new BasicProxyMap());

    public BasicProxyManager(Kernel kernel) {
        this.kernel = kernel;
    }

    @Override
    public ProxyFactory createProxyFactory(Class[] types, ClassLoader classLoader) {
        if (types == null) {
            throw new NullPointerException("type is null");
        }
        if (types.length == 0) {
            throw new IllegalArgumentException("interface list is empty");
        }
        if (classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        Class<?> managedBean = null;
        try {
            managedBean = classLoader.loadClass(MANAGED_BEAN_NAME);
        }
        catch (ClassNotFoundException e) {
            log.debug("Unable to add GeronimoManagedBean to proxy (specified class loader does not have class)");
        }
        if (managedBean != null) {
            Class[] adjusted = new Class[types.length + 1];
            System.arraycopy(types, 0, adjusted, 0, types.length);
            adjusted[types.length] = managedBean;
            types = adjusted;
        }
        return new ManagedProxyFactory(types, classLoader);
    }

    @Override
    public <T> T createProxy(AbstractName target, Class<T> type) {
        if (target == null) {
            throw new NullPointerException("target is null");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        try {
            ClassLoader classLoader;
            try {
                classLoader = this.kernel.getClassLoaderFor(target);
                if (!type.equals(ClassLoading.loadClass(type.getName(), classLoader))) {
                    classLoader = type.getClassLoader();
                }
            }
            catch (Exception ignored) {
                classLoader = type.getClassLoader();
            }
            ArrayList<Class<Class>> types = this.getVisibleInterfaces(target, classLoader, true);
            if (types == null) {
                types = new ArrayList<Class<Class>>();
            }
            types.add(type);
            return (T)this.createProxyFactory(types.toArray(new Class[types.size()]), classLoader).createProxy(target);
        }
        catch (GBeanNotFoundException e) {
            throw new IllegalArgumentException("Could not get GBeanInfo for target object: " + target, e);
        }
    }

    @Override
    public Object createProxy(AbstractName target, ClassLoader classLoader) {
        if (target == null) {
            throw new NullPointerException("target is null");
        }
        if (classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        try {
            List types = this.getVisibleInterfaces(target, classLoader, true);
            if (types == null) {
                return null;
            }
            return this.createProxyFactory(types.toArray(new Class[types.size()]), classLoader).createProxy(target);
        }
        catch (GBeanNotFoundException e) {
            throw new IllegalArgumentException("Could not get GBeanInfo for target object: " + target, e);
        }
    }

    private List getVisibleInterfaces(AbstractName target, ClassLoader classLoader, boolean shouldLog) throws GBeanNotFoundException {
        GBeanInfo info = this.kernel.getGBeanInfo(target);
        Set<String> interfaces = info.getInterfaces();
        if (interfaces.size() == 0) {
            if (shouldLog) {
                log.warn("No interfaces found for " + target + " (" + target + ")");
            }
            return null;
        }
        String[] names = interfaces.toArray(new String[0]);
        ArrayList types = new ArrayList();
        for (int i = 0; i < names.length; ++i) {
            try {
                Class<?> type = classLoader.loadClass(names[i]);
                if (!type.isInterface()) continue;
                types.add(type);
                continue;
            }
            catch (ClassNotFoundException e) {
                if (!shouldLog) continue;
                log.warn("Could not load interface " + names[i] + " in provided ClassLoader for " + target);
            }
        }
        return types;
    }

    @Override
    public void destroyProxy(Object proxy) {
        if (proxy == null) {
            return;
        }
        MethodInterceptor methodInterceptor = (MethodInterceptor)this.interceptors.remove(proxy);
        if (methodInterceptor != null) {
            this.doDestroy(methodInterceptor);
        }
    }

    @Override
    public boolean isProxy(Object proxy) {
        return this.interceptors.containsKey(proxy);
    }

    @Override
    public AbstractName getProxyTarget(Object proxy) {
        MethodInterceptor methodInterceptor = (MethodInterceptor)this.interceptors.get(proxy);
        if (methodInterceptor == null) {
            return null;
        }
        return this.getAbstractName(methodInterceptor);
    }

    protected Callback getMethodInterceptor(Class proxyType, Kernel kernel, AbstractName target) {
        return new ProxyMethodInterceptor(proxyType, kernel, target);
    }

    protected void doDestroy(MethodInterceptor methodInterceptor) {
        ((ProxyMethodInterceptor)methodInterceptor).destroy();
    }

    protected AbstractName getAbstractName(MethodInterceptor methodInterceptor) {
        return ((ProxyMethodInterceptor)methodInterceptor).getAbstractName();
    }

    private class ManagedProxyFactory
    implements ProxyFactory {
        private final Class proxyType;
        private final FastClass fastClass;

        public ManagedProxyFactory(Class type, ClassLoader classLoader) {
            this(new Class[]{type}, classLoader);
        }

        public ManagedProxyFactory(Class[] type, ClassLoader classLoader) {
            Enhancer enhancer = new Enhancer();
            if (type.length > 1) {
                type = ClassLoading.reduceInterfaces(type);
            }
            if (type.length == 0) {
                throw new IllegalArgumentException("Cannot generate proxy for 0 interfaces!");
            }
            if (type.length == 1) {
                enhancer.setSuperclass(type[0]);
            } else if (type[0].isInterface()) {
                enhancer.setSuperclass(Object.class);
                enhancer.setInterfaces(type);
            } else {
                Class[] intfs = new Class[type.length - 1];
                System.arraycopy(type, 1, intfs, 0, intfs.length);
                enhancer.setSuperclass(type[0]);
                enhancer.setInterfaces(intfs);
            }
            enhancer.setClassLoader(classLoader);
            enhancer.setCallbackType(MethodInterceptor.class);
            enhancer.setUseFactory(false);
            this.proxyType = enhancer.createClass();
            this.fastClass = FastClass.create((Class)this.proxyType);
        }

        public Object createProxy(AbstractName target) {
            assert (target != null) : "target is null";
            Callback callback = BasicProxyManager.this.getMethodInterceptor(this.proxyType, BasicProxyManager.this.kernel, target);
            try {
                Enhancer.registerCallbacks((Class)this.proxyType, (Callback[])new Callback[]{callback});
                Object proxy = this.fastClass.newInstance();
                BasicProxyManager.this.interceptors.put(proxy, callback);
                Object object = proxy;
                return object;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                if (cause != null) {
                    throw new ProxyCreationException(cause);
                }
                throw new ProxyCreationException(e);
            }
            finally {
                Enhancer.registerCallbacks((Class)this.proxyType, null);
            }
        }
    }
}

