/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.geronimo.kernel.config.MultiParentClassLoader;
import org.apache.geronimo.kernel.repository.ClassLoadingRule;
import org.apache.geronimo.kernel.repository.ClassLoadingRules;
import sun.misc.CompoundEnumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildrenConfigurationClassLoader
extends SecureClassLoader {
    private final ClassLoadingRules rules;

    public ChildrenConfigurationClassLoader(ClassLoader parent, ClassLoadingRules rules) {
        super(parent);
        if (null == rules) {
            throw new IllegalArgumentException("rules is required");
        }
        this.rules = rules;
    }

    public Class<?> loadClass(String name, List<ClassLoader> visitedClassLoaders) throws ClassNotFoundException {
        return this.loadClass(name, false, visitedClassLoaders);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, resolve, Collections.EMPTY_LIST);
    }

    protected synchronized Class<?> loadClass(String name, boolean resolve, List<ClassLoader> visitedClassLoaders) throws ClassNotFoundException {
        ClassLoadingRule privateRule = this.rules.getPrivateRule();
        ClassLoader parent = this.getParent();
        if (privateRule.isFilteredClass(name)) {
            throw new ClassNotFoundException(name + " is hidden by classloader " + parent);
        }
        if (parent instanceof MultiParentClassLoader) {
            try {
                return ((MultiParentClassLoader)parent).loadClassInternal(name, resolve, visitedClassLoaders);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public URL getResource(String name) {
        ClassLoadingRule privateRule = this.rules.getPrivateRule();
        if (privateRule.isFilteredResource(name)) {
            return null;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ClassLoadingRule privateRule = this.rules.getPrivateRule();
        if (privateRule.isFilteredResource(name)) {
            return new CompoundEnumeration(new Enumeration[0]);
        }
        return super.getResources(name);
    }

    public String toString() {
        return this.getClass().getName() + " wrapping " + this.getParent().toString();
    }
}

