/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.beans.Introspector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geronimo.kernel.classloader.UnionEnumeration;
import org.apache.geronimo.kernel.config.ChildrenConfigurationClassLoader;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ClassLoadingRule;
import org.apache.geronimo.kernel.repository.ClassLoadingRules;
import org.apache.geronimo.kernel.util.ClassLoaderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiParentClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(MultiParentClassLoader.class);
    private final Artifact id;
    private final ClassLoader[] parents;
    private final ClassLoadingRules classLoadingRules;
    private boolean destroyed = false;
    private Map<String, Object> resourcesNotFound = new ConcurrentHashMap<String, Object>();
    private static final int classLoaderSearchMode;
    private static final int ORIGINAL_SEARCH = 1;
    private static final int OPTIMIZED_SEARCH = 2;
    private static final boolean LONG_CLASSLOADER_TO_STRING = false;
    private static final Object lock;
    private static boolean clearSoftCacheFailed;

    public MultiParentClassLoader(Artifact id, URL[] urls) {
        super(urls);
        this.id = id;
        this.parents = new ClassLoader[]{ClassLoader.getSystemClassLoader()};
        this.classLoadingRules = new ClassLoadingRules();
        ClassLoaderRegistry.add(this);
    }

    public MultiParentClassLoader(Artifact id, URL[] urls, ClassLoader parent) {
        this(id, urls, new ClassLoader[]{parent});
    }

    public MultiParentClassLoader(Artifact id, URL[] urls, ClassLoader parent, ClassLoadingRules classLoadingRules) {
        this(id, urls, new ClassLoader[]{parent}, classLoadingRules);
    }

    public MultiParentClassLoader(Artifact id, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        this(id, urls, new ClassLoader[]{parent}, factory);
    }

    public MultiParentClassLoader(Artifact id, URL[] urls, ClassLoader[] parents) {
        super(urls);
        this.id = id;
        this.parents = MultiParentClassLoader.copyParents(parents);
        this.classLoadingRules = new ClassLoadingRules();
        ClassLoaderRegistry.add(this);
    }

    public MultiParentClassLoader(Artifact id, URL[] urls, ClassLoader[] parents, ClassLoadingRules classLoadingRules) {
        super(urls);
        this.id = id;
        this.parents = MultiParentClassLoader.copyParents(parents);
        this.classLoadingRules = classLoadingRules;
        ClassLoaderRegistry.add(this);
    }

    public MultiParentClassLoader(MultiParentClassLoader source) {
        this(source.id, source.getURLs(), MultiParentClassLoader.deepCopyParents(source.parents), source.classLoadingRules);
    }

    static ClassLoader copy(ClassLoader source) {
        if (source instanceof MultiParentClassLoader) {
            return new MultiParentClassLoader((MultiParentClassLoader)source);
        }
        if (source instanceof URLClassLoader) {
            return new URLClassLoader(((URLClassLoader)source).getURLs(), source.getParent());
        }
        return new URLClassLoader(new URL[0], source);
    }

    ClassLoader copy() {
        return MultiParentClassLoader.copy(this);
    }

    public MultiParentClassLoader(Artifact id, URL[] urls, ClassLoader[] parents, URLStreamHandlerFactory factory) {
        super(urls, null, factory);
        this.id = id;
        this.parents = MultiParentClassLoader.copyParents(parents);
        this.classLoadingRules = new ClassLoadingRules();
        ClassLoaderRegistry.add(this);
    }

    private static ClassLoader[] copyParents(ClassLoader[] parents) {
        ClassLoader[] newParentsArray = new ClassLoader[parents.length];
        for (int i = 0; i < parents.length; ++i) {
            ClassLoader parent = parents[i];
            if (parent == null) {
                throw new NullPointerException("parent[" + i + "] is null");
            }
            newParentsArray[i] = parent;
        }
        return newParentsArray;
    }

    private static ClassLoader[] deepCopyParents(ClassLoader[] parents) {
        ClassLoader[] newParentsArray = new ClassLoader[parents.length];
        for (int i = 0; i < parents.length; ++i) {
            ClassLoader parent = parents[i];
            if (parent == null) {
                throw new NullPointerException("parent[" + i + "] is null");
            }
            if (parent instanceof MultiParentClassLoader) {
                parent = ((MultiParentClassLoader)parent).copy();
            }
            newParentsArray[i] = parent;
        }
        return newParentsArray;
    }

    public Artifact getId() {
        return this.id;
    }

    public ClassLoader[] getParents() {
        return this.parents;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (classLoaderSearchMode == 1) {
            return this.loadSafeClass(name, resolve);
        }
        return this.loadOptimizedClass(name, resolve);
    }

    protected synchronized Class<?> loadSafeClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cachedClass = this.findLoadedClass(name);
        if (cachedClass != null) {
            return this.resolveClass(cachedClass, resolve);
        }
        if (name.startsWith("java.")) {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(name);
            return this.resolveClass(clazz, resolve);
        }
        if (this.classLoadingRules.isInverseClassLoading() && !this.isDestroyed() && !this.isNonOverridableClass(name)) {
            try {
                Class<?> clazz = this.findClass(name);
                return this.resolveClass(clazz, resolve);
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        if (!this.isHiddenClass(name)) {
            for (ClassLoader parent : this.parents) {
                try {
                    Class<?> clazz = parent.loadClass(name);
                    return this.resolveClass(clazz, resolve);
                }
                catch (ClassNotFoundException ignored) {
                }
            }
        }
        if (!this.isDestroyed()) {
            try {
                Class<?> clazz = this.findClass(name);
                return this.resolveClass(clazz, resolve);
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name + " in classloader " + this.id);
    }

    protected synchronized Class<?> loadOptimizedClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cachedClass = this.findLoadedClass(name);
        if (cachedClass != null) {
            return this.resolveClass(cachedClass, resolve);
        }
        if (name.startsWith("java.")) {
            try {
                return this.resolveClass(this.findSystemClass(name), resolve);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        if (this.classLoadingRules.isInverseClassLoading() && !this.isDestroyed() && !this.isNonOverridableClass(name)) {
            try {
                Class<?> clazz = this.findClass(name);
                return this.resolveClass(clazz, resolve);
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        if (!this.isHiddenClass(name)) {
            try {
                LinkedList<ClassLoader> visitedClassLoaders = new LinkedList<ClassLoader>();
                Class<?> clazz = this.checkParents(name, resolve, visitedClassLoaders);
                if (clazz != null) {
                    return this.resolveClass(clazz, resolve);
                }
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        if (!this.isDestroyed()) {
            try {
                Class<?> clazz = this.findClass(name);
                return this.resolveClass(clazz, resolve);
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name + " in classloader " + this.id);
    }

    protected synchronized Class<?> loadClassInternal(String name, boolean resolve, List<ClassLoader> visitedClassLoaders) throws ClassNotFoundException, MalformedURLException {
        Class<?> clazz;
        Class<?> cachedClass = this.findLoadedClass(name);
        if (cachedClass != null) {
            return this.resolveClass(cachedClass, resolve);
        }
        if (!this.isHiddenClass(name)) {
            try {
                clazz = this.checkParents(name, resolve, visitedClassLoaders);
                if (clazz != null) {
                    return this.resolveClass(clazz, resolve);
                }
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        if (!this.isDestroyed()) {
            clazz = this.findClass(name);
            return this.resolveClass(clazz, resolve);
        }
        return null;
    }

    private synchronized Class<?> checkParents(String name, boolean resolve, List<ClassLoader> visitedClassLoaders) throws ClassNotFoundException {
        for (ClassLoader parent : this.parents) {
            if (visitedClassLoaders.contains(parent)) continue;
            visitedClassLoaders.add(parent);
            try {
                Class<?> clazz;
                if (parent instanceof MultiParentClassLoader) {
                    clazz = ((MultiParentClassLoader)parent).loadClassInternal(name, resolve, visitedClassLoaders);
                    if (clazz == null) continue;
                    return this.resolveClass(clazz, resolve);
                }
                if (parent instanceof ChildrenConfigurationClassLoader) {
                    clazz = ((ChildrenConfigurationClassLoader)parent).loadClass(name, visitedClassLoaders);
                    if (clazz == null) continue;
                    return this.resolveClass(clazz, resolve);
                }
                return parent.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (MalformedURLException me) {
                log.debug("Failed findClass for {}", (Object)name, (Object)me);
            }
        }
        return null;
    }

    private boolean isNonOverridableClass(String name) {
        ClassLoadingRule nonOverrideableRule = this.classLoadingRules.getNonOverrideableRule();
        return nonOverrideableRule.isFilteredClass(name);
    }

    private boolean isHiddenClass(String name) {
        ClassLoadingRule hiddenRule = this.classLoadingRules.getHiddenRule();
        return hiddenRule.isFilteredClass(name);
    }

    private Class resolveClass(Class clazz, boolean resolve) {
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        URL url;
        if (this.isDestroyed() || this.resourcesNotFound.containsKey(name)) {
            return null;
        }
        if (this.classLoadingRules.isInverseClassLoading() && !this.isDestroyed() && !this.isNonOverridableResource(name) && (url = this.findResource(name)) != null) {
            return url;
        }
        if (!this.isHiddenResource(name)) {
            for (ClassLoader parent : this.parents) {
                URL url2 = parent.getResource(name);
                if (url2 == null) continue;
                return url2;
            }
        }
        if (!this.isDestroyed() && (url = this.findResource(name)) != null) {
            return url;
        }
        this.resourcesNotFound.put(name, name);
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        if (this.isDestroyed()) {
            return Collections.enumeration(Collections.EMPTY_SET);
        }
        HashSet<ClassLoader> knownClassloaders = new HashSet<ClassLoader>();
        ArrayList enumerations = new ArrayList();
        this.recursiveFind(knownClassloaders, enumerations, name);
        return new UnionEnumeration<URL>(enumerations);
    }

    protected void recursiveFind(Set<ClassLoader> knownClassloaders, List<Enumeration<URL>> enumerations, String name) throws IOException {
        if (this.isDestroyed() || knownClassloaders.contains(this)) {
            return;
        }
        knownClassloaders.add(this);
        if (this.classLoadingRules.isInverseClassLoading() && !this.isNonOverridableResource(name)) {
            enumerations.add(this.internalfindResources(name));
        }
        if (!this.isHiddenResource(name)) {
            for (ClassLoader parent : this.parents) {
                if (parent instanceof MultiParentClassLoader) {
                    ((MultiParentClassLoader)parent).recursiveFind(knownClassloaders, enumerations, name);
                    continue;
                }
                if (knownClassloaders.contains(parent)) continue;
                enumerations.add(parent.getResources(name));
                knownClassloaders.add(parent);
            }
        }
        if (!this.classLoadingRules.isInverseClassLoading()) {
            enumerations.add(this.internalfindResources(name));
        }
    }

    protected Enumeration<URL> internalfindResources(String name) throws IOException {
        return super.findResources(name);
    }

    private boolean isNonOverridableResource(String name) {
        ClassLoadingRule nonOverrideableRule = this.classLoadingRules.getNonOverrideableRule();
        return nonOverrideableRule.isFilteredResource(name);
    }

    private boolean isHiddenResource(String name) {
        ClassLoadingRule hiddenRule = this.classLoadingRules.getHiddenRule();
        return hiddenRule.isFilteredResource(name);
    }

    public static Set<ClassLoader> getAncestors(ClassLoader cl) {
        HashSet<ClassLoader> ancestors = new HashSet<ClassLoader>();
        MultiParentClassLoader.getAncestorsInternal(ancestors, cl);
        return ancestors;
    }

    private static void getAncestorsInternal(Set<ClassLoader> ancestors, ClassLoader childClassLoader) {
        if (childClassLoader == null) {
            return;
        }
        if (childClassLoader instanceof MultiParentClassLoader) {
            for (ClassLoader cl : ((MultiParentClassLoader)childClassLoader).parents) {
                ancestors.add(cl);
                MultiParentClassLoader.getAncestorsInternal(ancestors, cl);
            }
        } else {
            ClassLoader cl = childClassLoader.getParent();
            ancestors.add(cl);
            MultiParentClassLoader.getAncestorsInternal(ancestors, cl);
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[").append(this.getClass().getName()).append(" id=").append(this.id).append("]");
        return b.toString();
    }

    private void toBuilder(StringBuilder b, String indent) {
        b.append(indent).append("[").append(this.getClass().getName()).append(" id=").append(this.id).append("]\n");
        b.append(indent).append("urls:\n");
        String newIndent = indent + "  ";
        for (URL url : this.getURLs()) {
            b.append(newIndent).append(url).append("\n");
        }
        b.append(indent).append("parents:\n");
        for (ClassLoader cl : this.parents) {
            if (cl instanceof MultiParentClassLoader) {
                ((MultiParentClassLoader)cl).toBuilder(b, newIndent);
                continue;
            }
            b.append(newIndent).append(cl.toString()).append("\n");
        }
    }

    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        MultiParentClassLoader multiParentClassLoader = this;
        synchronized (multiParentClassLoader) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        MultiParentClassLoader.clearSoftCache(ObjectInputStream.class, "subclassAudits");
        MultiParentClassLoader.clearSoftCache(ObjectOutputStream.class, "subclassAudits");
        MultiParentClassLoader.clearSoftCache(ObjectStreamClass.class, "localDescs");
        MultiParentClassLoader.clearSoftCache(ObjectStreamClass.class, "reflectors");
        Introspector.flushCaches();
        ClassLoaderRegistry.remove(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearSoftCache(Class clazz, String fieldName) {
        Map cache = null;
        try {
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            cache = (Map)f.get(null);
        }
        catch (Throwable e) {
            Object object = lock;
            synchronized (object) {
                if (!clearSoftCacheFailed) {
                    clearSoftCacheFailed = true;
                    LoggerFactory.getLogger(MultiParentClassLoader.class).debug("Unable to clear SoftCache field {} in class {}", (Object)fieldName, (Object)clazz);
                }
            }
        }
        if (cache != null) {
            Map map = cache;
            synchronized (map) {
                cache.clear();
            }
        }
    }

    protected void finalize() throws Throwable {
        ClassLoaderRegistry.remove(this);
        super.finalize();
    }

    static {
        String mode = System.getProperty("Xorg.apache.geronimo.kernel.config.MPCLSearchOption");
        int runtimeMode = 2;
        String runtimeModeMessage = "Original Classloading";
        if (mode != null) {
            if (mode.equals("safe")) {
                runtimeMode = 1;
                runtimeModeMessage = "Safe ClassLoading";
            } else if (mode.equals("optimized")) {
                runtimeMode = 2;
            }
        }
        classLoaderSearchMode = runtimeMode;
        LoggerFactory.getLogger(MultiParentClassLoader.class).info("ClassLoading behaviour has changed.  The " + runtimeModeMessage + " mode is in effect.  If you are experiencing a problem\n" + "you can change the behaviour by specifying -DXorg.apache.geronimo.kernel.config.MPCLSearchOption= property.  Specify \n" + "=\"safe\" to revert to the original behaviour.  This is a temporary change until we decide whether or not to make it\n" + "permanent for the 2.0 release");
        lock = new Object();
        clearSoftCacheFailed = false;
    }
}

