/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationDataTransformer;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.GBeanState;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.Manifest;
import org.apache.geronimo.kernel.config.ManifestException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ConfigurationData
implements Serializable {
    private static final long serialVersionUID = 4324193220056650732L;
    private final long created = System.currentTimeMillis();
    private final ConfigurationModuleType moduleType;
    private final Environment environment;
    private final GBeanState gbeanState;
    private final Map<String, ConfigurationData> childConfigurations = new LinkedHashMap<String, ConfigurationData>();
    private final Set<Artifact> ownedConfigurations = new LinkedHashSet<Artifact>();
    private transient File configurationDir;
    private File inPlaceConfigurationDir;
    private boolean autoStart = true;
    private transient Naming naming;
    private transient ConfigurationStore configurationStore;
    private transient ConfigurationDataTransformer configurationDataTransformer;
    private transient BundleContext bundleContext;
    private transient boolean useEnvironment;

    public ConfigurationData(Artifact configId, Naming naming, GBeanState gbeanState) {
        this(new Environment(configId), naming, gbeanState);
    }

    public ConfigurationData(Environment environment, Naming naming, GBeanState gbeanState) {
        if (environment == null) {
            throw new NullPointerException("environment is null");
        }
        if (environment.getConfigId() == null) {
            throw new NullPointerException("environment.configId is null");
        }
        if (naming == null) {
            throw new NullPointerException("naming is null");
        }
        this.environment = environment;
        this.naming = naming;
        this.gbeanState = gbeanState;
        this.moduleType = ConfigurationModuleType.CAR;
    }

    public ConfigurationData(Artifact configId, Naming naming) {
        this(new Environment(configId), naming);
    }

    public ConfigurationData(Environment environment, Naming naming) {
        this(null, null, null, environment, null, null, naming);
    }

    public ConfigurationData(ConfigurationModuleType moduleType, List<GBeanData> gbeans, Map<String, ConfigurationData> childConfigurations, Environment environment, File configurationDir, File inPlaceConfigurationDir, Naming naming) {
        if (naming == null) {
            throw new NullPointerException("naming is null");
        }
        if (environment == null) {
            throw new NullPointerException("environment is null");
        }
        if (environment.getConfigId() == null) {
            throw new NullPointerException("environment.configId is null");
        }
        this.naming = naming;
        this.moduleType = moduleType != null ? moduleType : ConfigurationModuleType.CAR;
        this.gbeanState = ConfigurationUtil.newGBeanState(gbeans);
        if (childConfigurations != null) {
            this.childConfigurations.putAll(childConfigurations);
        }
        this.environment = environment;
        this.configurationDir = configurationDir;
        this.inPlaceConfigurationDir = inPlaceConfigurationDir;
    }

    public Artifact getId() {
        return this.environment.getConfigId();
    }

    public long getCreated() {
        return this.created;
    }

    public ConfigurationModuleType getModuleType() {
        return this.moduleType;
    }

    public Manifest getManifest() throws ManifestException {
        return this.environment.getManifest();
    }

    public List<GBeanData> getGBeans(Bundle bundle) throws InvalidConfigException {
        if (bundle == null) {
            throw new NullPointerException("bundle is null");
        }
        List<GBeanData> gbeans = this.gbeanState.getGBeans(bundle);
        if (null == this.configurationDataTransformer) {
            return gbeans;
        }
        return gbeans;
    }

    public void addGBean(GBeanData gbeanData) {
        if (gbeanData == null) {
            throw new NullPointerException("gbeanData is null");
        }
        this.gbeanState.addGBean(gbeanData);
    }

    public GBeanData addGBean(String name, GBeanInfo gbeanInfo) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (gbeanInfo == null) {
            throw new NullPointerException("gbeanInfo is null");
        }
        return this.gbeanState.addGBean(name, gbeanInfo, this.naming, this.environment);
    }

    public GBeanData addGBean(String name, Class gbeanClass) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (gbeanClass == null) {
            throw new NullPointerException("gbeanInfo is null");
        }
        return this.gbeanState.addGBean(name, gbeanClass, this.naming, this.environment);
    }

    public GBeanState getGbeanState() {
        return this.gbeanState;
    }

    public BundleContext getBundleContext() {
        if (this.bundleContext == null) {
            throw new NullPointerException("bundleContext is null in configurationData: " + this.getId());
        }
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Map<String, ConfigurationData> getChildConfigurations() {
        return Collections.unmodifiableMap(this.childConfigurations);
    }

    public void addChildConfiguration(String moduleName, ConfigurationData configurationData) {
        if (configurationData == null) {
            throw new NullPointerException("configurationData is null");
        }
        this.childConfigurations.put(moduleName, configurationData);
    }

    public Set<Artifact> getOwnedConfigurations() {
        return Collections.unmodifiableSet(this.ownedConfigurations);
    }

    public void addOwnedConfigurations(Artifact id) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        if (!id.isResolved()) {
            throw new IllegalArgumentException("id is not resolved: " + id);
        }
        this.ownedConfigurations.add(id);
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public File getInPlaceConfigurationDir() {
        return this.inPlaceConfigurationDir;
    }

    public File getConfigurationDir() {
        return this.configurationDir;
    }

    public void setConfigurationDir(File configurationDir) {
        if (configurationDir == null) {
            throw new NullPointerException("configurationDir is null");
        }
        this.configurationDir = configurationDir;
    }

    public Naming getNaming() {
        return this.naming;
    }

    public void setNaming(Naming naming) {
        this.naming = naming;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public ConfigurationStore getConfigurationStore() {
        return this.configurationStore;
    }

    public void setConfigurationStore(ConfigurationStore configurationStore) {
        if (configurationStore == null) {
            throw new NullPointerException("configurationStore is null");
        }
        this.configurationStore = configurationStore;
    }

    public ConfigurationDataTransformer getConfigurationDataTransformer() {
        return this.configurationDataTransformer;
    }

    public void setConfigurationDataTransformer(ConfigurationDataTransformer configurationDataTransformer) {
        this.configurationDataTransformer = configurationDataTransformer;
    }

    public boolean isUseEnvironment() {
        return this.useEnvironment;
    }

    public void setUseEnvironment(boolean useEnvironment) {
        this.useEnvironment = useEnvironment;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("ConfigurationData [");
        buf.append("\n  Environment: ").append(this.environment);
        buf.append("\n  ConfigurationDir: ").append(this.getConfigurationDir());
        buf.append("\n  autoStart: ").append(this.isAutoStart());
        for (Map.Entry<String, ConfigurationData> entry : this.getChildConfigurations().entrySet()) {
            buf.append("\n  Child at: ").append(entry.getKey()).append(entry.getValue());
        }
        return buf.toString();
    }
}

