/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.geronimo.kernel.config.Manifest;
import org.apache.geronimo.kernel.config.ManifestException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ClassLoadingRules;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.ImportType;

public class Environment
implements Serializable {
    private static final long serialVersionUID = 7075760873629376317L;
    private Artifact configId;
    private final LinkedHashSet<Dependency> dependencies = new LinkedHashSet();
    private final LinkedHashSet<String> bundleClassPath = new LinkedHashSet();
    private final LinkedHashSet<String> imports = new LinkedHashSet();
    private final LinkedHashSet<String> exports = new LinkedHashSet();
    private final LinkedHashSet<String> requireBundles = new LinkedHashSet();
    private final LinkedHashSet<String> dynamicImports = new LinkedHashSet();
    private String bundleActivator;
    private final ClassLoadingRules classLoadingRules;
    private boolean suppressDefaultEnvironment;

    public Environment() {
        this.classLoadingRules = new ClassLoadingRules();
    }

    public Environment(Artifact configId) {
        this.configId = configId;
        this.classLoadingRules = new ClassLoadingRules();
    }

    public Environment(Environment environment) {
        this.configId = environment.getConfigId();
        this.dependencies.addAll(environment.dependencies);
        this.bundleClassPath.addAll(environment.bundleClassPath);
        this.imports.addAll(environment.imports);
        this.exports.addAll(environment.exports);
        this.requireBundles.addAll(environment.requireBundles);
        this.dynamicImports.addAll(environment.dynamicImports);
        this.bundleActivator = environment.bundleActivator;
        this.suppressDefaultEnvironment = environment.isSuppressDefaultEnvironment();
        this.classLoadingRules = environment.classLoadingRules;
    }

    public Artifact getConfigId() {
        return this.configId;
    }

    public void setConfigId(Artifact configId) {
        this.configId = configId;
    }

    public List<Dependency> getDependencies() {
        return Collections.unmodifiableList(new ArrayList<Dependency>(this.dependencies));
    }

    public void addDependency(Artifact artifact, ImportType importType) {
        this.dependencies.add(new Dependency(artifact, importType));
    }

    public void addDependency(Dependency dependency) {
        this.dependencies.add(dependency);
    }

    public void addDependencies(Collection<Dependency> dependencies) {
        this.dependencies.addAll(dependencies);
    }

    public void setDependencies(Collection<Dependency> dependencies) {
        this.dependencies.clear();
        this.addDependencies(dependencies);
    }

    public ClassLoadingRules getClassLoadingRules() {
        return this.classLoadingRules;
    }

    public boolean isSuppressDefaultEnvironment() {
        return this.suppressDefaultEnvironment;
    }

    public void setSuppressDefaultEnvironment(boolean suppressDefaultEnvironment) {
        this.suppressDefaultEnvironment = suppressDefaultEnvironment;
    }

    public void addToBundleClassPath(Collection<String> bundleClassPath) {
        this.bundleClassPath.addAll(bundleClassPath);
    }

    public void addToBundleClassPath(String bundleClassPath) {
        this.bundleClassPath.add(bundleClassPath);
    }

    public void removeBundleClassPath(Collection<String> bundleClassPath) {
        this.bundleClassPath.removeAll(bundleClassPath);
    }

    public void removeBundleClassPath(String bundleClassPath) {
        this.bundleClassPath.remove(bundleClassPath);
    }

    public List<String> getBundleClassPath() {
        return Collections.unmodifiableList(new ArrayList<String>(this.bundleClassPath));
    }

    public void addImportPackages(Collection<String> imports) {
        this.imports.addAll(imports);
    }

    public void addImportPackage(String imports) {
        this.imports.add(imports);
    }

    public List<String> getImportPackages() {
        return Collections.unmodifiableList(new ArrayList<String>(this.imports));
    }

    public void addExportPackages(Collection<String> exports) {
        this.exports.addAll(exports);
    }

    public void addExportPackage(String exports) {
        this.exports.add(exports);
    }

    public void removeExportPackages(Collection<String> exports) {
        this.exports.removeAll(exports);
    }

    public void removeExportPackage(String exports) {
        this.exports.remove(exports);
    }

    public List<String> getExportPackages() {
        return Collections.unmodifiableList(new ArrayList<String>(this.exports));
    }

    public String getBundleActivator() {
        return this.bundleActivator;
    }

    public void setBundleActivator(String bundleActivator) {
        this.bundleActivator = bundleActivator;
    }

    public void addRequireBundles(Collection<String> symbolicNames) {
        this.requireBundles.addAll(symbolicNames);
    }

    public void addRequireBundle(String symbolicName) {
        this.requireBundles.add(symbolicName);
    }

    public void removeRequireBundles(Collection<String> symbolicNames) {
        this.requireBundles.removeAll(symbolicNames);
    }

    public void removeRequireBundle(String symbolicName) {
        this.requireBundles.remove(symbolicName);
    }

    public List<String> getRequireBundles() {
        return Collections.unmodifiableList(new ArrayList<String>(this.requireBundles));
    }

    public void addDynamicImportPackages(Collection<String> imports) {
        this.dynamicImports.addAll(imports);
    }

    public void addDynamicImportPackage(String imports) {
        this.dynamicImports.add(imports);
    }

    public void removeDynamicImportPackages(Collection<String> imports) {
        this.dynamicImports.removeAll(imports);
    }

    public void removeDynamicImportPackage(String imports) {
        this.dynamicImports.remove(imports);
    }

    public List<String> getDynamicImportPackages() {
        return Collections.unmodifiableList(new ArrayList<String>(this.dynamicImports));
    }

    public void removeImportPackage(String importPackage) {
        this.imports.remove(importPackage);
    }

    public void removeImportPackages(Collection<String> importPackages) {
        this.imports.removeAll(importPackages);
    }

    public Manifest getManifest() throws ManifestException {
        Manifest manifest = new Manifest();
        manifest.addConfiguredAttribute(new Manifest.Attribute("Bundle-ManifestVersion", "2"));
        manifest.addConfiguredAttribute(new Manifest.Attribute("Bundle-SymbolicName", this.configId.getGroupId() + "." + this.configId.getArtifactId()));
        String versionString = "" + this.configId.getVersion().getMajorVersion() + "." + this.configId.getVersion().getMinorVersion() + "." + this.configId.getVersion().getIncrementalVersion();
        if (this.configId.getVersion().getQualifier() != null) {
            versionString = versionString + "." + this.configId.getVersion().getQualifier().replaceAll("[^-_\\w]{1}", "_");
        }
        manifest.addConfiguredAttribute(new Manifest.Attribute("Bundle-Version", versionString));
        if (this.bundleActivator != null) {
            manifest.addConfiguredAttribute(new Manifest.Attribute("Bundle-Activator", this.bundleActivator));
        }
        if (!this.imports.isEmpty()) {
            manifest.addConfiguredAttribute(new Manifest.Attribute(Manifest.Attribute.Separator.COMMA, "Import-Package", this.imports));
        }
        if (!this.exports.isEmpty()) {
            manifest.addConfiguredAttribute(new Manifest.Attribute(Manifest.Attribute.Separator.COMMA, "Export-Package", this.exports));
        }
        if (!this.dynamicImports.isEmpty()) {
            manifest.addConfiguredAttribute(new Manifest.Attribute(Manifest.Attribute.Separator.COMMA, "DynamicImport-Package", this.dynamicImports));
        }
        if (!this.bundleClassPath.isEmpty()) {
            Manifest.Attribute bundleClassPath = new Manifest.Attribute(Manifest.Attribute.Separator.COMMA, "Bundle-ClassPath", this.bundleClassPath);
            manifest.addConfiguredAttribute(bundleClassPath);
        }
        if (!this.requireBundles.isEmpty()) {
            Manifest.Attribute requireBundle = new Manifest.Attribute(Manifest.Attribute.Separator.COMMA, "Require-Bundle", this.requireBundles);
            manifest.addConfiguredAttribute(requireBundle);
        }
        return manifest;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("Environment [");
        buf.append("\n  Id: ").append(this.getConfigId());
        buf.append("]\n");
        return buf.toString();
    }
}

