/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.annotation;

import java.io.Serializable;
import org.apache.geronimo.crypto.EncryptionManager;

public enum EncryptionSetting {
    ENCRYPTED{

        @Override
        public Object encrypt(Object plaintext) {
            if (plaintext == null) {
                return null;
            }
            if (plaintext.equals("")) {
                return "";
            }
            return EncryptionManager.encrypt((Serializable)((Object)((String)plaintext)));
        }

        @Override
        public Object decrypt(Object encrypted) {
            if (encrypted == null) {
                return null;
            }
            return EncryptionManager.decrypt((String)((String)encrypted));
        }
    }
    ,
    PLAINTEXT{

        @Override
        public Object encrypt(Object plaintext) {
            return plaintext;
        }

        @Override
        public Object decrypt(Object encrypted) {
            return encrypted;
        }
    }
    ,
    DEFAULT{

        @Override
        public Object encrypt(Object plaintext) {
            throw new RuntimeException("dont call this");
        }

        @Override
        public Object decrypt(Object encrypted) {
            throw new RuntimeException("dont call this");
        }
    };


    public abstract Object encrypt(Object var1);

    public abstract Object decrypt(Object var1);

    public static EncryptionSetting defaultEncryption(String name, String type) {
        if (name == null) {
            throw new NullPointerException("Name missing");
        }
        if (type == null) {
            throw new NullPointerException("type missing");
        }
        if (!String.class.getName().equals(type)) {
            return PLAINTEXT;
        }
        return name.toLowerCase().contains("password") || name.toLowerCase().contains("keystorepass") || name.toLowerCase().contains("truststorepass") ? ENCRYPTED : PLAINTEXT;
    }
}

