/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel;

import java.util.HashSet;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.kernel.KernelException;

public class GBeanNotFoundException
extends KernelException {
    private ObjectName gBeanName;
    private AbstractName abstractName;
    private Set<AbstractName> matches;

    public GBeanNotFoundException(ObjectName gBeanName) {
        super(gBeanName + " not found");
        this.gBeanName = gBeanName;
    }

    public GBeanNotFoundException(ObjectName gBeanName, Throwable cause) {
        super(gBeanName + " not found", cause);
        this.gBeanName = gBeanName;
    }

    public GBeanNotFoundException(AbstractName abstractName) {
        super(abstractName + " not found");
        this.abstractName = abstractName;
    }

    public GBeanNotFoundException(String message, Set patterns, Set<AbstractName> matches) {
        super(message + ": " + patterns + (matches == null ? " (no matches)" : " matches: " + matches));
        this.matches = matches == null ? null : new HashSet<AbstractName>(matches);
    }

    public GBeanNotFoundException(String message, Throwable cause) {
        super(message, cause);
    }

    public ObjectName getGBeanName() {
        return this.gBeanName;
    }

    public AbstractName getAbstractName() {
        return this.abstractName;
    }

    public boolean isGBeanName() {
        return this.gBeanName != null;
    }

    public boolean isAbstractName() {
        return this.abstractName != null;
    }

    public Set<AbstractName> getMatches() {
        return this.matches;
    }

    public boolean hasMatches() {
        return this.matches != null && this.matches.size() > 0;
    }
}

