/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProviderException;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.jacc.PolicyContext;
import org.apache.geronimo.security.Callers;
import org.apache.geronimo.security.Context;
import org.apache.geronimo.security.GeronimoSecurityPermission;
import org.apache.geronimo.security.IdentificationPrincipal;
import org.apache.geronimo.security.PrimaryRealmPrincipal;
import org.apache.geronimo.security.RealmPrincipal;
import org.apache.geronimo.security.SubjectId;
import org.apache.geronimo.security.ThreadData;
import org.apache.geronimo.security.realm.providers.GeronimoCallerPrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextManager {
    private static final ThreadLocal<Callers> callers = new ThreadLocal();
    private static final ThreadLocal<ThreadData> threadData = new ThreadLocal<ThreadData>(){

        @Override
        protected ThreadData initialValue() {
            ThreadData threadData = new ThreadData();
            PolicyContext.setHandlerData((Object)threadData);
            return threadData;
        }
    };
    private static Map<Subject, Context> subjectContexts = new IdentityHashMap<Subject, Context>();
    private static Map<SubjectId, Subject> subjectIds = Collections.synchronizedMap(new HashMap());
    private static long nextSubjectId = System.currentTimeMillis();
    private static SecretKey key;
    private static String algorithm;
    private static String password;
    public static final GeronimoSecurityPermission GET_CONTEXT;
    public static final GeronimoSecurityPermission SET_CONTEXT;
    public static final Subject EMPTY;

    public static LoginContext login(String realm, CallbackHandler callbackHandler, Configuration configuration) throws LoginException {
        Subject subject = new Subject();
        LoginContext loginContext = new LoginContext(realm, subject, callbackHandler, configuration);
        loginContext.login();
        SubjectId id = ContextManager.registerSubject(subject);
        IdentificationPrincipal principal = new IdentificationPrincipal(id);
        subject.getPrincipals().add(principal);
        return loginContext;
    }

    public static LoginContext login(String realm, CallbackHandler callbackHandler) throws LoginException {
        return ContextManager.login(realm, callbackHandler, null);
    }

    public static LoginContext login(Subject subject, String realm, CallbackHandler callbackHandler, Configuration configuration) throws LoginException {
        LoginContext loginContext = new LoginContext(realm, subject, callbackHandler, configuration);
        loginContext.login();
        return loginContext;
    }

    public static LoginContext login(Subject subject, String realm, CallbackHandler callbackHandler) throws LoginException {
        return ContextManager.login(subject, realm, callbackHandler, null);
    }

    public static void logout(LoginContext loginContext) throws LoginException {
        Subject subject = loginContext.getSubject();
        ContextManager.unregisterSubject(subject);
        loginContext.logout();
    }

    public static void setCallers(Subject currentCaller, Subject nextCaller) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT);
        }
        assert (currentCaller != null);
        assert (nextCaller != null);
        Callers newCallers = new Callers(currentCaller, nextCaller);
        callers.set(newCallers);
    }

    public static void clearCallers() {
        callers.set(null);
    }

    public static Callers getCallers() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        return callers.get();
    }

    public static Callers setNextCaller(Subject nextCaller) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT);
        }
        assert (nextCaller != null);
        Callers oldCallers = callers.get();
        assert (oldCallers != null);
        Callers newCallers = new Callers(oldCallers.getNextCaller(), nextCaller);
        callers.set(newCallers);
        return oldCallers;
    }

    public static Callers pushNextCaller(Subject nextCaller) {
        Callers oldCallers;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT);
        }
        Subject oldNextCaller = (oldCallers = callers.get()) == null ? null : oldCallers.getNextCaller();
        Subject newNextCaller = nextCaller == null || nextCaller == EMPTY ? oldNextCaller : nextCaller;
        Callers newCallers = new Callers(oldNextCaller, newNextCaller);
        callers.set(newCallers);
        return oldCallers;
    }

    public static void popCallers(Callers oldCallers) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT);
        }
        callers.set(oldCallers);
    }

    public static Subject getCurrentCaller() {
        Callers callers;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        return (callers = ContextManager.callers.get()) == null ? null : callers.getCurrentCaller();
    }

    public static Subject getNextCaller() {
        Callers callers;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        return (callers = ContextManager.callers.get()) == null ? null : callers.getNextCaller();
    }

    public static AccessControlContext getCurrentContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        Callers threadLocalCallers = callers.get();
        assert (threadLocalCallers != null) : "No current callers";
        Subject currentSubject = threadLocalCallers.getCurrentCaller();
        assert (currentSubject != null) : "No current caller";
        Context context = subjectContexts.get(currentSubject);
        assert (context != null) : "No registered context";
        return context.getContext();
    }

    public static Principal getCurrentPrincipal(Subject callerSubject) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        if (callerSubject == null) {
            return new Principal(){

                public String getName() {
                    return "";
                }
            };
        }
        Context context = subjectContexts.get(callerSubject);
        assert (context != null) : "No registered context";
        return context.getPrincipal();
    }

    public static SubjectId getCurrentId() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        Callers threadLocalCallers = callers.get();
        assert (threadLocalCallers != null) : "No current callers";
        Subject currentSubject = threadLocalCallers.getCurrentCaller();
        assert (currentSubject != null) : "No current caller";
        Context context = subjectContexts.get(currentSubject);
        assert (context != null) : "No registered context";
        return context.getId();
    }

    public static SubjectId getSubjectId(Subject subject) {
        Context context;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        return (context = subjectContexts.get(subject)) != null ? context.getId() : null;
    }

    public static Subject getRegisteredSubject(SubjectId id) {
        return subjectIds.get(id);
    }

    public static synchronized SubjectId registerSubject(Subject subject) {
        SubjectId subjectId;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT);
        }
        if (subject == null) {
            throw new IllegalArgumentException("Subject must not be null");
        }
        AccessControlContext acc = (AccessControlContext)Subject.doAsPrivileged(subject, new PrivilegedAction(){

            public Object run() {
                return AccessController.getContext();
            }
        }, null);
        Set<Principal> principals = subject.getPrincipals(GeronimoCallerPrincipal.class);
        Principal principal = null;
        if (!principals.isEmpty()) {
            principal = principals.iterator().next();
        } else {
            principals = subject.getPrincipals(PrimaryRealmPrincipal.class);
            if (!principals.isEmpty()) {
                principal = principals.iterator().next();
            } else {
                principals = subject.getPrincipals(RealmPrincipal.class);
                if (!principals.isEmpty()) {
                    principal = principals.iterator().next();
                } else {
                    principals = subject.getPrincipals();
                    if (!principals.isEmpty()) {
                        principal = principals.iterator().next();
                    }
                }
            }
        }
        Long id = nextSubjectId++;
        try {
            subjectId = new SubjectId(id, ContextManager.hash(id));
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProviderException("No such algorithm: " + algorithm + ".  This can be caused by a misconfigured java.ext.dirs, JAVA_HOME or JRE_HOME environment variable");
        }
        catch (InvalidKeyException e) {
            throw new ProviderException("Invalid key: " + key.toString());
        }
        List<String> groups = Collections.emptyList();
        Context context = new Context(subjectId, acc, subject, principal, groups);
        subjectIds.put(context.getId(), subject);
        subjectContexts.put(subject, context);
        return context.getId();
    }

    public static synchronized AccessControlContext registerSubjectShort(Subject subject, Principal callerPrincipal, List<String> groups) {
        SubjectId subjectId;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT);
        }
        if (subject == null) {
            throw new IllegalArgumentException("Subject must not be null");
        }
        Context test = subjectContexts.get(subject);
        if (test != null) {
            return test.getContext();
        }
        AccessControlContext acc = (AccessControlContext)Subject.doAsPrivileged(subject, new PrivilegedAction(){

            public Object run() {
                return AccessController.getContext();
            }
        }, null);
        Long id = nextSubjectId++;
        try {
            subjectId = new SubjectId(id, ContextManager.hash(id));
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProviderException("No such algorithm: " + algorithm + ".  This can be caused by a misconfigured java.ext.dirs, JAVA_HOME or JRE_HOME environment variable");
        }
        catch (InvalidKeyException e) {
            throw new ProviderException("Invalid key: " + key.toString());
        }
        IdentificationPrincipal principal = new IdentificationPrincipal(subjectId);
        subject.getPrincipals().add(principal);
        Context context = new Context(subjectId, acc, subject, callerPrincipal, groups);
        subjectIds.put(context.getId(), subject);
        subjectContexts.put(subject, context);
        return acc;
    }

    public static synchronized void unregisterSubject(Subject subject) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT);
        }
        if (subject == null) {
            throw new IllegalArgumentException("Subject must not be null");
        }
        Context context = subjectContexts.get(subject);
        if (context == null) {
            return;
        }
        subjectIds.remove(context.getId());
        subjectContexts.remove(subject);
    }

    public static IdentificationPrincipal getThreadPrincipal() {
        Set<IdentificationPrincipal> set;
        Subject subject;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        if ((subject = Subject.getSubject(AccessController.getContext())) != null && !(set = subject.getPrincipals(IdentificationPrincipal.class)).isEmpty()) {
            return set.iterator().next();
        }
        return null;
    }

    public static ThreadData getThreadData() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        return threadData.get();
    }

    public static String getAlgorithm() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        return algorithm;
    }

    public static void setAlgorithm(String algorithm) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT);
        }
        ContextManager.algorithm = algorithm;
        key = new SecretKeySpec(password.getBytes(), algorithm);
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(key);
        }
        catch (NoSuchAlgorithmException e) {
            assert (false) : "Should never have reached here";
            throw new ProviderException("No such algorithm: " + algorithm + ".  This can be caused by a misconfigured java.ext.dirs, JAVA_HOME or JRE_HOME environment variable.");
        }
        catch (InvalidKeyException e) {
            assert (false) : "Should never have reached here";
            throw new ProviderException("Invalid key: " + key.toString());
        }
    }

    public static String getPassword() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONTEXT);
        }
        return password;
    }

    public static void setPassword(String password) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT);
        }
        ContextManager.password = password;
        key = new SecretKeySpec(password.getBytes(), algorithm);
    }

    private static byte[] hash(Long id) throws NoSuchAlgorithmException, InvalidKeyException {
        long n = id;
        byte[] bytes = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bytes[i] = (byte)n;
            n >>>= 8;
        }
        Mac mac = Mac.getInstance(algorithm);
        mac.init(key);
        mac.update(bytes);
        return mac.doFinal();
    }

    static {
        GET_CONTEXT = new GeronimoSecurityPermission("getContext");
        SET_CONTEXT = new GeronimoSecurityPermission("setContext");
        password = "secret";
        ContextManager.setAlgorithm("HmacSHA1");
        EMPTY = new Subject();
        EMPTY.setReadOnly();
        ContextManager.registerSubject(EMPTY);
    }
}

