/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jacc.mappingprovider;

import java.util.HashMap;
import java.util.Map;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.apache.geronimo.security.GeronimoSecurityPermission;
import org.apache.geronimo.security.jacc.mappingprovider.ApplicationPrincipalRoleConfigurationManager;
import org.apache.geronimo.security.jacc.mappingprovider.GeronimoPolicyConfiguration;
import org.apache.geronimo.security.jacc.mappingprovider.PolicyConfigurationGeneric;
import org.apache.geronimo.security.jacc.mappingprovider.PrincipalRoleConfiguration;
import org.apache.geronimo.security.jacc.mappingprovider.PrincipalRoleConfigurationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeronimoPolicyConfigurationFactory
extends PolicyConfigurationFactory
implements PrincipalRoleConfigurationFactory {
    private static final Logger log = LoggerFactory.getLogger(GeronimoPolicyConfigurationFactory.class);
    private static GeronimoPolicyConfigurationFactory singleton;
    private Map<String, GeronimoPolicyConfiguration> configurations = new HashMap<String, GeronimoPolicyConfiguration>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeronimoPolicyConfigurationFactory() {
        Class<GeronimoPolicyConfigurationFactory> clazz = GeronimoPolicyConfigurationFactory.class;
        synchronized (GeronimoPolicyConfigurationFactory.class) {
            if (singleton != null) {
                log.error("Singleton already assigned.  There may be more than one GeronimoPolicyConfigurationFactory being used.");
                throw new IllegalStateException("Singleton already assigned");
            }
            singleton = this;
            ApplicationPrincipalRoleConfigurationManager.setPrincipalRoleConfigurationFactory(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void setPolicyConfiguration(String contextID, GeronimoPolicyConfiguration configuration) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new GeronimoSecurityPermission("setPolicyConfiguration"));
        }
        this.configurations.put(contextID, configuration);
        log.trace("Set policy configuration " + contextID);
    }

    public GeronimoPolicyConfiguration getGeronimoPolicyConfiguration(String contextID) throws PolicyContextException {
        GeronimoPolicyConfiguration configuration = this.configurations.get(contextID);
        if (configuration == null) {
            throw new PolicyContextException("No policy configuration registered for contextID: " + contextID);
        }
        log.trace("Get policy configuration " + contextID);
        return configuration;
    }

    public PolicyConfiguration getPolicyConfiguration(String contextID, boolean remove) throws PolicyContextException {
        GeronimoPolicyConfiguration configuration = this.configurations.get(contextID);
        if (configuration == null) {
            configuration = new PolicyConfigurationGeneric(contextID);
            this.configurations.put(contextID, configuration);
        } else {
            configuration.open(remove);
        }
        log.trace("Get " + (remove ? "CLEANED" : "") + " policy configuration " + contextID);
        return configuration;
    }

    public boolean inService(String contextID) throws PolicyContextException {
        PolicyConfiguration configuration = this.getPolicyConfiguration(contextID, false);
        log.trace("Policy configuration " + contextID + " put into service");
        return configuration.inService();
    }

    static GeronimoPolicyConfigurationFactory getSingleton() {
        return singleton;
    }

    public PrincipalRoleConfiguration getPrincipalRoleConfiguration(String contextID) throws PolicyContextException {
        return this.getGeronimoPolicyConfiguration(contextID);
    }
}

