/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm;

import java.util.ArrayList;
import java.util.HashSet;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.security.jaas.ConfigurationEntryFactory;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.security.jaas.JaasLoginModuleChain;
import org.apache.geronimo.security.jaas.JaasLoginModuleUse;
import org.apache.geronimo.security.jaas.SingleLoginConfiguration;
import org.apache.geronimo.security.realm.SecurityRealm;
import org.apache.geronimo.system.serverinfo.ServerInfo;

@GBean(j2eeType="SecurityRealm")
public class GenericSecurityRealm
implements SecurityRealm,
ConfigurationEntryFactory,
ConfigurationFactory {
    private final String realmName;
    private AppConfigurationEntry[] config;
    private String[] domains;
    private final boolean wrapPrincipals;
    private final JaasLoginModuleUse loginModuleUse;
    private final boolean global;
    private final ServerInfo serverInfo;
    private final ClassLoader classLoader;
    private final Kernel kernel;
    private final Configuration configuration;

    public GenericSecurityRealm(@ParamAttribute(name="realmName") String realmName, @ParamReference(name="LoginModuleConfiguration", namingType="LoginModuleUse") JaasLoginModuleUse loginModuleUse, @ParamAttribute(name="wrapPrincipals") boolean wrapPrincipals, @ParamAttribute(name="global") boolean global, @ParamReference(name="ServerInfo") ServerInfo serverInfo, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader, @ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel) throws ClassNotFoundException {
        this.realmName = realmName;
        this.wrapPrincipals = wrapPrincipals;
        this.loginModuleUse = loginModuleUse;
        this.global = global;
        this.serverInfo = serverInfo;
        this.classLoader = classLoader;
        this.kernel = kernel;
        this.refresh();
        this.configuration = new SingleLoginConfiguration(this);
    }

    public String getRealmName() {
        return this.realmName;
    }

    public AppConfigurationEntry[] getAppConfigurationEntries() {
        return this.config;
    }

    public JaasLoginModuleChain getLoginModuleChain() {
        return this.loginModuleUse;
    }

    public String[] getLoginDomains() {
        return this.domains;
    }

    public boolean isWrapPrincipals() {
        return this.wrapPrincipals;
    }

    public String getConfigurationName() {
        return this.realmName;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void refresh() {
        HashSet<String> domainNames = new HashSet<String>();
        ArrayList<AppConfigurationEntry> loginModuleConfigurations = new ArrayList<AppConfigurationEntry>();
        if (this.loginModuleUse != null) {
            try {
                this.loginModuleUse.configure(domainNames, loginModuleConfigurations, this.realmName, this.kernel, this.serverInfo, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("can not configure realm", e);
            }
        }
        this.domains = domainNames.toArray(new String[domainNames.size()]);
        this.config = loginModuleConfigurations.toArray(new AppConfigurationEntry[loginModuleConfigurations.size()]);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

