/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.security.jaas.JaasLoginModuleUse;
import org.apache.geronimo.security.jaas.WrappingLoginModule;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAuditLoginModule
implements LoginModule {
    private static final Logger log = LoggerFactory.getLogger(FileAuditLoginModule.class);
    public static final String LOG_FILE_OPTION = "file";
    public static final List<String> supportedOptions = Collections.unmodifiableList(Arrays.asList("file"));
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private File logFile;
    private CallbackHandler handler;
    private String username;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        for (Object option : options.keySet()) {
            if (supportedOptions.contains(option) || JaasLoginModuleUse.supportedOptions.contains(option) || WrappingLoginModule.supportedOptions.contains(option)) continue;
            log.warn("Ignoring option: " + option + ". Not supported.");
        }
        String name = (String)options.get(LOG_FILE_OPTION);
        ServerInfo info = (ServerInfo)options.get("org.apache.geronimo.security.realm.GenericSecurityRealm.SERVERINFO");
        this.logFile = info.resolve(name);
        this.handler = callbackHandler;
    }

    public boolean login() throws LoginException {
        NameCallback user = new NameCallback("User name:");
        Callback[] callbacks = new Callback[]{user};
        try {
            this.handler.handle(callbacks);
        }
        catch (Exception e) {
            throw (LoginException)new LoginException("Unable to process callback: " + e.getMessage()).initCause(e);
        }
        if (callbacks.length != 1) {
            throw new IllegalStateException("Number of callbacks changed by server!");
        }
        user = (NameCallback)callbacks[0];
        this.username = user.getName();
        this.writeToFile("Authentication attempt");
        return false;
    }

    private synchronized void writeToFile(String action) {
        Date date = new Date();
        try {
            FileOutputStream out = new FileOutputStream(this.logFile, true);
            FileChannel channel = out.getChannel();
            FileLock lock = channel.lock(0L, Long.MAX_VALUE, false);
            PrintWriter writer = new PrintWriter(out, false);
            writer.println(DATE_FORMAT.format(date) + " - " + action + " - " + this.username);
            writer.flush();
            writer.close();
            if (lock.isValid()) {
                lock.release();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write to authentication log file", e);
        }
    }

    public boolean commit() throws LoginException {
        if (this.username != null) {
            this.writeToFile("Authentication succeeded");
        }
        return false;
    }

    public boolean abort() throws LoginException {
        if (this.username != null) {
            this.writeToFile("Authentication failed");
            this.username = null;
        }
        return false;
    }

    public boolean logout() throws LoginException {
        if (this.username != null) {
            this.writeToFile("Explicit logout");
            this.username = null;
        }
        return false;
    }
}

