/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.security.jaas.JaasLoginModuleUse;
import org.apache.geronimo.security.jaas.WrappingLoginModule;
import org.apache.geronimo.security.realm.providers.GenericHttpHeaderLoginmodule;
import org.apache.geronimo.security.realm.providers.HeaderMismatchException;
import org.apache.geronimo.security.realm.providers.PropertiesFileLoginModule;
import org.apache.geronimo.security.realm.providers.RequestCallback;
import org.apache.geronimo.security.realm.providers.SiteminderHeaderHandler;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class GenericHttpHeaderPropertiesFileLoginModule
extends GenericHttpHeaderLoginmodule
implements LoginModule {
    private static final String GROUPS_URI = "groupsURI";
    private static final String HEADER_NAMES = "headerNames";
    private static final String AUTHENTICATION_AUTHORITY = "authenticationAuthority";
    public static final List<String> supportedOptions = Collections.unmodifiableList(Arrays.asList("groupsURI", "headerNames", "authenticationAuthority"));
    private static Log log = LogFactory.getLog(PropertiesFileLoginModule.class);
    final Map<String, Set<String>> roleUsersMap = new HashMap<String, Set<String>>();

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.headerNames = (String)options.get(HEADER_NAMES);
        this.authenticationAuthority = (String)options.get(AUTHENTICATION_AUTHORITY);
        for (Object option : options.keySet()) {
            if (supportedOptions.contains(option) || JaasLoginModuleUse.supportedOptions.contains(option) || WrappingLoginModule.supportedOptions.contains(option)) continue;
            log.warn((Object)("Ignoring option: " + option + ". Not supported."));
        }
        try {
            ServerInfo serverInfo = (ServerInfo)options.get("org.apache.geronimo.security.realm.GenericSecurityRealm.SERVERINFO");
            String groups = (String)options.get(GROUPS_URI);
            if (groups == null) {
                throw new IllegalArgumentException("groupsURI must be provided!");
            }
            URI groupsURI = new URI(groups);
            this.loadProperties(serverInfo, groupsURI);
        }
        catch (Exception e) {
            log.error((Object)"Initialization failed", (Throwable)e);
            throw new IllegalArgumentException("Unable to configure properties file login module: " + e.getMessage(), e);
        }
    }

    public void loadProperties(ServerInfo serverInfo, URI groupURI) throws GeronimoSecurityException {
        try {
            URI groupFile = serverInfo.resolveServer(groupURI);
            Properties temp = new Properties();
            InputStream stream = groupFile.toURL().openStream();
            temp.load(stream);
            stream.close();
            Enumeration<Object> e = temp.keys();
            while (e.hasMoreElements()) {
                String groupName = (String)e.nextElement();
                String[] userList = ((String)temp.get(groupName)).split(",");
                Set<String> userset = this.roleUsersMap.get(groupName);
                if (userset == null) {
                    userset = new HashSet<String>();
                    this.roleUsersMap.put(groupName, userset);
                }
                for (String user : userList) {
                    userset.add(user);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Generic HTTP Header Properties File Login Module - data load failed", (Throwable)e);
            throw new GeronimoSecurityException((Throwable)e);
        }
    }

    @Override
    public boolean login() throws LoginException {
        Map<String, String> headerMap = null;
        this.loginSucceeded = false;
        Callback[] callbacks = new Callback[]{new RequestCallback()};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        this.httpRequest = ((RequestCallback)callbacks[0]).getRequest();
        String[] headers = this.headerNames.split(",");
        try {
            headerMap = this.matchHeaders(this.httpRequest, headers);
        }
        catch (HeaderMismatchException e) {
            throw (LoginException)new LoginException("Header Mistmatch error").initCause(e);
        }
        if (headerMap.isEmpty()) {
            throw new FailedLoginException();
        }
        if (this.authenticationAuthority.equalsIgnoreCase("Siteminder")) {
            SiteminderHeaderHandler headerHandler = new SiteminderHeaderHandler();
            this.username = headerHandler.getUser(headerMap);
        } else if (this.authenticationAuthority.equalsIgnoreCase("Datapower")) {
            // empty if block
        }
        if (this.username == null || this.username.equals("")) {
            this.username = null;
            throw new FailedLoginException();
        }
        if (this.username != null) {
            block5: for (Map.Entry<String, Set<String>> entry : this.roleUsersMap.entrySet()) {
                String groupName = entry.getKey();
                Set<String> users = entry.getValue();
                for (String user : users) {
                    if (!this.username.equals(user)) continue;
                    this.groups.add(groupName);
                    continue block5;
                }
            }
        }
        if (this.groups.isEmpty()) {
            log.error((Object)("No roles associated with user " + this.username));
            this.loginSucceeded = false;
            throw new FailedLoginException();
        }
        this.loginSucceeded = true;
        return this.loginSucceeded;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.loginSucceeded && this.username != null) {
            super.commitHelper();
        }
        this.username = null;
        this.roleUsersMap.clear();
        this.groups.clear();
        return this.loginSucceeded;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.loginSucceeded) {
            this.username = null;
            this.allPrincipals.clear();
        }
        return this.loginSucceeded;
    }

    @Override
    public boolean logout() throws LoginException {
        this.loginSucceeded = false;
        this.username = null;
        if (!this.subject.isReadOnly()) {
            this.subject.getPrincipals().removeAll(this.allPrincipals);
        }
        this.allPrincipals.clear();
        return true;
    }
}

