/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.math.BigInteger;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.crypto.encoders.Base64;
import org.apache.geronimo.security.jaas.JaasLoginModuleUse;
import org.apache.geronimo.security.jaas.WrappingLoginModule;
import org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal;
import org.apache.geronimo.security.realm.providers.GeronimoUserPrincipal;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpnegoLoginModule
implements LoginModule {
    public static final String TARGET_NAME = "targetName";
    public static final String LDAP_URL = "ldapUrl";
    public static final String LDAP_LOGIN_NAME = "ldapLoginName";
    public static final String LDAP_LOGIN_PASSWORD = "ldapLoginPassword";
    public static final String SEARCH_BASE = "searchBase";
    public static final String LDAP_CONTEXT_FACTORY = "ldapContextFactory";
    public static final List<String> supportedOptions = Collections.unmodifiableList(Arrays.asList("targetName", "ldapUrl", "ldapLoginName", "ldapLoginPassword", "searchBase", "ldapContextFactory"));
    private String username;
    private boolean loginSucceeded;
    private GSSName srcName;
    private final Set<Principal> allPrincipals = new HashSet<Principal>();
    private Subject subject;
    private CallbackHandler callbackHandler;
    private String targetName;
    private String ldapUrl;
    private String ldapLoginName;
    private String ldapLoginPassword;
    private String searchBase;
    private String ldapContextFactory;
    private static Logger log = LoggerFactory.getLogger(SpnegoLoginModule.class);

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        try {
            this.subject = subject;
            this.callbackHandler = callbackHandler;
            for (Object option : options.keySet()) {
                if (supportedOptions.contains(option) || JaasLoginModuleUse.supportedOptions.contains(option) || WrappingLoginModule.supportedOptions.contains(option)) continue;
                log.warn("Ignoring option: " + option + ". Not supported.");
            }
            this.targetName = (String)options.get(TARGET_NAME);
            this.ldapUrl = (String)options.get(LDAP_URL);
            this.ldapLoginName = (String)options.get(LDAP_LOGIN_NAME);
            this.ldapLoginPassword = (String)options.get(LDAP_LOGIN_PASSWORD);
            this.searchBase = (String)options.get(SEARCH_BASE);
            this.ldapContextFactory = (String)options.get(LDAP_CONTEXT_FACTORY);
            if (this.ldapContextFactory == null || this.ldapContextFactory.length() == 0) {
                this.ldapContextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
            }
        }
        catch (Exception e) {
            log.error("Initialization failed", (Throwable)e);
            throw new IllegalArgumentException("Unable to configure Spnego login module: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean login() throws LoginException {
        this.loginSucceeded = false;
        Callback[] callbacks = new Callback[]{new NameCallback("User name")};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        this.username = ((NameCallback)callbacks[0]).getName();
        if (this.username == null || this.username.equals("")) {
            this.username = null;
            throw new FailedLoginException();
        }
        byte[] token = Base64.decode((String)this.username);
        try {
            GSSManager manager = GSSManager.getInstance();
            Oid krb5Oid = new Oid("1.3.6.1.5.5.2");
            GSSName gssName = manager.createName(this.targetName, GSSName.NT_USER_NAME);
            GSSCredential serverCreds = manager.createCredential(gssName, Integer.MAX_VALUE, krb5Oid, 2);
            GSSContext gContext = manager.createContext(serverCreds);
            if (gContext != null) {
                while (!gContext.isEstablished()) {
                    token = gContext.acceptSecContext(token, 0, token.length);
                }
                if (gContext.isEstablished()) {
                    this.loginSucceeded = true;
                    this.srcName = gContext.getSrcName();
                    log.debug("A security context is successfully established" + gContext);
                    return this.loginSucceeded;
                }
                log.error("Failed to establish a security context");
                throw new LoginException("Failed to establish a security context");
            }
            log.debug("Failed to create a GSSContext");
        }
        catch (GSSException e) {
            log.error(e.getMessage());
            throw (LoginException)new LoginException().initCause(e);
        }
        return this.loginSucceeded;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.loginSucceeded && this.srcName != null) {
            String at = "@";
            DirContext ctx = null;
            int indexOfAt = ((Object)this.srcName).toString().indexOf(at);
            String userName = ((Object)this.srcName).toString().substring(0, indexOfAt);
            SearchControls searchCtls = new SearchControls();
            String[] returnedAtts = new String[]{"primaryGroupID", "memberOf", "objectSid;binary"};
            String searchFilter = "(&(objectClass=user)(cn=" + userName + "))";
            String groupSearchFilter = null;
            int totalResults = 0;
            try {
                ctx = this.getConnection();
                if (ctx == null) {
                    log.info("Failed to get a directory context object");
                    throw new LoginException("Failed to get a directory context object");
                }
                searchCtls.setReturningAttributes(returnedAtts);
                searchCtls.setSearchScope(2);
                NamingEnumeration<SearchResult> answer = ctx.search(this.searchBase, searchFilter, searchCtls);
                while (answer.hasMoreElements()) {
                    SearchResult sr = answer.next();
                    ++totalResults;
                    Attributes attrs = sr.getAttributes();
                    if (attrs == null) continue;
                    try {
                        byte[] userSid = (byte[])attrs.get("objectSid;binary").get();
                        Integer primaryGroupId = new Integer((String)attrs.get("primaryGroupID").get());
                        byte[] groupRid = SpnegoLoginModule.integerToFourBytes(primaryGroupId);
                        byte[] groupSid = (byte[])userSid.clone();
                        for (int i = 0; i < 4; ++i) {
                            groupSid[groupSid.length - 1 - i] = groupRid[i];
                        }
                        groupSearchFilter = "(&(objectSid=" + SpnegoLoginModule.binaryToStringSID(groupSid) + "))";
                        Attribute answer1 = attrs.get("memberOf");
                        for (int i = 0; i < answer1.size(); ++i) {
                            String str = answer1.get(i).toString();
                            String[] str1 = str.split("CN=");
                            this.allPrincipals.add(new GeronimoGroupPrincipal(str1[1].substring(0, str1[1].indexOf(","))));
                        }
                    }
                    catch (NullPointerException e) {
                        throw new LoginException("Errors listing attributes: " + e);
                    }
                }
                NamingEnumeration<SearchResult> answer2 = ctx.search(this.searchBase, groupSearchFilter, searchCtls);
                while (answer2.hasMoreElements()) {
                    SearchResult sr = answer2.next();
                    String[] str1 = sr.getName().split("CN=");
                    this.allPrincipals.add(new GeronimoGroupPrincipal(str1[1].substring(0, str1[1].indexOf(","))));
                }
            }
            catch (NamingException e) {
                throw (LoginException)new LoginException().initCause(e);
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Exception e) {}
                }
            }
            this.allPrincipals.add(new GeronimoUserPrincipal(((Object)this.srcName).toString()));
            this.subject.getPrincipals().addAll(this.allPrincipals);
        }
        return this.loginSucceeded;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.loginSucceeded) {
            this.username = null;
            this.allPrincipals.clear();
        }
        return this.loginSucceeded;
    }

    @Override
    public boolean logout() throws LoginException {
        this.loginSucceeded = false;
        this.username = null;
        if (!this.subject.isReadOnly()) {
            this.subject.getPrincipals().removeAll(this.allPrincipals);
        }
        this.allPrincipals.clear();
        return true;
    }

    private DirContext getConnection() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        InitialLdapContext ctx = null;
        env.put("java.naming.factory.initial", this.ldapContextFactory);
        if (this.ldapLoginName != null && this.ldapLoginName.length() > 0) {
            env.put("java.naming.security.principal", this.ldapLoginName);
        }
        if (this.ldapLoginPassword != null && this.ldapLoginPassword.length() > 0) {
            env.put("java.naming.security.credentials", this.ldapLoginPassword);
        }
        env.put("java.naming.provider.url", this.ldapUrl);
        try {
            ctx = new InitialLdapContext(env, null);
        }
        catch (NamingException e) {
            throw new NamingException("Instantiation of Ldap Context failed");
        }
        return ctx;
    }

    private static String binaryToStringSID(byte[] sidBytes) {
        StringBuilder sidString = new StringBuilder();
        sidString.append("S-");
        sidString.append(Byte.toString(sidBytes[0]));
        sidString.append("-0x");
        sidString.append(new BigInteger(new byte[]{127, sidBytes[6], sidBytes[5], sidBytes[4], sidBytes[3], sidBytes[2], sidBytes[1]}).toString(16).substring(2));
        int saCount = sidBytes[7];
        for (int i = 0; i < saCount; ++i) {
            int idxAuth = 8 + i * 4;
            sidString.append("-0x");
            sidString.append(new BigInteger(new byte[]{127, sidBytes[idxAuth + 3], sidBytes[idxAuth + 2], sidBytes[idxAuth + 1], sidBytes[idxAuth]}).toString(16).substring(2));
        }
        return sidString.toString();
    }

    private static byte[] integerToFourBytes(int i) {
        byte[] b = new byte[]{(byte)((i & 0xFF000000) >>> 24), (byte)((i & 0xFF0000) >>> 16), (byte)((i & 0xFF00) >>> 8), (byte)(i & 0xFF)};
        return b;
    }
}

