/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaspi.impl;

import java.security.AccessControlContext;
import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.geronimo.security.Callers;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.jaspi.IdentityService;
import org.apache.geronimo.security.jaspi.UserIdentity;
import org.apache.geronimo.security.jaspi.impl.JACCUserIdentity;
import org.apache.geronimo.security.jaspi.impl.WrappingCallerPrincipal;
import org.apache.geronimo.security.realm.providers.GeronimoCallerPrincipal;

public class GeronimoIdentityService
implements IdentityService {
    private final Subject defaultSubject;

    public GeronimoIdentityService(Subject defaultSubject) {
        this.defaultSubject = defaultSubject;
    }

    @Override
    public Object associate(UserIdentity userIdentity) {
        Subject subject = userIdentity == null ? this.defaultSubject : userIdentity.getSubject();
        Callers callers = ContextManager.getCallers();
        ContextManager.setCallers(subject, subject);
        return callers;
    }

    @Override
    public void dissociate(Object previous) {
        ContextManager.popCallers((Callers)previous);
    }

    @Override
    public UserIdentity newUserIdentity(Subject subject) {
        Principal callerPrincipal = null;
        for (GeronimoCallerPrincipal principal : subject.getPrincipals(GeronimoCallerPrincipal.class)) {
            if (principal instanceof WrappingCallerPrincipal) {
                callerPrincipal = ((WrappingCallerPrincipal)principal).getWrapped();
                continue;
            }
            callerPrincipal = principal;
        }
        AccessControlContext acc = ContextManager.registerSubjectShort(subject, callerPrincipal);
        return new JACCUserIdentity(subject, callerPrincipal, acc);
    }
}

