/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaspi.impl;

import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.security.jaspi.IdentityService;
import org.apache.geronimo.security.jaspi.LoginService;
import org.apache.geronimo.security.jaspi.UserIdentity;
import org.apache.geronimo.security.realm.providers.CertificateChainCallbackHandler;
import org.apache.geronimo.security.realm.providers.PasswordCallbackHandler;

public class GeronimoLoginService
implements LoginService {
    private final ConfigurationFactory configurationFactory;
    private final IdentityService identityService;

    public GeronimoLoginService(ConfigurationFactory configurationFactory, IdentityService identityService) {
        this.configurationFactory = configurationFactory;
        this.identityService = identityService;
    }

    @Override
    public UserIdentity login(String userName, String password) {
        return this.login(new PasswordCallbackHandler(userName, password == null ? null : password.toCharArray()));
    }

    @Override
    public UserIdentity login(X509Certificate[] certs) {
        return this.login(new CertificateChainCallbackHandler(certs));
    }

    @Override
    public UserIdentity login(CallbackHandler callbackHandler) {
        try {
            LoginContext loginContext = ContextManager.login(this.configurationFactory.getConfigurationName(), callbackHandler, this.configurationFactory.getConfiguration());
            Subject establishedSubject = loginContext.getSubject();
            return this.identityService.newUserIdentity(establishedSubject);
        }
        catch (LoginException e) {
            return null;
        }
    }

    @Override
    public void logout(UserIdentity userIdentity) {
    }
}

