/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration.condition;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.apache.geronimo.system.configuration.condition.ConditionParser;
import org.apache.geronimo.system.configuration.condition.ConditionParserException;
import org.apache.geronimo.system.configuration.condition.ParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JexlConditionParser
implements ConditionParser {
    private static final Logger log = LoggerFactory.getLogger(JexlConditionParser.class);
    private final Map<String, Object> vars;
    private final JexlEngine engine;

    public JexlConditionParser(Map<String, Object> vars) {
        if (vars == null) {
            throw new IllegalArgumentException("vars");
        }
        this.vars = vars;
        this.engine = new JexlEngine();
    }

    public JexlConditionParser() {
        this.vars = new HashMap<String, Object>();
        ParserUtils.addDefaultVariables(this.vars);
        this.engine = new JexlEngine();
    }

    @Override
    public boolean evaluate(String expression) throws ConditionParserException {
        Object result;
        if (expression == null) {
            throw new IllegalArgumentException("Expression must not be null");
        }
        if (expression.trim().length() == 0) {
            log.debug("Expression is empty; skipping evaluation");
            return true;
        }
        try {
            result = this.doEvaluate(expression);
        }
        catch (Exception e) {
            throw new ConditionParserException("Failed to evaluate expression: " + expression, e);
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        throw new ConditionParserException("Expression '" + expression + "' did not evaluate to a boolean value; found: " + result);
    }

    private Object doEvaluate(String expression) throws Exception {
        assert (expression != null);
        log.debug("Evaluating expression: {}", (Object)expression);
        Expression expr = this.engine.createExpression(expression);
        MapContext ctx = new MapContext(this.vars);
        Object result = expr.evaluate((JexlContext)ctx);
        log.debug("Result: {}", result);
        return result;
    }
}

