/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transformer;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.geronimo.kernel.config.MultiParentClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerCollection
implements ClassFileTransformer {
    private final List<TransformerWrapper> transformers = new ArrayList<TransformerWrapper>();

    public TransformerCollection() {
        for (TransformerWrapper transformerWrapper : this.transformers) {
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        boolean changed = false;
        for (TransformerWrapper transformer : this.transformers) {
            byte[] transformed = transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
            if (transformed == null) continue;
            changed = true;
            classfileBuffer = transformed;
        }
        return (byte[])(changed ? classfileBuffer : null);
    }

    public void addTransformer(ClassFileTransformer classFileTransformer) {
        this.transformers.add(new TransformerWrapper(classFileTransformer));
    }

    public void removeTransformer(ClassFileTransformer classFileTransformer) {
        for (TransformerWrapper wrapper : this.transformers) {
            if (wrapper.delegate != classFileTransformer) continue;
            this.transformers.remove(wrapper);
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransformerWrapper
    implements ClassFileTransformer {
        private final ClassFileTransformer delegate;
        private final Set<ClassLoader> ancestorClassLoaders;

        TransformerWrapper(ClassFileTransformer transformer) {
            this.delegate = transformer;
            this.ancestorClassLoaders = MultiParentClassLoader.getAncestors((ClassLoader)this.delegate.getClass().getClassLoader());
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            if (this.ancestorClassLoaders.contains(loader)) {
                return null;
            }
            return this.delegate.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
        }
    }
}

