/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector;

import java.util.Hashtable;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.kernel.ObjectNameUtil;
import org.apache.geronimo.management.J2EEApplication;
import org.apache.geronimo.management.J2EEServer;
import org.apache.geronimo.management.geronimo.ResourceAdapter;
import org.apache.geronimo.management.geronimo.ResourceAdapterModule;

public class ResourceAdapterModuleImpl
implements ResourceAdapterModule {
    private final J2EEServer server;
    private final J2EEApplication application;
    private final String deploymentDescriptor;
    private final ResourceAdapter resourceAdapter;
    private final GBeanData resourceAdapterGBeanData;
    private final Map activationSpecInfoMap;
    private final Map adminObjectInfoMap;
    private final Map managedConnectionFactoryInfoMap;
    private final String objectName;
    private final String displayName;
    private final String description;
    private final String vendorName;
    private final String resourceAdapterVersion;
    private final String eisType;

    public ResourceAdapterModuleImpl(String objectName, ResourceAdapter resourceAdapter, J2EEServer server, J2EEApplication application, String deploymentDescriptor, GBeanData resourceAdapterGBeanData, Map activationSpecInfoMap, Map adminObjectInfoMap, Map managedConnectionFactoryInfoMap, String displayName, String description, String vendorName, String resourceAdapterVersion, String eisType) {
        this.objectName = objectName;
        ObjectName myObjectName = ObjectNameUtil.getObjectName((String)objectName);
        this.verifyObjectName(myObjectName);
        this.resourceAdapter = resourceAdapter;
        this.server = server;
        this.application = application;
        this.deploymentDescriptor = deploymentDescriptor;
        this.resourceAdapterGBeanData = resourceAdapterGBeanData;
        this.activationSpecInfoMap = activationSpecInfoMap;
        this.adminObjectInfoMap = adminObjectInfoMap;
        this.managedConnectionFactoryInfoMap = managedConnectionFactoryInfoMap;
        this.description = description;
        this.displayName = displayName;
        this.vendorName = vendorName;
        this.resourceAdapterVersion = resourceAdapterVersion;
        this.eisType = eisType;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    public String getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public String getServer() {
        return this.server.getObjectName();
    }

    public String getApplication() {
        if (this.application == null) {
            return null;
        }
        return this.application.getObjectName();
    }

    public String[] getJavaVMs() {
        return this.server.getJavaVMs();
    }

    public String[] getResourceAdapters() {
        return new String[]{this.resourceAdapter.getObjectName()};
    }

    public GBeanData getResourceAdapterGBeanData() {
        return this.resourceAdapterGBeanData;
    }

    public Map getActivationSpecInfoMap() {
        return this.activationSpecInfoMap;
    }

    public Map getAdminObjectInfoMap() {
        return this.adminObjectInfoMap;
    }

    public Map getManagedConnectionFactoryInfoMap() {
        return this.managedConnectionFactoryInfoMap;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public String getResourceAdapterVersion() {
        return this.resourceAdapterVersion;
    }

    public String getEISType() {
        return this.eisType;
    }

    public ResourceAdapter[] getResourceAdapterInstances() {
        return new ResourceAdapter[]{this.resourceAdapter};
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"ResourceAdapterModule".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("ResourceAdapterModule object name j2eeType property must be 'ResourceAdapterModule'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("ResourceAdapterModule object must contain a name property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEServer")) {
            throw new InvalidObjectNameException("ResourceAdapterModule object name must contain a J2EEServer property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEApplication")) {
            throw new InvalidObjectNameException("ResourceAdapterModule object name must contain a J2EEApplication property", objectName);
        }
        if (keyPropertyList.size() != 4) {
            throw new InvalidObjectNameException("ResourceAdapterModule object name can only have j2eeType, name, J2EEApplication, and J2EEServer properties", objectName);
        }
    }
}

