/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.persistence;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ejb.EJBException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Metamodel;
import org.apache.geronimo.persistence.EntityManagerExtendedRegistry;
import org.apache.geronimo.persistence.EntityManagerWrapper;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;

public class InternalCMPEntityManagerExtended
implements EntityManager,
EntityManagerWrapper {
    private final EntityManager entityManager;
    private final String persistenceUnit;
    private final TransactionManagerImpl transactionManager;
    private final AtomicInteger count = new AtomicInteger();

    public InternalCMPEntityManagerExtended(EntityManager entityManager, String persistenceUnit, TransactionManagerImpl transactionManager) {
        this.entityManager = entityManager;
        this.persistenceUnit = persistenceUnit;
        this.transactionManager = transactionManager;
        if (transactionManager.getTransaction() != null) {
            this.joinTransaction();
        }
    }

    void registerBean() {
        this.count.getAndIncrement();
    }

    void beanRemoved() {
        if (this.count.decrementAndGet() == 0) {
            this.entityManager.close();
            EntityManagerExtendedRegistry.clearEntityManager(this.persistenceUnit);
        }
    }

    @Override
    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void persist(Object o) {
        this.entityManager.persist(o);
    }

    public <T> T merge(T t) {
        return (T)this.entityManager.merge(t);
    }

    public void remove(Object o) {
        this.entityManager.remove(o);
    }

    public <T> T find(Class<T> aClass, Object o) {
        return (T)this.entityManager.find(aClass, o);
    }

    public <T> T getReference(Class<T> aClass, Object o) {
        return (T)this.entityManager.getReference(aClass, o);
    }

    public void flush() {
        this.entityManager.flush();
    }

    public void setFlushMode(FlushModeType flushModeType) {
        this.entityManager.setFlushMode(flushModeType);
    }

    public FlushModeType getFlushMode() {
        return this.entityManager.getFlushMode();
    }

    public void lock(Object o, LockModeType lockModeType) {
        this.entityManager.lock(o, lockModeType);
    }

    public void refresh(Object o) {
        this.entityManager.refresh(o);
    }

    public void clear() {
        this.entityManager.clear();
    }

    public boolean contains(Object o) {
        return this.entityManager.contains(o);
    }

    public Query createQuery(String s) {
        return this.entityManager.createQuery(s);
    }

    public Query createNamedQuery(String s) {
        return this.entityManager.createNamedQuery(s);
    }

    public Query createNativeQuery(String s) {
        return this.entityManager.createNativeQuery(s);
    }

    public Query createNativeQuery(String s, Class aClass) {
        return this.entityManager.createNativeQuery(s, aClass);
    }

    public Query createNativeQuery(String s, String s1) {
        return this.entityManager.createNativeQuery(s, s1);
    }

    public void close() {
    }

    public boolean isOpen() {
        return true;
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException("You cannot call getTransaction on a container managed EntityManager");
    }

    public void joinTransaction() {
        if (this.transactionManager.getResource((Object)this.persistenceUnit) != null) {
            throw new EJBException("EntityManager " + this.transactionManager.getResource((Object)this.persistenceUnit) + " for persistenceUnit " + this.persistenceUnit + " already associated with this transaction " + this.transactionManager.getTransactionKey());
        }
        this.transactionManager.putResource((Object)this.persistenceUnit, (Object)this);
        this.entityManager.joinTransaction();
    }

    public Object getDelegate() {
        return this.entityManager.getDelegate();
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int i) {
    }

    public Metamodel getMetamodel() {
        return this.entityManager.getMetamodel();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.entityManager.getCriteriaBuilder();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManager.getEntityManagerFactory();
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        return this.entityManager.createNamedQuery(name, resultClass);
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        return this.entityManager.createQuery(criteriaQuery);
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        return this.entityManager.createQuery(qlString, resultClass);
    }

    public void detach(Object entity) {
        this.entityManager.detach(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return (T)this.entityManager.find(entityClass, primaryKey, properties);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        return (T)this.entityManager.find(entityClass, primaryKey, lockMode);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        return (T)this.entityManager.find(entityClass, primaryKey, lockMode, properties);
    }

    public LockModeType getLockMode(Object entity) {
        return this.entityManager.getLockMode(entity);
    }

    public Map<String, Object> getProperties() {
        return this.entityManager.getProperties();
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.entityManager.lock(entity, lockMode, properties);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.entityManager.refresh(entity, properties);
    }

    public void refresh(Object entity, LockModeType lockMode) {
        this.entityManager.refresh(entity, lockMode);
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.entityManager.refresh(entity, lockMode, properties);
    }

    public void setProperty(String propertyName, Object value) {
        this.entityManager.setProperty(propertyName, value);
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.entityManager.unwrap(cls);
    }
}

