/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.stats;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.avro.Protocol;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.stats.FloatHistogram;
import org.apache.avro.ipc.stats.Histogram;
import org.apache.avro.ipc.stats.StatsPlugin;
import org.apache.avro.ipc.stats.Stopwatch;

public class StatsServlet
extends HttpServlet {
    private final StatsPlugin statsPlugin;

    public StatsServlet(StatsPlugin statsPlugin) {
        this.statsPlugin = statsPlugin;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        this.writeStats(resp.getWriter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeStats(Writer w) throws IOException {
        w.append("<html><head><title>Avro RPC Stats</title></head>");
        w.append("<body><h1>Avro RPC Stats</h1>");
        w.append("<h2>Active RPCs</h2>");
        w.append("<ol>");
        for (Map.Entry rpc : this.statsPlugin.activeRpcs.entrySet()) {
            this.writeActiveRpc(w, (RPCContext)rpc.getKey(), (Stopwatch)rpc.getValue());
        }
        w.append("</ol>");
        w.append("<h2>Per-method Timing</h2>");
        Map<Protocol.Message, FloatHistogram<?>> map = this.statsPlugin.methodTimings;
        synchronized (map) {
            for (Map.Entry<Protocol.Message, FloatHistogram<?>> e : this.statsPlugin.methodTimings.entrySet()) {
                this.writeMethod(w, e.getKey(), e.getValue());
            }
        }
        w.append("</body></html>");
    }

    private void writeActiveRpc(Writer w, RPCContext rpc, Stopwatch stopwatch) throws IOException {
        w.append("<li>").append(rpc.getMessage().getName()).append(": ");
        w.append(this.formatMillis(StatsPlugin.nanosToMillis(stopwatch.elapsedNanos())));
        w.append("</li>");
    }

    private void writeMethod(Writer w, Protocol.Message message, FloatHistogram<?> hist) throws IOException {
        w.append("<h3>").append(message.getName()).append("</h3>");
        w.append("<p>Number of calls: ");
        w.append(Integer.toString(hist.getCount()));
        w.append("</p><p>Average Duration: ");
        w.append(this.formatMillis(hist.getMean()));
        w.append("</p>");
        w.append("</p><p>Std Dev: ");
        w.append(this.formatMillis(hist.getUnbiasedStdDev()));
        w.append("</p>");
        w.append("<dl>");
        for (Histogram.Entry e : hist.entries()) {
            w.append("<dt>");
            w.append(e.bucket.toString());
            w.append("</dt>");
            w.append("<dd>").append(Integer.toString(e.count)).append("</dd>");
            w.append("</dt>");
        }
        w.append("</dl>");
    }

    private CharSequence formatMillis(float millis) {
        return String.format("%.0fms", Float.valueOf(millis));
    }
}

