/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.PathExceptions;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class Mkdir
extends FsCommand {
    public static final String NAME = "mkdir";
    public static final String USAGE = "<path> ...";
    public static final String DESCRIPTION = "Create a directory in specified location.";

    Mkdir() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Mkdir.class, "-mkdir");
    }

    @Override
    protected void processOptions(LinkedList<String> args) {
        CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, new String[0]);
        cf.parse(args);
    }

    @Override
    protected void processPath(PathData item) throws IOException {
        if (item.stat.isDirectory()) {
            throw new PathExceptions.PathExistsException(item.toString());
        }
        throw new PathExceptions.PathIsNotDirectoryException(item.toString());
    }

    @Override
    protected void processNonexistentPath(PathData item) throws IOException {
        if (!item.fs.mkdirs(item.path)) {
            throw new PathExceptions.PathIOException(item.toString());
        }
    }
}

