/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.Idempotent;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;

class RetryInvocationHandler
implements InvocationHandler {
    public static final Log LOG = LogFactory.getLog(RetryInvocationHandler.class);
    private FailoverProxyProvider proxyProvider;
    private RetryPolicy defaultPolicy;
    private Map<String, RetryPolicy> methodNameToPolicyMap;
    private Object currentProxy;

    public RetryInvocationHandler(FailoverProxyProvider proxyProvider, RetryPolicy retryPolicy) {
        this.proxyProvider = proxyProvider;
        this.defaultPolicy = retryPolicy;
        this.methodNameToPolicyMap = Collections.emptyMap();
        this.currentProxy = proxyProvider.getProxy();
    }

    public RetryInvocationHandler(FailoverProxyProvider proxyProvider, Map<String, RetryPolicy> methodNameToPolicyMap) {
        this.proxyProvider = proxyProvider;
        this.defaultPolicy = RetryPolicies.TRY_ONCE_THEN_FAIL;
        this.methodNameToPolicyMap = methodNameToPolicyMap;
        this.currentProxy = proxyProvider.getProxy();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        RetryPolicy policy = this.methodNameToPolicyMap.get(method.getName());
        if (policy == null) {
            policy = this.defaultPolicy;
        }
        int failovers = 0;
        int retries = 0;
        while (true) {
            try {
                return this.invokeMethod(method, args);
            }
            catch (Exception e) {
                boolean isMethodIdempotent = this.proxyProvider.getInterface().getMethod(method.getName(), method.getParameterTypes()).isAnnotationPresent(Idempotent.class);
                RetryPolicy.RetryAction action = policy.shouldRetry(e, retries++, failovers, isMethodIdempotent);
                if (action == RetryPolicy.RetryAction.FAIL) {
                    LOG.warn((Object)("Exception while invoking " + method.getName() + " of " + this.currentProxy.getClass() + ". Not retrying."), (Throwable)e);
                    if (!method.getReturnType().equals(Void.TYPE)) {
                        throw e;
                    }
                    return null;
                }
                if (action == RetryPolicy.RetryAction.FAILOVER_AND_RETRY) {
                    LOG.warn((Object)("Exception while invoking " + method.getName() + " of " + this.currentProxy.getClass() + ". Trying to fail over."), (Throwable)e);
                    ++failovers;
                    this.proxyProvider.performFailover(this.currentProxy);
                    this.currentProxy = this.proxyProvider.getProxy();
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Exception while invoking " + method.getName() + " of " + this.currentProxy.getClass() + ". Retrying."), (Throwable)e);
                continue;
            }
            break;
        }
    }

    private Object invokeMethod(Method method, Object[] args) throws Throwable {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(this.currentProxy, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

