/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.ProtocolProxy;
import org.apache.hadoop.ipc.RpcEngine;
import org.apache.hadoop.ipc.WritableRpcEngine;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.ReflectionUtils;

public class RPC {
    static final Log LOG = LogFactory.getLog(RPC.class);
    private static final Map<Class, RpcEngine> PROTOCOL_ENGINES = new HashMap<Class, RpcEngine>();
    private static final Map<Class, RpcEngine> PROXY_ENGINES = new HashMap<Class, RpcEngine>();
    private static final String ENGINE_PROP = "rpc.engine";

    private RPC() {
    }

    public static void setProtocolEngine(Configuration conf, Class protocol, Class engine) {
        conf.setClass("rpc.engine." + protocol.getName(), engine, RpcEngine.class);
    }

    private static synchronized RpcEngine getProtocolEngine(Class protocol, Configuration conf) {
        RpcEngine engine = PROTOCOL_ENGINES.get(protocol);
        if (engine == null) {
            Class<?> impl = conf.getClass("rpc.engine." + protocol.getName(), WritableRpcEngine.class);
            engine = (RpcEngine)ReflectionUtils.newInstance(impl, conf);
            if (protocol.isInterface()) {
                PROXY_ENGINES.put(Proxy.getProxyClass(protocol.getClassLoader(), protocol), engine);
            }
            PROTOCOL_ENGINES.put(protocol, engine);
        }
        return engine;
    }

    private static synchronized RpcEngine getProxyEngine(Object proxy) {
        return PROXY_ENGINES.get(proxy.getClass());
    }

    public static <T> T waitForProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        return RPC.waitForProtocolProxy(protocol, clientVersion, addr, conf).getProxy();
    }

    public static <T> ProtocolProxy<T> waitForProtocolProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        return RPC.waitForProtocolProxy(protocol, clientVersion, addr, conf, Long.MAX_VALUE);
    }

    public static <T> T waitForProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, long connTimeout) throws IOException {
        return RPC.waitForProtocolProxy(protocol, clientVersion, addr, conf, connTimeout).getProxy();
    }

    public static <T> ProtocolProxy<T> waitForProtocolProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, long connTimeout) throws IOException {
        return RPC.waitForProtocolProxy(protocol, clientVersion, addr, conf, 0, connTimeout);
    }

    public static <T> T waitForProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, int rpcTimeout, long timeout) throws IOException {
        return RPC.waitForProtocolProxy(protocol, clientVersion, addr, conf, rpcTimeout, timeout).getProxy();
    }

    public static <T> ProtocolProxy<T> waitForProtocolProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, int rpcTimeout, long timeout) throws IOException {
        long startTime = System.currentTimeMillis();
        while (true) {
            IOException ioe;
            try {
                return RPC.getProtocolProxy(protocol, clientVersion, addr, UserGroupInformation.getCurrentUser(), conf, NetUtils.getDefaultSocketFactory(conf), rpcTimeout);
            }
            catch (ConnectException se) {
                LOG.info((Object)("Server at " + addr + " not available yet, Zzzzz..."));
                ioe = se;
            }
            catch (SocketTimeoutException te) {
                LOG.info((Object)("Problem connecting to server: " + addr));
                ioe = te;
            }
            catch (NoRouteToHostException nrthe) {
                LOG.info((Object)("No route to host for server: " + addr));
                ioe = nrthe;
            }
            if (System.currentTimeMillis() - timeout >= startTime) {
                throw ioe;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
            }
        }
    }

    public static <T> T getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, SocketFactory factory) throws IOException {
        return RPC.getProtocolProxy(protocol, clientVersion, addr, conf, factory).getProxy();
    }

    public static <T> ProtocolProxy<T> getProtocolProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, SocketFactory factory) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        return RPC.getProtocolProxy(protocol, clientVersion, addr, ugi, conf, factory);
    }

    public static <T> T getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
        return RPC.getProtocolProxy(protocol, clientVersion, addr, ticket, conf, factory).getProxy();
    }

    public static <T> ProtocolProxy<T> getProtocolProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
        return RPC.getProtocolProxy(protocol, clientVersion, addr, ticket, conf, factory, 0);
    }

    public static <T> T getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout) throws IOException {
        return RPC.getProtocolProxy(protocol, clientVersion, addr, ticket, conf, factory, rpcTimeout).getProxy();
    }

    public static <T> ProtocolProxy<T> getProtocolProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout) throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            SaslRpcServer.init(conf);
        }
        return RPC.getProtocolEngine(protocol, conf).getProxy(protocol, clientVersion, addr, ticket, conf, factory, rpcTimeout);
    }

    public static <T> T getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        return RPC.getProtocolProxy(protocol, clientVersion, addr, conf).getProxy();
    }

    public static <T> ProtocolProxy<T> getProtocolProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        return RPC.getProtocolProxy(protocol, clientVersion, addr, conf, NetUtils.getDefaultSocketFactory(conf));
    }

    public static void stopProxy(Object proxy) {
        RpcEngine rpcEngine;
        if (proxy != null && (rpcEngine = RPC.getProxyEngine(proxy)) != null) {
            rpcEngine.stopProxy(proxy);
        }
    }

    @Deprecated
    public static Object[] call(Method method, Object[][] params, InetSocketAddress[] addrs, Configuration conf) throws IOException, InterruptedException {
        return RPC.call(method, params, addrs, null, conf);
    }

    public static Object[] call(Method method, Object[][] params, InetSocketAddress[] addrs, UserGroupInformation ticket, Configuration conf) throws IOException, InterruptedException {
        return RPC.getProtocolEngine(method.getDeclaringClass(), conf).call(method, params, addrs, ticket, conf);
    }

    @Deprecated
    public static Server getServer(Object instance, String bindAddress, int port, Configuration conf) throws IOException {
        return RPC.getServer(instance, bindAddress, port, 1, false, conf);
    }

    @Deprecated
    public static Server getServer(Object instance, String bindAddress, int port, int numHandlers, boolean verbose, Configuration conf) throws IOException {
        return RPC.getServer(instance.getClass(), instance, bindAddress, port, numHandlers, false, conf, null);
    }

    public static Server getServer(Class protocol, Object instance, String bindAddress, int port, Configuration conf) throws IOException {
        return RPC.getServer(protocol, instance, bindAddress, port, 1, false, conf, null);
    }

    @Deprecated
    public static Server getServer(Class protocol, Object instance, String bindAddress, int port, int numHandlers, boolean verbose, Configuration conf) throws IOException {
        return RPC.getServer(protocol, instance, bindAddress, port, numHandlers, verbose, conf, null);
    }

    public static Server getServer(Class<?> protocol, Object instance, String bindAddress, int port, int numHandlers, boolean verbose, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager) throws IOException {
        return RPC.getProtocolEngine(protocol, conf).getServer(protocol, instance, bindAddress, port, numHandlers, -1, -1, verbose, conf, secretManager);
    }

    public static Server getServer(Class<?> protocol, Object instance, String bindAddress, int port, int numHandlers, int numReaders, int queueSizePerHandler, boolean verbose, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager) throws IOException {
        return RPC.getProtocolEngine(protocol, conf).getServer(protocol, instance, bindAddress, port, numHandlers, numReaders, queueSizePerHandler, verbose, conf, secretManager);
    }

    public static abstract class Server
    extends org.apache.hadoop.ipc.Server {
        protected Server(String bindAddress, int port, Class<? extends Writable> paramClass, int handlerCount, int numReaders, int queueSizePerHandler, Configuration conf, String serverName, SecretManager<? extends TokenIdentifier> secretManager) throws IOException {
            super(bindAddress, port, paramClass, handlerCount, numReaders, queueSizePerHandler, conf, serverName, secretManager);
        }
    }

    public static class VersionMismatch
    extends IOException {
        private static final long serialVersionUID = 0L;
        private String interfaceName;
        private long clientVersion;
        private long serverVersion;

        public VersionMismatch(String interfaceName, long clientVersion, long serverVersion) {
            super("Protocol " + interfaceName + " version mismatch. (client = " + clientVersion + ", server = " + serverVersion + ")");
            this.interfaceName = interfaceName;
            this.clientVersion = clientVersion;
            this.serverVersion = serverVersion;
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public long getClientVersion() {
            return this.clientVersion;
        }

        public long getServerVersion() {
            return this.serverVersion;
        }
    }
}

