/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.ServiceLoader;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.SecurityInfo;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenInfo;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.krb5.Credentials;
import sun.security.krb5.PrincipalName;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class SecurityUtil {
    public static final Log LOG = LogFactory.getLog(SecurityUtil.class);
    public static final String HOSTNAME_PATTERN = "_HOST";
    private static ServiceLoader<SecurityInfo> securityInfoProviders = ServiceLoader.load(SecurityInfo.class);
    private static SecurityInfo[] testProviders = new SecurityInfo[0];

    private static KerberosTicket getTgtFromSubject() throws IOException {
        Subject current = Subject.getSubject(AccessController.getContext());
        if (current == null) {
            throw new IOException("Can't get TGT from current Subject, because it is null");
        }
        Set<KerberosTicket> tickets = current.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket t : tickets) {
            if (!SecurityUtil.isOriginalTGT(t)) continue;
            return t;
        }
        throw new IOException("Failed to find TGT from current Subject");
    }

    static boolean isTGSPrincipal(KerberosPrincipal principal) {
        if (principal == null) {
            return false;
        }
        return principal.getName().equals("krbtgt/" + principal.getRealm() + "@" + principal.getRealm());
    }

    protected static boolean isOriginalTGT(KerberosTicket ticket) {
        return SecurityUtil.isTGSPrincipal(ticket.getServer());
    }

    public static void fetchServiceTicket(URL remoteHost) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        String serviceName = "host/" + remoteHost.getHost();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fetching service ticket for host at: " + serviceName));
        }
        Credentials serviceCred = null;
        try {
            PrincipalName principal = new PrincipalName(serviceName, 3);
            serviceCred = Credentials.acquireServiceCreds(principal.toString(), Krb5Util.ticketToCreds(SecurityUtil.getTgtFromSubject()));
        }
        catch (Exception e) {
            throw new IOException("Can't get service ticket for: " + serviceName, e);
        }
        if (serviceCred == null) {
            throw new IOException("Can't get service ticket for " + serviceName);
        }
        Subject.getSubject(AccessController.getContext()).getPrivateCredentials().add(Krb5Util.credsToTicket(serviceCred));
    }

    public static String getServerPrincipal(String principalConfig, String hostname) throws IOException {
        String[] components = SecurityUtil.getComponents(principalConfig);
        if (components == null || components.length != 3 || !components[1].equals(HOSTNAME_PATTERN)) {
            return principalConfig;
        }
        return SecurityUtil.replacePattern(components, hostname);
    }

    public static String getServerPrincipal(String principalConfig, InetAddress addr) throws IOException {
        String[] components = SecurityUtil.getComponents(principalConfig);
        if (components == null || components.length != 3 || !components[1].equals(HOSTNAME_PATTERN)) {
            return principalConfig;
        }
        if (addr == null) {
            throw new IOException("Can't replace _HOST pattern since client address is null");
        }
        return SecurityUtil.replacePattern(components, addr.getCanonicalHostName());
    }

    private static String[] getComponents(String principalConfig) {
        if (principalConfig == null) {
            return null;
        }
        return principalConfig.split("[/@]");
    }

    private static String replacePattern(String[] components, String hostname) throws IOException {
        String fqdn = hostname;
        if (fqdn == null || fqdn.equals("") || fqdn.equals("0.0.0.0")) {
            fqdn = SecurityUtil.getLocalHostName();
        }
        return components[0] + "/" + fqdn + "@" + components[2];
    }

    static String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    public static void login(Configuration conf, String keytabFileKey, String userNameKey) throws IOException {
        SecurityUtil.login(conf, keytabFileKey, userNameKey, SecurityUtil.getLocalHostName());
    }

    public static void login(Configuration conf, String keytabFileKey, String userNameKey, String hostname) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        String keytabFilename = conf.get(keytabFileKey);
        if (keytabFilename == null || keytabFilename.length() == 0) {
            throw new IOException("Running in secure mode, but config doesn't have a keytab");
        }
        String principalConfig = conf.get(userNameKey, System.getProperty("user.name"));
        String principalName = SecurityUtil.getServerPrincipal(principalConfig, hostname);
        UserGroupInformation.loginUserFromKeytab(principalName, keytabFilename);
    }

    public static String buildDTServiceName(URI uri, int defPort) {
        int port = uri.getPort();
        if (port == -1) {
            port = defPort;
        }
        StringBuffer sb = new StringBuffer();
        String host = uri.getHost();
        host = host != null ? NetUtils.normalizeHostName(host) : "";
        sb.append(host).append(":").append(port);
        return sb.toString();
    }

    public static String getHostFromPrincipal(String principalName) {
        return new HadoopKerberosName(principalName).getHostName();
    }

    @InterfaceAudience.Private
    public static void setSecurityInfoProviders(SecurityInfo ... providers) {
        testProviders = providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KerberosInfo getKerberosInfo(Class<?> protocol, Configuration conf) {
        Object object = testProviders;
        synchronized (testProviders) {
            for (SecurityInfo provider : testProviders) {
                KerberosInfo result = provider.getKerberosInfo(protocol, conf);
                if (result == null) continue;
                // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                return result;
            }
            // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
            object = securityInfoProviders;
            synchronized (object) {
                for (SecurityInfo provider : securityInfoProviders) {
                    KerberosInfo result = provider.getKerberosInfo(protocol, conf);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TokenInfo getTokenInfo(Class<?> protocol, Configuration conf) {
        Object object = testProviders;
        synchronized (testProviders) {
            for (SecurityInfo provider : testProviders) {
                TokenInfo result = provider.getTokenInfo(protocol, conf);
                if (result == null) continue;
                // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                return result;
            }
            // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
            object = securityInfoProviders;
            synchronized (object) {
                for (SecurityInfo provider : securityInfoProviders) {
                    TokenInfo result = provider.getTokenInfo(protocol, conf);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }
    }

    public static void setTokenService(Token<?> token, InetSocketAddress addr) {
        token.setService(SecurityUtil.buildTokenService(addr));
    }

    public static Text buildTokenService(InetSocketAddress addr) {
        String host = addr.getAddress().getHostAddress();
        return new Text(host + ":" + addr.getPort());
    }
}

