/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.GlobExpander;
import org.apache.hadoop.fs.GlobFilter;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class FileSystem
extends Configured
implements Closeable {
    public static final String FS_DEFAULT_NAME_KEY = "fs.defaultFS";
    public static final String DEFAULT_FS = "file:///";
    public static final Log LOG = LogFactory.getLog(FileSystem.class);
    static final Cache CACHE = new Cache();
    private Cache.Key key;
    private static final Map<Class<? extends FileSystem>, Statistics> statisticsTable = new IdentityHashMap<Class<? extends FileSystem>, Statistics>();
    protected Statistics statistics;
    private Set<Path> deleteOnExit = new TreeSet<Path>();
    private static final PathFilter DEFAULT_FILTER = new PathFilter(){

        @Override
        public boolean accept(Path file) {
            return true;
        }
    };

    static void addFileSystemForTesting(URI uri, Configuration conf, FileSystem fs) throws IOException {
        CACHE.map.put(new Cache.Key(uri, conf), fs);
    }

    public static FileSystem get(final URI uri, final Configuration conf, String user) throws IOException, InterruptedException {
        UserGroupInformation ugi = user == null ? UserGroupInformation.getCurrentUser() : UserGroupInformation.createRemoteUser(user);
        return ugi.doAs(new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws IOException {
                return FileSystem.get(uri, conf);
            }
        });
    }

    public static FileSystem get(Configuration conf) throws IOException {
        return FileSystem.get(FileSystem.getDefaultUri(conf), conf);
    }

    public static URI getDefaultUri(Configuration conf) {
        return URI.create(FileSystem.fixName(conf.get(FS_DEFAULT_NAME_KEY, DEFAULT_FS)));
    }

    public static void setDefaultUri(Configuration conf, URI uri) {
        conf.set(FS_DEFAULT_NAME_KEY, uri.toString());
    }

    public static void setDefaultUri(Configuration conf, String uri) {
        FileSystem.setDefaultUri(conf, URI.create(FileSystem.fixName(uri)));
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        this.statistics = FileSystem.getStatistics(name.getScheme(), this.getClass());
    }

    public abstract URI getUri();

    protected URI getCanonicalUri() {
        return NetUtils.getCanonicalUri(this.getUri(), this.getDefaultPort());
    }

    protected int getDefaultPort() {
        return 0;
    }

    public String getCanonicalServiceName() {
        return SecurityUtil.buildDTServiceName(this.getUri(), this.getDefaultPort());
    }

    @Deprecated
    public String getName() {
        return this.getUri().toString();
    }

    @Deprecated
    public static FileSystem getNamed(String name, Configuration conf) throws IOException {
        return FileSystem.get(URI.create(FileSystem.fixName(name)), conf);
    }

    private static String fixName(String name) {
        if (name.equals("local")) {
            LOG.warn((Object)"\"local\" is a deprecated filesystem name. Use \"file:///\" instead.");
            name = DEFAULT_FS;
        } else if (name.indexOf(47) == -1) {
            LOG.warn((Object)("\"" + name + "\" is a deprecated filesystem name." + " Use \"hdfs://" + name + "/\" instead."));
            name = "hdfs://" + name;
        }
        return name;
    }

    public static LocalFileSystem getLocal(Configuration conf) throws IOException {
        return (LocalFileSystem)FileSystem.get(LocalFileSystem.NAME, conf);
    }

    public static FileSystem get(URI uri, Configuration conf) throws IOException {
        URI defaultUri;
        String scheme = uri.getScheme();
        String authority = uri.getAuthority();
        if (scheme == null) {
            return FileSystem.get(conf);
        }
        if (authority == null && scheme.equals((defaultUri = FileSystem.getDefaultUri(conf)).getScheme()) && defaultUri.getAuthority() != null) {
            return FileSystem.get(defaultUri, conf);
        }
        String disableCacheName = String.format("fs.%s.impl.disable.cache", scheme);
        if (conf.getBoolean(disableCacheName, false)) {
            return FileSystem.createFileSystem(uri, conf);
        }
        return CACHE.get(uri, conf);
    }

    public static FileSystem newInstance(final URI uri, final Configuration conf, String user) throws IOException, InterruptedException {
        UserGroupInformation ugi = user == null ? UserGroupInformation.getCurrentUser() : UserGroupInformation.createRemoteUser(user);
        return ugi.doAs(new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws IOException {
                return FileSystem.newInstance(uri, conf);
            }
        });
    }

    public static FileSystem newInstance(URI uri, Configuration conf) throws IOException {
        URI defaultUri;
        String scheme = uri.getScheme();
        String authority = uri.getAuthority();
        if (scheme == null) {
            return FileSystem.newInstance(conf);
        }
        if (authority == null && scheme.equals((defaultUri = FileSystem.getDefaultUri(conf)).getScheme()) && defaultUri.getAuthority() != null) {
            return FileSystem.newInstance(defaultUri, conf);
        }
        return CACHE.getUnique(uri, conf);
    }

    public static FileSystem newInstance(Configuration conf) throws IOException {
        return FileSystem.newInstance(FileSystem.getDefaultUri(conf), conf);
    }

    public static LocalFileSystem newInstanceLocal(Configuration conf) throws IOException {
        return (LocalFileSystem)FileSystem.newInstance(LocalFileSystem.NAME, conf);
    }

    public static void closeAll() throws IOException {
        CACHE.closeAll();
    }

    public static void closeAllForUGI(UserGroupInformation ugi) throws IOException {
        CACHE.closeAll(ugi);
    }

    public Path makeQualified(Path path) {
        this.checkPath(path);
        return path.makeQualified(this.getUri(), this.getWorkingDirectory());
    }

    @Deprecated
    @InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
    public Token<?> getDelegationToken(String renewer) throws IOException {
        return null;
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
    public List<Token<?>> getDelegationTokens(String renewer) throws IOException {
        return new ArrayList(0);
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
    public List<Token<?>> getDelegationTokens(String renewer, Credentials credentials) throws IOException {
        List<Token<?>> allTokens = this.getDelegationTokens(renewer);
        ArrayList newTokens = new ArrayList();
        if (allTokens != null) {
            for (Token<?> token : allTokens) {
                Token<? extends TokenIdentifier> knownToken = credentials.getToken(token.getService());
                if (knownToken == null) {
                    newTokens.add(token);
                    continue;
                }
                newTokens.add(knownToken);
            }
        }
        return newTokens;
    }

    public static FSDataOutputStream create(FileSystem fs, Path file, FsPermission permission) throws IOException {
        FSDataOutputStream out = fs.create(file);
        fs.setPermission(file, permission);
        return out;
    }

    public static boolean mkdirs(FileSystem fs, Path dir, FsPermission permission) throws IOException {
        boolean result = fs.mkdirs(dir);
        fs.setPermission(dir, permission);
        return result;
    }

    protected FileSystem() {
        super(null);
    }

    protected void checkPath(Path path) {
        URI uri = path.toUri();
        String thatScheme = uri.getScheme();
        if (thatScheme == null) {
            return;
        }
        URI thisUri = this.getCanonicalUri();
        String thisScheme = thisUri.getScheme();
        if (thisScheme.equalsIgnoreCase(thatScheme)) {
            String thisAuthority = thisUri.getAuthority();
            String thatAuthority = uri.getAuthority();
            if (thatAuthority == null && thisAuthority != null) {
                URI defaultUri = FileSystem.getDefaultUri(this.getConf());
                uri = thisScheme.equalsIgnoreCase(defaultUri.getScheme()) ? defaultUri : null;
            }
            if (uri != null && (thisAuthority == (thatAuthority = (uri = NetUtils.getCanonicalUri(uri, this.getDefaultPort())).getAuthority()) || thisAuthority != null && thisAuthority.equalsIgnoreCase(thatAuthority))) {
                return;
            }
        }
        throw new IllegalArgumentException("Wrong FS: " + path + ", expected: " + this.getUri());
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (file == null) {
            return null;
        }
        if (start < 0L || len < 0L) {
            throw new IllegalArgumentException("Invalid start or len parameter");
        }
        if (file.getLen() < start) {
            return new BlockLocation[0];
        }
        String[] name = new String[]{"localhost:50010"};
        String[] host = new String[]{"localhost"};
        return new BlockLocation[]{new BlockLocation(name, host, 0L, file.getLen())};
    }

    public BlockLocation[] getFileBlockLocations(Path p, long start, long len) throws IOException {
        if (p == null) {
            throw new NullPointerException();
        }
        FileStatus file = this.getFileStatus(p);
        return this.getFileBlockLocations(file, start, len);
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        Configuration conf = this.getConf();
        return new FsServerDefaults(this.getDefaultBlockSize(), conf.getInt("io.bytes.per.checksum", 512), 65536, this.getDefaultReplication(), conf.getInt("io.file.buffer.size", 4096));
    }

    public Path resolvePath(Path p) throws IOException {
        this.checkPath(p);
        return this.getFileStatus(p).getPath();
    }

    public abstract FSDataInputStream open(Path var1, int var2) throws IOException;

    public FSDataInputStream open(Path f) throws IOException {
        return this.open(f, this.getConf().getInt("io.file.buffer.size", 4096));
    }

    public FSDataOutputStream create(Path f) throws IOException {
        return this.create(f, true);
    }

    public FSDataOutputStream create(Path f, boolean overwrite) throws IOException {
        return this.create(f, overwrite, this.getConf().getInt("io.file.buffer.size", 4096), this.getDefaultReplication(), this.getDefaultBlockSize());
    }

    public FSDataOutputStream create(Path f, Progressable progress) throws IOException {
        return this.create(f, true, this.getConf().getInt("io.file.buffer.size", 4096), this.getDefaultReplication(), this.getDefaultBlockSize(), progress);
    }

    public FSDataOutputStream create(Path f, short replication) throws IOException {
        return this.create(f, true, this.getConf().getInt("io.file.buffer.size", 4096), replication, this.getDefaultBlockSize());
    }

    public FSDataOutputStream create(Path f, short replication, Progressable progress) throws IOException {
        return this.create(f, true, this.getConf().getInt("io.file.buffer.size", 4096), replication, this.getDefaultBlockSize(), progress);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize) throws IOException {
        return this.create(f, overwrite, bufferSize, this.getDefaultReplication(), this.getDefaultBlockSize());
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, Progressable progress) throws IOException {
        return this.create(f, overwrite, bufferSize, this.getDefaultReplication(), this.getDefaultBlockSize(), progress);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        return this.create(f, overwrite, bufferSize, replication, blockSize, null);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(f, FsPermission.getDefault().applyUMask(FsPermission.getUMask(this.getConf())), overwrite, bufferSize, replication, blockSize, progress);
    }

    public abstract FSDataOutputStream create(Path var1, FsPermission var2, boolean var3, int var4, short var5, long var6, Progressable var8) throws IOException;

    @Deprecated
    protected FSDataOutputStream primitiveCreate(Path f, FsPermission absolutePermission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress, int bytesPerChecksum) throws IOException {
        boolean pathExists = this.exists(f);
        CreateFlag.validate(f, pathExists, flag);
        if (pathExists && flag.contains((Object)CreateFlag.APPEND)) {
            return this.append(f, bufferSize, progress);
        }
        return this.create(f, absolutePermission, flag.contains((Object)CreateFlag.OVERWRITE), bufferSize, replication, blockSize, progress);
    }

    @Deprecated
    protected boolean primitiveMkdir(Path f, FsPermission absolutePermission) throws IOException {
        return this.mkdirs(f, absolutePermission);
    }

    @Deprecated
    protected void primitiveMkdir(Path f, FsPermission absolutePermission, boolean createParent) throws IOException {
        if (!createParent) {
            FileStatus stat = this.getFileStatus(f.getParent());
            if (stat == null) {
                throw new FileNotFoundException("Missing parent:" + f);
            }
            if (!stat.isDirectory()) {
                throw new ParentNotDirectoryException("parent is not a dir");
            }
        }
        if (!this.mkdirs(f, absolutePermission)) {
            throw new IOException("mkdir of " + f + " failed");
        }
    }

    @Deprecated
    public FSDataOutputStream createNonRecursive(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.createNonRecursive(f, FsPermission.getDefault(), overwrite, bufferSize, replication, blockSize, progress);
    }

    @Deprecated
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new IOException("createNonRecursive unsupported for this filesystem " + this.getClass());
    }

    public boolean createNewFile(Path f) throws IOException {
        if (this.exists(f)) {
            return false;
        }
        this.create(f, false, this.getConf().getInt("io.file.buffer.size", 4096)).close();
        return true;
    }

    public FSDataOutputStream append(Path f) throws IOException {
        return this.append(f, this.getConf().getInt("io.file.buffer.size", 4096), null);
    }

    public FSDataOutputStream append(Path f, int bufferSize) throws IOException {
        return this.append(f, bufferSize, null);
    }

    public abstract FSDataOutputStream append(Path var1, int var2, Progressable var3) throws IOException;

    @Deprecated
    public short getReplication(Path src) throws IOException {
        return this.getFileStatus(src).getReplication();
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        return true;
    }

    public abstract boolean rename(Path var1, Path var2) throws IOException;

    @Deprecated
    protected void rename(Path src, Path dst, Options.Rename ... options) throws IOException {
        FileStatus dstStatus;
        FileStatus srcStatus = this.getFileStatus(src);
        if (srcStatus == null) {
            throw new FileNotFoundException("rename source " + src + " not found.");
        }
        boolean overwrite = false;
        if (null != options) {
            for (Options.Rename option : options) {
                if (option != Options.Rename.OVERWRITE) continue;
                overwrite = true;
            }
        }
        try {
            dstStatus = this.getFileStatus(dst);
        }
        catch (IOException e) {
            dstStatus = null;
        }
        if (dstStatus != null) {
            FileStatus[] list;
            if (srcStatus.isDirectory() != dstStatus.isDirectory()) {
                throw new IOException("Source " + src + " Destination " + dst + " both should be either file or directory");
            }
            if (!overwrite) {
                throw new FileAlreadyExistsException("rename destination " + dst + " already exists.");
            }
            if (dstStatus.isDirectory() && (list = this.listStatus(dst)) != null && list.length != 0) {
                throw new IOException("rename cannot overwrite non empty destination directory " + dst);
            }
            this.delete(dst, false);
        } else {
            Path parent = dst.getParent();
            FileStatus parentStatus = this.getFileStatus(parent);
            if (parentStatus == null) {
                throw new FileNotFoundException("rename destination parent " + parent + " not found.");
            }
            if (!parentStatus.isDirectory()) {
                throw new ParentNotDirectoryException("rename destination parent " + parent + " is a file.");
            }
        }
        if (!this.rename(src, dst)) {
            throw new IOException("rename from " + src + " to " + dst + " failed.");
        }
    }

    @Deprecated
    public boolean delete(Path f) throws IOException {
        return this.delete(f, true);
    }

    public abstract boolean delete(Path var1, boolean var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteOnExit(Path f) throws IOException {
        if (!this.exists(f)) {
            return false;
        }
        Set<Path> set = this.deleteOnExit;
        synchronized (set) {
            this.deleteOnExit.add(f);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDeleteOnExit() {
        Set<Path> set = this.deleteOnExit;
        synchronized (set) {
            Iterator<Path> iter = this.deleteOnExit.iterator();
            while (iter.hasNext()) {
                Path path = iter.next();
                try {
                    this.delete(path, true);
                }
                catch (IOException e) {
                    LOG.info((Object)("Ignoring failure to deleteOnExit for path " + path));
                }
                iter.remove();
            }
        }
    }

    public boolean exists(Path f) throws IOException {
        try {
            return this.getFileStatus(f) != null;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public boolean isDirectory(Path f) throws IOException {
        try {
            return this.getFileStatus(f).isDirectory();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public boolean isFile(Path f) throws IOException {
        try {
            return this.getFileStatus(f).isFile();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Deprecated
    public long getLength(Path f) throws IOException {
        return this.getFileStatus(f).getLen();
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        FileStatus status = this.getFileStatus(f);
        if (status.isFile()) {
            return new ContentSummary(status.getLen(), 1L, 0L);
        }
        long[] summary = new long[]{0L, 0L, 1L};
        for (FileStatus s : this.listStatus(f)) {
            ContentSummary c = s.isDirectory() ? this.getContentSummary(s.getPath()) : new ContentSummary(s.getLen(), 1L, 0L);
            summary[0] = summary[0] + c.getLength();
            summary[1] = summary[1] + c.getFileCount();
            summary[2] = summary[2] + c.getDirectoryCount();
        }
        return new ContentSummary(summary[0], summary[1], summary[2]);
    }

    public abstract FileStatus[] listStatus(Path var1) throws FileNotFoundException, IOException;

    private void listStatus(ArrayList<FileStatus> results, Path f, PathFilter filter) throws FileNotFoundException, IOException {
        FileStatus[] listing = this.listStatus(f);
        if (listing == null) {
            throw new IOException("Error accessing " + f);
        }
        for (int i = 0; i < listing.length; ++i) {
            if (!filter.accept(listing[i].getPath())) continue;
            results.add(listing[i]);
        }
    }

    public RemoteIterator<Path> listCorruptFileBlocks(Path path) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does not support" + " listCorruptFileBlocks");
    }

    public FileStatus[] listStatus(Path f, PathFilter filter) throws FileNotFoundException, IOException {
        ArrayList<FileStatus> results = new ArrayList<FileStatus>();
        this.listStatus(results, f, filter);
        return results.toArray(new FileStatus[results.size()]);
    }

    public FileStatus[] listStatus(Path[] files) throws FileNotFoundException, IOException {
        return this.listStatus(files, DEFAULT_FILTER);
    }

    public FileStatus[] listStatus(Path[] files, PathFilter filter) throws FileNotFoundException, IOException {
        ArrayList<FileStatus> results = new ArrayList<FileStatus>();
        for (int i = 0; i < files.length; ++i) {
            this.listStatus(results, files[i], filter);
        }
        return results.toArray(new FileStatus[results.size()]);
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        return this.globStatus(pathPattern, DEFAULT_FILTER);
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        String filename = pathPattern.toUri().getPath();
        List<String> filePatterns = GlobExpander.expand(filename);
        if (filePatterns.size() == 1) {
            return this.globStatusInternal(pathPattern, filter);
        }
        ArrayList<FileStatus> results = new ArrayList<FileStatus>();
        for (String filePattern : filePatterns) {
            FileStatus[] files;
            for (FileStatus file : files = this.globStatusInternal(new Path(filePattern), filter)) {
                results.add(file);
            }
        }
        return results.toArray(new FileStatus[results.size()]);
    }

    private FileStatus[] globStatusInternal(Path pathPattern, PathFilter filter) throws IOException {
        FileStatus[] results;
        Path[] parents = new Path[1];
        int level = 0;
        String filename = pathPattern.toUri().getPath();
        if ("".equals(filename) || "/".equals(filename)) {
            return this.getFileStatus(new Path[]{pathPattern});
        }
        String[] components = filename.split("/");
        if (pathPattern.isAbsolute()) {
            parents[0] = new Path("/");
            level = 1;
        } else {
            parents[0] = new Path(".");
        }
        boolean[] hasGlob = new boolean[]{false};
        Path[] parentPaths = this.globPathsLevel(parents, components, level, hasGlob);
        if (parentPaths == null || parentPaths.length == 0) {
            results = null;
        } else {
            GlobFilter fp = new GlobFilter(components[components.length - 1], filter);
            if (fp.hasPattern()) {
                results = this.listStatus(parentPaths, (PathFilter)fp);
                hasGlob[0] = true;
            } else {
                String name = this.unquotePathComponent(components[components.length - 1]);
                ArrayList<Path> filteredPaths = new ArrayList<Path>(parentPaths.length);
                for (int i = 0; i < parentPaths.length; ++i) {
                    parentPaths[i] = new Path(parentPaths[i], name);
                    if (!fp.accept(parentPaths[i])) continue;
                    filteredPaths.add(parentPaths[i]);
                }
                results = this.getFileStatus(filteredPaths.toArray(new Path[filteredPaths.size()]));
            }
        }
        if (results == null) {
            if (hasGlob[0]) {
                results = new FileStatus[]{};
            }
        } else if (results.length == 0) {
            if (!hasGlob[0]) {
                results = null;
            }
        } else {
            Arrays.sort(results);
        }
        return results;
    }

    private Path[] globPathsLevel(Path[] parents, String[] filePattern, int level, boolean[] hasGlob) throws IOException {
        if (level == filePattern.length - 1) {
            return parents;
        }
        if (parents == null || parents.length == 0) {
            return null;
        }
        GlobFilter fp = new GlobFilter(filePattern[level]);
        if (fp.hasPattern()) {
            parents = FileUtil.stat2Paths(this.listStatus(parents, (PathFilter)fp));
            hasGlob[0] = true;
        } else {
            String name = this.unquotePathComponent(filePattern[level]);
            for (int i = 0; i < parents.length; ++i) {
                parents[i] = new Path(parents[i], name);
            }
        }
        return this.globPathsLevel(parents, filePattern, level + 1, hasGlob);
    }

    private String unquotePathComponent(String name) {
        return name.replaceAll("\\\\(.)", "$1");
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws FileNotFoundException, IOException {
        return this.listLocatedStatus(f, DEFAULT_FILTER);
    }

    protected RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path f, final PathFilter filter) throws FileNotFoundException, IOException {
        return new RemoteIterator<LocatedFileStatus>(){
            private final FileStatus[] stats;
            private int i;
            {
                this.stats = FileSystem.this.listStatus(f, filter);
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                return this.i < this.stats.length;
            }

            @Override
            public LocatedFileStatus next() throws IOException {
                FileStatus result;
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more entry in " + f);
                }
                BlockLocation[] locs = (result = this.stats[this.i++]).isFile() ? FileSystem.this.getFileBlockLocations(result.getPath(), 0L, result.getLen()) : null;
                return new LocatedFileStatus(result, locs);
            }
        };
    }

    public RemoteIterator<LocatedFileStatus> listFiles(final Path f, final boolean recursive) throws FileNotFoundException, IOException {
        return new RemoteIterator<LocatedFileStatus>(){
            private Stack<RemoteIterator<LocatedFileStatus>> itors = new Stack();
            private RemoteIterator<LocatedFileStatus> curItor = FileSystem.this.listLocatedStatus(f);
            private LocatedFileStatus curFile;

            @Override
            public boolean hasNext() throws IOException {
                while (this.curFile == null) {
                    if (this.curItor.hasNext()) {
                        this.handleFileStat(this.curItor.next());
                        continue;
                    }
                    if (!this.itors.empty()) {
                        this.curItor = this.itors.pop();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            private void handleFileStat(LocatedFileStatus stat) throws IOException {
                if (stat.isFile()) {
                    this.curFile = stat;
                } else if (recursive) {
                    this.itors.push(this.curItor);
                    this.curItor = FileSystem.this.listLocatedStatus(stat.getPath());
                }
            }

            @Override
            public LocatedFileStatus next() throws IOException {
                if (this.hasNext()) {
                    LocatedFileStatus result = this.curFile;
                    this.curFile = null;
                    return result;
                }
                throw new NoSuchElementException("No more entry in " + f);
            }
        };
    }

    public Path getHomeDirectory() {
        return this.makeQualified(new Path("/user/" + System.getProperty("user.name")));
    }

    public abstract void setWorkingDirectory(Path var1);

    public abstract Path getWorkingDirectory();

    protected Path getInitialWorkingDirectory() {
        return null;
    }

    public boolean mkdirs(Path f) throws IOException {
        return this.mkdirs(f, FsPermission.getDefault());
    }

    public abstract boolean mkdirs(Path var1, FsPermission var2) throws IOException;

    public void copyFromLocalFile(Path src, Path dst) throws IOException {
        this.copyFromLocalFile(false, src, dst);
    }

    public void moveFromLocalFile(Path[] srcs, Path dst) throws IOException {
        this.copyFromLocalFile(true, true, srcs, dst);
    }

    public void moveFromLocalFile(Path src, Path dst) throws IOException {
        this.copyFromLocalFile(true, src, dst);
    }

    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.copyFromLocalFile(delSrc, true, src, dst);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        Configuration conf = this.getConf();
        FileUtil.copy((FileSystem)FileSystem.getLocal(conf), srcs, this, dst, delSrc, overwrite, conf);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        Configuration conf = this.getConf();
        FileUtil.copy((FileSystem)FileSystem.getLocal(conf), src, this, dst, delSrc, overwrite, conf);
    }

    public void copyToLocalFile(Path src, Path dst) throws IOException {
        this.copyToLocalFile(false, src, dst);
    }

    public void moveToLocalFile(Path src, Path dst) throws IOException {
        this.copyToLocalFile(true, src, dst);
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.copyToLocalFile(delSrc, src, dst, false);
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst, boolean useRawLocalFileSystem) throws IOException {
        Configuration conf = this.getConf();
        FileSystem local = null;
        local = useRawLocalFileSystem ? FileSystem.getLocal(conf).getRawFileSystem() : FileSystem.getLocal(conf);
        FileUtil.copy(this, src, local, dst, delSrc, conf);
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        return tmpLocalFile;
    }

    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        this.moveFromLocalFile(tmpLocalFile, fsOutputFile);
    }

    @Override
    public void close() throws IOException {
        this.processDeleteOnExit();
        CACHE.remove(this.key, this);
    }

    public long getUsed() throws IOException {
        FileStatus[] files;
        long used = 0L;
        for (FileStatus file : files = this.listStatus(new Path("/"))) {
            used += file.getLen();
        }
        return used;
    }

    @Deprecated
    public long getBlockSize(Path f) throws IOException {
        return this.getFileStatus(f).getBlockSize();
    }

    public long getDefaultBlockSize() {
        return this.getConf().getLong("fs.local.block.size", 0x2000000L);
    }

    public short getDefaultReplication() {
        return 1;
    }

    public abstract FileStatus getFileStatus(Path var1) throws IOException;

    public FileChecksum getFileChecksum(Path f) throws IOException {
        return null;
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
    }

    public void setWriteChecksum(boolean writeChecksum) {
    }

    private FileStatus[] getFileStatus(Path[] paths) throws IOException {
        if (paths == null) {
            return null;
        }
        ArrayList<FileStatus> results = new ArrayList<FileStatus>(paths.length);
        for (int i = 0; i < paths.length; ++i) {
            try {
                results.add(this.getFileStatus(paths[i]));
                continue;
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        return results.toArray(new FileStatus[results.size()]);
    }

    public FsStatus getStatus() throws IOException {
        return this.getStatus(null);
    }

    public FsStatus getStatus(Path p) throws IOException {
        return new FsStatus(Long.MAX_VALUE, 0L, Long.MAX_VALUE);
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
    }

    private static FileSystem createFileSystem(URI uri, Configuration conf) throws IOException {
        Class<?> clazz = conf.getClass("fs." + uri.getScheme() + ".impl", null);
        if (clazz == null) {
            throw new IOException("No FileSystem for scheme: " + uri.getScheme());
        }
        FileSystem fs = (FileSystem)ReflectionUtils.newInstance(clazz, conf);
        fs.initialize(uri, conf);
        return fs;
    }

    @Deprecated
    public static synchronized Map<String, Statistics> getStatistics() {
        HashMap<String, Statistics> result = new HashMap<String, Statistics>();
        for (Statistics stat : statisticsTable.values()) {
            result.put(stat.getScheme(), stat);
        }
        return result;
    }

    public static synchronized List<Statistics> getAllStatistics() {
        return new ArrayList<Statistics>(statisticsTable.values());
    }

    public static synchronized Statistics getStatistics(String scheme, Class<? extends FileSystem> cls) {
        Statistics result = statisticsTable.get(cls);
        if (result == null) {
            result = new Statistics(scheme);
            statisticsTable.put(cls, result);
        }
        return result;
    }

    public static synchronized void clearStatistics() {
        for (Statistics stat : statisticsTable.values()) {
            stat.reset();
        }
    }

    public static synchronized void printStatistics() throws IOException {
        for (Map.Entry<Class<? extends FileSystem>, Statistics> pair : statisticsTable.entrySet()) {
            System.out.println("  FileSystem " + pair.getKey().getName() + ": " + pair.getValue());
        }
    }

    public static final class Statistics {
        private final String scheme;
        private AtomicLong bytesRead = new AtomicLong();
        private AtomicLong bytesWritten = new AtomicLong();
        private AtomicInteger readOps = new AtomicInteger();
        private AtomicInteger largeReadOps = new AtomicInteger();
        private AtomicInteger writeOps = new AtomicInteger();

        public Statistics(String scheme) {
            this.scheme = scheme;
        }

        public Statistics(Statistics st) {
            this.scheme = st.scheme;
            this.bytesRead = new AtomicLong(st.bytesRead.longValue());
            this.bytesWritten = new AtomicLong(st.bytesWritten.longValue());
        }

        public void incrementBytesRead(long newBytes) {
            this.bytesRead.getAndAdd(newBytes);
        }

        public void incrementBytesWritten(long newBytes) {
            this.bytesWritten.getAndAdd(newBytes);
        }

        public void incrementReadOps(int count) {
            this.readOps.getAndAdd(count);
        }

        public void incrementLargeReadOps(int count) {
            this.largeReadOps.getAndAdd(count);
        }

        public void incrementWriteOps(int count) {
            this.writeOps.getAndAdd(count);
        }

        public long getBytesRead() {
            return this.bytesRead.get();
        }

        public long getBytesWritten() {
            return this.bytesWritten.get();
        }

        public int getReadOps() {
            return this.readOps.get() + this.largeReadOps.get();
        }

        public int getLargeReadOps() {
            return this.largeReadOps.get();
        }

        public int getWriteOps() {
            return this.writeOps.get();
        }

        public String toString() {
            return this.bytesRead + " bytes read, " + this.bytesWritten + " bytes written, " + this.readOps + " read ops, " + this.largeReadOps + " large read ops, " + this.writeOps + " write ops";
        }

        public void reset() {
            this.bytesWritten.set(0L);
            this.bytesRead.set(0L);
        }

        public String getScheme() {
            return this.scheme;
        }
    }

    static class Cache {
        private final ClientFinalizer clientFinalizer = new ClientFinalizer();
        private final Map<Key, FileSystem> map = new HashMap<Key, FileSystem>();
        private final Set<Key> toAutoClose = new HashSet<Key>();
        private static AtomicLong unique = new AtomicLong(1L);

        Cache() {
        }

        FileSystem get(URI uri, Configuration conf) throws IOException {
            Key key = new Key(uri, conf);
            return this.getInternal(uri, conf, key);
        }

        FileSystem getUnique(URI uri, Configuration conf) throws IOException {
            Key key = new Key(uri, conf, unique.getAndIncrement());
            return this.getInternal(uri, conf, key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FileSystem getInternal(URI uri, Configuration conf, Key key) throws IOException {
            FileSystem fs;
            Cache cache = this;
            synchronized (cache) {
                fs = this.map.get(key);
            }
            if (fs != null) {
                return fs;
            }
            fs = FileSystem.createFileSystem(uri, conf);
            cache = this;
            synchronized (cache) {
                FileSystem oldfs = this.map.get(key);
                if (oldfs != null) {
                    fs.close();
                    return oldfs;
                }
                if (this.map.isEmpty() && !this.clientFinalizer.isAlive()) {
                    Runtime.getRuntime().addShutdownHook(this.clientFinalizer);
                }
                fs.key = key;
                this.map.put(key, fs);
                if (conf.getBoolean("fs.automatic.close", true)) {
                    this.toAutoClose.add(key);
                }
                return fs;
            }
        }

        synchronized void remove(Key key, FileSystem fs) {
            if (this.map.containsKey(key) && fs == this.map.get(key)) {
                this.map.remove(key);
                this.toAutoClose.remove(key);
                if (this.map.isEmpty() && !this.clientFinalizer.isAlive() && !Runtime.getRuntime().removeShutdownHook(this.clientFinalizer)) {
                    LOG.info((Object)"Could not cancel cleanup thread, though no FileSystems are open");
                }
            }
        }

        synchronized void closeAll() throws IOException {
            this.closeAll(false);
        }

        synchronized void closeAll(boolean onlyAutomatic) throws IOException {
            ArrayList<IOException> exceptions = new ArrayList<IOException>();
            ArrayList<Key> keys = new ArrayList<Key>();
            keys.addAll(this.map.keySet());
            for (Key key : keys) {
                FileSystem fs = this.map.get(key);
                if (onlyAutomatic && !this.toAutoClose.contains(key)) continue;
                this.remove(key, fs);
                if (fs == null) continue;
                try {
                    fs.close();
                }
                catch (IOException ioe) {
                    exceptions.add(ioe);
                }
            }
            if (!exceptions.isEmpty()) {
                throw MultipleIOException.createIOException(exceptions);
            }
        }

        synchronized void closeAll(UserGroupInformation ugi) throws IOException {
            ArrayList<FileSystem> targetFSList = new ArrayList<FileSystem>();
            for (Map.Entry<Key, FileSystem> entry : this.map.entrySet()) {
                Key key = entry.getKey();
                FileSystem fs = entry.getValue();
                if (!ugi.equals(key.ugi) || fs == null) continue;
                targetFSList.add(fs);
            }
            ArrayList<IOException> exceptions = new ArrayList<IOException>();
            for (FileSystem fs : targetFSList) {
                try {
                    fs.close();
                }
                catch (IOException ioe) {
                    exceptions.add(ioe);
                }
            }
            if (!exceptions.isEmpty()) {
                throw MultipleIOException.createIOException(exceptions);
            }
        }

        static class Key {
            final String scheme;
            final String authority;
            final UserGroupInformation ugi;
            final long unique;

            Key(URI uri, Configuration conf) throws IOException {
                this(uri, conf, 0L);
            }

            Key(URI uri, Configuration conf, long unique) throws IOException {
                this.scheme = uri.getScheme() == null ? "" : uri.getScheme().toLowerCase();
                this.authority = uri.getAuthority() == null ? "" : uri.getAuthority().toLowerCase();
                this.unique = unique;
                this.ugi = UserGroupInformation.getCurrentUser();
            }

            public int hashCode() {
                return (this.scheme + this.authority).hashCode() + this.ugi.hashCode() + (int)this.unique;
            }

            static boolean isEqual(Object a, Object b) {
                return a == b || a != null && a.equals(b);
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj != null && obj instanceof Key) {
                    Key that = (Key)obj;
                    return Key.isEqual(this.scheme, that.scheme) && Key.isEqual(this.authority, that.authority) && Key.isEqual(this.ugi, that.ugi) && this.unique == that.unique;
                }
                return false;
            }

            public String toString() {
                return "(" + this.ugi.toString() + ")@" + this.scheme + "://" + this.authority;
            }
        }

        private class ClientFinalizer
        extends Thread {
            private ClientFinalizer() {
            }

            @Override
            public synchronized void run() {
                try {
                    Cache.this.closeAll(true);
                }
                catch (IOException e) {
                    LOG.info((Object)("FileSystem.Cache.closeAll() threw an exception:\n" + e));
                }
            }
        }
    }
}

