/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.PathExceptions;
import org.apache.hadoop.io.IOUtils;

abstract class CommandWithDestination
extends FsCommand {
    protected PathData dst;
    private boolean overwrite = false;
    private boolean verifyChecksum = true;
    private boolean writeChecksum = true;

    CommandWithDestination() {
    }

    protected void setOverwrite(boolean flag) {
        this.overwrite = flag;
    }

    protected void setVerifyChecksum(boolean flag) {
        this.verifyChecksum = flag;
    }

    protected void setWriteChecksum(boolean flag) {
        this.writeChecksum = flag;
    }

    protected void getLocalDestination(LinkedList<String> args) throws IOException {
        String pathString = args.size() < 2 ? "." : args.removeLast();
        this.dst = new PathData(new File(pathString), this.getConf());
    }

    protected void getRemoteDestination(LinkedList<String> args) throws IOException {
        if (args.size() < 2) {
            this.dst = new PathData(".", this.getConf());
        } else {
            String pathString = args.removeLast();
            PathData[] items = PathData.expandAsGlob(pathString, this.getConf());
            switch (items.length) {
                case 0: {
                    throw new PathExceptions.PathNotFoundException(pathString);
                }
                case 1: {
                    this.dst = items[0];
                    break;
                }
                default: {
                    throw new PathExceptions.PathIOException(pathString, "Too many matches");
                }
            }
        }
    }

    @Override
    protected void processArguments(LinkedList<PathData> args) throws IOException {
        if (args.size() > 1) {
            if (!this.dst.exists) {
                throw new PathExceptions.PathNotFoundException(this.dst.toString());
            }
            if (!this.dst.stat.isDirectory()) {
                throw new PathExceptions.PathIsNotDirectoryException(this.dst.toString());
            }
        } else if (this.dst.exists) {
            if (!this.dst.stat.isDirectory() && !this.overwrite) {
                throw new PathExceptions.PathExistsException(this.dst.toString());
            }
        } else if (!this.dst.parentExists()) {
            throw new PathExceptions.PathNotFoundException(this.dst.toString());
        }
        super.processArguments(args);
    }

    @Override
    protected void processPathArgument(PathData src) throws IOException {
        if (src.stat.isDirectory() && src.fs.equals(this.dst.fs)) {
            PathData target = this.getTargetPath(src);
            String srcPath = src.fs.makeQualified(src.path).toString();
            String dstPath = this.dst.fs.makeQualified(target.path).toString();
            if (dstPath.equals(srcPath)) {
                PathExceptions.PathIOException e = new PathExceptions.PathIOException(src.toString(), "are identical");
                e.setTargetPath(dstPath.toString());
                throw e;
            }
            if (dstPath.startsWith(srcPath + "/")) {
                PathExceptions.PathIOException e = new PathExceptions.PathIOException(src.toString(), "is a subdirectory of itself");
                e.setTargetPath(target.toString());
                throw e;
            }
        }
        super.processPathArgument(src);
    }

    @Override
    protected void processPath(PathData src) throws IOException {
        this.processPath(src, this.getTargetPath(src));
    }

    protected void processPath(PathData src, PathData dst) throws IOException {
        if (src.stat.isSymlink()) {
            throw new PathExceptions.PathOperationException(src.toString());
        }
        if (src.stat.isFile()) {
            this.copyFileToTarget(src, dst);
        } else if (src.stat.isDirectory() && !this.isRecursive()) {
            throw new PathExceptions.PathIsDirectoryException(src.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void recursePath(PathData src) throws IOException {
        PathData savedDst = this.dst;
        try {
            this.dst = this.getTargetPath(src);
            if (this.dst.exists) {
                if (!this.dst.stat.isDirectory()) {
                    throw new PathExceptions.PathIsNotDirectoryException(this.dst.toString());
                }
            } else {
                if (!this.dst.fs.mkdirs(this.dst.path)) {
                    PathExceptions.PathIOException e = new PathExceptions.PathIOException(this.dst.toString());
                    e.setOperation("mkdir");
                    throw e;
                }
                this.dst.refreshStatus();
            }
            super.recursePath(src);
        }
        finally {
            this.dst = savedDst;
        }
    }

    protected PathData getTargetPath(PathData src) throws IOException {
        PathData target = this.getDepth() > 0 || this.dst.exists && this.dst.stat.isDirectory() ? this.dst.getPathDataForChild(src) : (this.dst.representsDirectory() ? this.dst.getPathDataForChild(src) : this.dst);
        return target;
    }

    protected void copyFileToTarget(PathData src, PathData target) throws IOException {
        src.fs.setVerifyChecksum(this.verifyChecksum);
        this.copyStreamToTarget(src.fs.open(src.path), target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyStreamToTarget(InputStream in, PathData target) throws IOException {
        if (target.exists && (target.stat.isDirectory() || !this.overwrite)) {
            throw new PathExceptions.PathExistsException(target.toString());
        }
        target.fs.setWriteChecksum(this.writeChecksum);
        PathData tempFile = null;
        try {
            tempFile = target.createTempFile(target + "._COPYING_");
            FSDataOutputStream out = target.fs.create(tempFile.path, true);
            IOUtils.copyBytes(in, (OutputStream)out, this.getConf(), true);
            if (target.exists && !target.fs.delete(target.path, false)) {
                PathExceptions.PathIOException e = new PathExceptions.PathIOException(target.toString());
                e.setOperation("delete");
                throw e;
            }
            if (!tempFile.fs.rename(tempFile.path, target.path)) {
                PathExceptions.PathIOException e = new PathExceptions.PathIOException(tempFile.toString());
                e.setOperation("rename");
                e.setTargetPath(target.toString());
                throw e;
            }
            tempFile = null;
        }
        finally {
            if (tempFile != null) {
                tempFile.fs.delete(tempFile.path, false);
            }
        }
    }
}

