/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.KerberosInfo;

@KerberosInfo(serverPrincipal="hadoop.security.service.user.name.key")
@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface HAServiceProtocol {
    public static final long versionID = 1L;

    public void monitorHealth() throws HealthCheckFailedException, AccessControlException, IOException;

    public void transitionToActive() throws ServiceFailedException, AccessControlException, IOException;

    public void transitionToStandby() throws ServiceFailedException, AccessControlException, IOException;

    public HAServiceStatus getServiceStatus() throws AccessControlException, IOException;

    public static enum HAServiceState {
        INITIALIZING("initializing"),
        ACTIVE("active"),
        STANDBY("standby");

        private String name;

        private HAServiceState(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

