/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HAServiceProtocolHelper {
    public static void monitorHealth(HAServiceProtocol svc) throws IOException {
        try {
            svc.monitorHealth();
        }
        catch (RemoteException e) {
            throw e.unwrapRemoteException(HealthCheckFailedException.class);
        }
    }

    public static void transitionToActive(HAServiceProtocol svc) throws IOException {
        try {
            svc.transitionToActive();
        }
        catch (RemoteException e) {
            throw e.unwrapRemoteException(ServiceFailedException.class);
        }
    }

    public static void transitionToStandby(HAServiceProtocol svc) throws IOException {
        try {
            svc.transitionToStandby();
        }
        catch (RemoteException e) {
            throw e.unwrapRemoteException(ServiceFailedException.class);
        }
    }
}

