/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.ActiveStandbyElector;
import org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.hadoop.ha.FailoverController;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.HealthMonitor;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.zookeeper.ZooDefs;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
public abstract class ZKFailoverController
implements Tool {
    static final Log LOG = LogFactory.getLog(ZKFailoverController.class);
    public static final String ZK_QUORUM_KEY = "ha.zookeeper.quorum";
    private static final String ZK_SESSION_TIMEOUT_KEY = "ha.zookeeper.session-timeout.ms";
    private static final int ZK_SESSION_TIMEOUT_DEFAULT = 5000;
    private static final String ZK_PARENT_ZNODE_KEY = "ha.zookeeper.parent-znode";
    static final String ZK_PARENT_ZNODE_DEFAULT = "/hadoop-ha";
    static final int ERR_CODE_FORMAT_DENIED = 2;
    static final int ERR_CODE_NO_PARENT_ZNODE = 3;
    static final int ERR_CODE_NO_FENCER = 4;
    private Configuration conf;
    private HealthMonitor healthMonitor;
    private ActiveStandbyElector elector;
    private HAServiceTarget localTarget;
    private String parentZnode;
    private HealthMonitor.State lastHealthState = HealthMonitor.State.INITIALIZING;
    private String fatalError = null;

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
        this.localTarget = this.getLocalTarget();
    }

    protected abstract byte[] targetToData(HAServiceTarget var1);

    protected abstract HAServiceTarget getLocalTarget();

    protected abstract HAServiceTarget dataToTarget(byte[] var1);

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public int run(final String[] args) throws Exception {
        try {
            return SecurityUtil.doAsLoginUserOrFatal(new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    try {
                        return ZKFailoverController.this.doRun(args);
                    }
                    catch (Exception t) {
                        throw new RuntimeException(t);
                    }
                }
            });
        }
        catch (RuntimeException rte) {
            throw (Exception)rte.getCause();
        }
    }

    private int doRun(String[] args) throws HadoopIllegalArgumentException, IOException, InterruptedException {
        this.initZK();
        if (args.length > 0) {
            if ("-formatZK".equals(args[0])) {
                boolean force = false;
                boolean interactive = true;
                for (int i = 1; i < args.length; ++i) {
                    if ("-force".equals(args[i])) {
                        force = true;
                        continue;
                    }
                    if ("-nonInteractive".equals(args[i])) {
                        interactive = false;
                        continue;
                    }
                    this.badArg(args[i]);
                }
                return this.formatZK(force, interactive);
            }
            this.badArg(args[0]);
        }
        if (!this.elector.parentZNodeExists()) {
            LOG.fatal((Object)"Unable to start failover controller. Parent znode does not exist.\nRun with -formatZK flag to initialize ZooKeeper.");
            return 3;
        }
        try {
            this.localTarget.checkFencingConfigured();
        }
        catch (BadFencingConfigurationException e) {
            LOG.fatal((Object)("Fencing is not configured for " + this.localTarget + ".\n" + "You must configure a fencing method before using automatic " + "failover."), (Throwable)e);
            return 4;
        }
        this.initHM();
        this.mainLoop();
        return 0;
    }

    private void badArg(String arg) {
        this.printUsage();
        throw new HadoopIllegalArgumentException("Bad argument: " + arg);
    }

    private void printUsage() {
        System.err.println("Usage: " + this.getClass().getSimpleName() + " [-formatZK [-force | -nonInteractive]]");
    }

    private int formatZK(boolean force, boolean interactive) throws IOException, InterruptedException {
        if (this.elector.parentZNodeExists()) {
            if (!(force || interactive && this.confirmFormat())) {
                return 2;
            }
            try {
                this.elector.clearParentZNode();
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to clear zk parent znode", (Throwable)e);
                return 1;
            }
        }
        this.elector.ensureParentZNode();
        return 0;
    }

    private boolean confirmFormat() {
        System.err.println("===============================================\nThe configured parent znode " + this.parentZnode + " already exists.\n" + "Are you sure you want to clear all failover information from\n" + "ZooKeeper?\n" + "WARNING: Before proceeding, ensure that all HDFS services and\n" + "failover controllers are stopped!\n" + "===============================================");
        try {
            return ToolRunner.confirmPrompt("Proceed formatting " + this.parentZnode + "?");
        }
        catch (IOException e) {
            LOG.debug((Object)"Failed to confirm", (Throwable)e);
            return false;
        }
    }

    private void initHM() {
        this.healthMonitor = new HealthMonitor(this.conf, this.localTarget);
        this.healthMonitor.addCallback(new HealthCallbacks());
        this.healthMonitor.start();
    }

    private void initZK() throws HadoopIllegalArgumentException, IOException {
        String zkQuorum = this.conf.get(ZK_QUORUM_KEY);
        int zkTimeout = this.conf.getInt(ZK_SESSION_TIMEOUT_KEY, 5000);
        this.parentZnode = this.conf.get(ZK_PARENT_ZNODE_KEY, ZK_PARENT_ZNODE_DEFAULT);
        ArrayList zkAcls = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        Preconditions.checkArgument((zkQuorum != null ? 1 : 0) != 0, (String)"Missing required configuration '%s' for ZooKeeper quorum", (Object[])new Object[]{ZK_QUORUM_KEY});
        Preconditions.checkArgument((zkTimeout > 0 ? 1 : 0) != 0, (String)"Invalid ZK session timeout %s", (Object[])new Object[]{zkTimeout});
        this.elector = new ActiveStandbyElector(zkQuorum, zkTimeout, this.parentZnode, zkAcls, new ElectorCallbacks());
    }

    private synchronized void mainLoop() throws InterruptedException {
        while (this.fatalError == null) {
            this.wait();
        }
        assert (this.fatalError != null);
        throw new RuntimeException("ZK Failover Controller failed: " + this.fatalError);
    }

    private synchronized void fatalError(String err) {
        LOG.fatal((Object)("Fatal error occurred:" + err));
        this.fatalError = err;
        this.notifyAll();
    }

    private synchronized void becomeActive() {
        LOG.info((Object)("Trying to make " + this.localTarget + " active..."));
        try {
            this.localTarget.getProxy().transitionToActive();
            LOG.info((Object)("Successfully transitioned " + this.localTarget + " to active state"));
        }
        catch (Throwable t) {
            LOG.fatal((Object)("Couldn't make " + this.localTarget + " active"), t);
            this.elector.quitElection(true);
        }
    }

    private synchronized void becomeStandby() {
        LOG.info((Object)("ZK Election indicated that " + this.localTarget + " should become standby"));
        try {
            this.localTarget.getProxy().transitionToStandby();
            LOG.info((Object)("Successfully transitioned " + this.localTarget + " to standby state"));
        }
        catch (Exception e) {
            LOG.error((Object)("Couldn't transition " + this.localTarget + " to standby state"), (Throwable)e);
        }
    }

    @VisibleForTesting
    HealthMonitor.State getLastHealthState() {
        return this.lastHealthState;
    }

    @VisibleForTesting
    ActiveStandbyElector getElectorForTests() {
        return this.elector;
    }

    class HealthCallbacks
    implements HealthMonitor.Callback {
        HealthCallbacks() {
        }

        @Override
        public void enteredState(HealthMonitor.State newState) {
            LOG.info((Object)("Local service " + ZKFailoverController.this.localTarget + " entered state: " + (Object)((Object)newState)));
            switch (newState) {
                case SERVICE_HEALTHY: {
                    LOG.info((Object)("Joining master election for " + ZKFailoverController.this.localTarget));
                    ZKFailoverController.this.elector.joinElection(ZKFailoverController.this.targetToData(ZKFailoverController.this.localTarget));
                    break;
                }
                case INITIALIZING: {
                    LOG.info((Object)("Ensuring that " + ZKFailoverController.this.localTarget + " does not " + "participate in active master election"));
                    ZKFailoverController.this.elector.quitElection(false);
                    break;
                }
                case SERVICE_UNHEALTHY: 
                case SERVICE_NOT_RESPONDING: {
                    LOG.info((Object)("Quitting master election for " + ZKFailoverController.this.localTarget + " and marking that fencing is necessary"));
                    ZKFailoverController.this.elector.quitElection(true);
                    break;
                }
                case HEALTH_MONITOR_FAILED: {
                    ZKFailoverController.this.fatalError("Health monitor failed!");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled state:" + (Object)((Object)newState));
                }
            }
            ZKFailoverController.this.lastHealthState = newState;
        }
    }

    class ElectorCallbacks
    implements ActiveStandbyElector.ActiveStandbyElectorCallback {
        ElectorCallbacks() {
        }

        @Override
        public void becomeActive() {
            ZKFailoverController.this.becomeActive();
        }

        @Override
        public void becomeStandby() {
            ZKFailoverController.this.becomeStandby();
        }

        @Override
        public void enterNeutralMode() {
        }

        @Override
        public void notifyFatalError(String errorMessage) {
            ZKFailoverController.this.fatalError(errorMessage);
        }

        @Override
        public void fenceOldActive(byte[] data) {
            HAServiceTarget target = ZKFailoverController.this.dataToTarget(data);
            LOG.info((Object)("Should fence: " + target));
            boolean gracefulWorked = FailoverController.tryGracefulFence(ZKFailoverController.this.conf, target);
            if (gracefulWorked) {
                LOG.info((Object)("Successfully transitioned " + target + " to standby " + "state without fencing"));
                return;
            }
            try {
                target.checkFencingConfigured();
            }
            catch (BadFencingConfigurationException e) {
                LOG.error((Object)("Couldn't fence old active " + target), (Throwable)e);
                throw new RuntimeException(e);
            }
            if (!target.getFencer().fence(target)) {
                throw new RuntimeException("Unable to fence " + target);
            }
        }
    }
}

