/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class DNS {
    private static final Log LOG = LogFactory.getLog(DNS.class);
    private static final String cachedHostname = DNS.resolveLocalHostname();
    private static final String cachedHostAddress = DNS.resolveLocalHostIPAddress();
    private static final String LOCALHOST = "localhost";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String reverseDns(InetAddress hostIp, String ns) throws NamingException {
        Attributes attribute;
        String[] parts = hostIp.getHostAddress().split("\\.");
        String reverseIP = parts[3] + "." + parts[2] + "." + parts[1] + "." + parts[0] + ".in-addr.arpa";
        InitialDirContext ictx = new InitialDirContext();
        try {
            attribute = ictx.getAttributes("dns://" + (ns == null ? "" : ns) + "/" + reverseIP, new String[]{"PTR"});
        }
        finally {
            ictx.close();
        }
        return attribute.get("PTR").get().toString();
    }

    private static NetworkInterface getSubinterface(String strInterface) throws SocketException {
        Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
        while (nifs.hasMoreElements()) {
            Enumeration<NetworkInterface> subNifs = nifs.nextElement().getSubInterfaces();
            while (subNifs.hasMoreElements()) {
                NetworkInterface nif = subNifs.nextElement();
                if (!nif.getName().equals(strInterface)) continue;
                return nif;
            }
        }
        return null;
    }

    public static String[] getIPs(String strInterface) throws UnknownHostException {
        NetworkInterface netIf;
        if ("default".equals(strInterface)) {
            return new String[]{cachedHostAddress};
        }
        try {
            netIf = NetworkInterface.getByName(strInterface);
            if (netIf == null) {
                netIf = DNS.getSubinterface(strInterface);
            }
        }
        catch (SocketException e) {
            LOG.warn((Object)("I/O error finding interface " + strInterface + ": " + e.getMessage()));
            return new String[]{cachedHostAddress};
        }
        if (netIf == null) {
            throw new UnknownHostException("No such interface " + strInterface);
        }
        Vector<String> ips = new Vector<String>();
        Enumeration<InetAddress> addrs = netIf.getInetAddresses();
        while (addrs.hasMoreElements()) {
            ips.add(addrs.nextElement().getHostAddress());
        }
        return ips.toArray(new String[0]);
    }

    public static String getDefaultIP(String strInterface) throws UnknownHostException {
        String[] ips = DNS.getIPs(strInterface);
        return ips[0];
    }

    public static String[] getHosts(String strInterface, String nameserver) throws UnknownHostException {
        String[] ips = DNS.getIPs(strInterface);
        Vector<String> hosts = new Vector<String>();
        for (int ctr = 0; ctr < ips.length; ++ctr) {
            try {
                hosts.add(DNS.reverseDns(InetAddress.getByName(ips[ctr]), nameserver));
                continue;
            }
            catch (UnknownHostException ignored) {
                continue;
            }
            catch (NamingException ignored) {
                // empty catch block
            }
        }
        if (hosts.isEmpty()) {
            LOG.warn((Object)("Unable to determine hostname for interface " + strInterface));
            return new String[]{cachedHostname};
        }
        return hosts.toArray(new String[hosts.size()]);
    }

    private static String resolveLocalHostname() {
        String localhost;
        try {
            localhost = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            LOG.warn((Object)"Unable to determine local hostname -falling back to \"localhost\"", (Throwable)e);
            localhost = LOCALHOST;
        }
        return localhost;
    }

    private static String resolveLocalHostIPAddress() {
        String address;
        try {
            address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOG.warn((Object)"Unable to determine address of the host-falling back to \"localhost\" address", (Throwable)e);
            try {
                address = InetAddress.getByName(LOCALHOST).getHostAddress();
            }
            catch (UnknownHostException noLocalHostAddressException) {
                LOG.error((Object)"Unable to determine local loopback address of \"localhost\" -this system's network configuration is unsupported", (Throwable)e);
                address = null;
            }
        }
        return address;
    }

    public static String[] getHosts(String strInterface) throws UnknownHostException {
        return DNS.getHosts(strInterface, null);
    }

    public static String getDefaultHost(String strInterface, String nameserver) throws UnknownHostException {
        if ("default".equals(strInterface)) {
            return cachedHostname;
        }
        if ("default".equals(nameserver)) {
            return DNS.getDefaultHost(strInterface);
        }
        String[] hosts = DNS.getHosts(strInterface, nameserver);
        return hosts[0];
    }

    public static String getDefaultHost(String strInterface) throws UnknownHostException {
        return DNS.getDefaultHost(strInterface, null);
    }
}

