/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.CommandWithDestination;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.PathExceptions;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class CopyCommands {
    CopyCommands() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Merge.class, "-getmerge");
        factory.addClass(Cp.class, "-cp");
        factory.addClass(CopyFromLocal.class, "-copyFromLocal");
        factory.addClass(CopyToLocal.class, "-copyToLocal");
        factory.addClass(Get.class, "-get");
        factory.addClass(Put.class, "-put");
    }

    public static class CopyToLocal
    extends Get {
        public static final String NAME = "copyToLocal";
        public static final String USAGE = "[-ignoreCrc] [-crc] <src> ... <localdst>";
        public static final String DESCRIPTION = "Identical to the -get command.";
    }

    public static class CopyFromLocal
    extends Put {
        public static final String NAME = "copyFromLocal";
        public static final String USAGE = "<localsrc> ... <dst>";
        public static final String DESCRIPTION = "Identical to the -put command.";
    }

    public static class Put
    extends CommandWithDestination {
        public static final String NAME = "put";
        public static final String USAGE = "<localsrc> ... <dst>";
        public static final String DESCRIPTION = "Copy files from the local file system\ninto fs.";

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(null, 1, Integer.MAX_VALUE, new String[0]);
            cf.parse(args);
            this.getRemoteDestination(args);
        }

        @Override
        protected List<PathData> expandArgument(String arg) throws IOException {
            LinkedList<PathData> items = new LinkedList<PathData>();
            items.add(new PathData(new File(arg), this.getConf()));
            return items;
        }

        @Override
        protected void processArguments(LinkedList<PathData> args) throws IOException {
            if (args.size() == 1 && args.get(0).toString().equals("-")) {
                if (this.dst.exists && !this.overwrite) {
                    throw new PathExceptions.PathExistsException(this.dst.toString());
                }
                this.copyFromStdin();
                return;
            }
            super.processArguments(args);
        }

        @Override
        protected void processPath(PathData src, PathData target) throws IOException {
            target.fs.copyFromLocalFile(false, false, src.path, target.path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void copyFromStdin() throws IOException {
            FSDataOutputStream out = this.dst.fs.create(this.dst.path);
            try {
                IOUtils.copyBytes(System.in, (OutputStream)out, this.getConf(), false);
            }
            finally {
                out.close();
            }
        }
    }

    public static class Get
    extends CommandWithDestination {
        public static final String NAME = "get";
        public static final String USAGE = "[-ignoreCrc] [-crc] <src> ... <localdst>";
        public static final String DESCRIPTION = "Copy files that match the file pattern <src>\nto the local name.  <src> is kept.  When copying multiple,\nfiles, the destination must be a directory.";
        private static final String COPYTOLOCAL_PREFIX = "_copyToLocal_";
        private boolean copyCrc;
        private boolean verifyChecksum;
        private LocalFileSystem localFs;

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            this.localFs = FileSystem.getLocal(this.getConf());
            CommandFormat cf = new CommandFormat(null, 1, Integer.MAX_VALUE, "crc", "ignoreCrc");
            cf.parse(args);
            this.copyCrc = cf.getOpt("crc");
            this.verifyChecksum = !cf.getOpt("ignoreCrc");
            this.setRecursive(true);
            this.getLocalDestination(args);
        }

        @Override
        protected void processPath(PathData src, PathData target) throws IOException {
            src.fs.setVerifyChecksum(this.verifyChecksum);
            if (this.copyCrc && !(src.fs instanceof ChecksumFileSystem)) {
                this.displayWarning(src.fs + ": Does not support checksums");
                this.copyCrc = false;
            }
            File targetFile = this.localFs.pathToFile(target.path);
            if (src.stat.isFile()) {
                this.copyFileToLocal(src, target.path);
                if (this.copyCrc) {
                    this.copyCrcToLocal(src, target.path);
                }
            } else if (src.stat.isDirectory()) {
                if (!targetFile.mkdirs()) {
                    throw new PathExceptions.PathIOException(target.toString());
                }
            } else {
                throw new PathExceptions.PathOperationException(src.toString());
            }
        }

        private void copyFileToLocal(PathData src, Path target) throws IOException {
            File targetFile = this.localFs.pathToFile(target);
            File tmpFile = FileUtil.createLocalTempFile(targetFile, COPYTOLOCAL_PREFIX, true);
            if (!FileUtil.copy(src.fs, src.path, tmpFile, false, this.getConf())) {
                PathExceptions.PathIOException e = new PathExceptions.PathIOException(src.toString());
                e.setOperation("copy");
                e.setTargetPath(tmpFile.toString());
                throw e;
            }
            if (!tmpFile.renameTo(targetFile)) {
                PathExceptions.PathIOException e = new PathExceptions.PathIOException(tmpFile.toString());
                e.setOperation("rename");
                e.setTargetPath(targetFile.toString());
                throw e;
            }
        }

        private void copyCrcToLocal(PathData src, Path target) throws IOException {
            ChecksumFileSystem srcFs = (ChecksumFileSystem)src.fs;
            Path srcPath = srcFs.getChecksumFile(src.path);
            src = new PathData(srcFs.getRawFileSystem(), srcPath);
            this.copyFileToLocal(src, this.localFs.getChecksumFile(target));
        }
    }

    static class Cp
    extends CommandWithDestination {
        public static final String NAME = "cp";
        public static final String USAGE = "<src> ... <dst>";
        public static final String DESCRIPTION = "Copy files that match the file pattern <src> to a\ndestination.  When copying multiple files, the destination\nmust be a directory.";

        Cp() {
        }

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(null, 2, Integer.MAX_VALUE, new String[0]);
            cf.parse(args);
            this.getRemoteDestination(args);
        }

        @Override
        protected void processPath(PathData src, PathData target) throws IOException {
            if (!FileUtil.copy(src.fs, src.path, target.fs, target.path, false, this.getConf())) {
                throw new PathExceptions.PathIOException(src.toString());
            }
        }
    }

    public static class Merge
    extends FsCommand {
        public static final String NAME = "getmerge";
        public static final String USAGE = "<src> <localdst> [addnl]";
        public static final String DESCRIPTION = "Get all the files in the directories that\nmatch the source file pattern and merge and sort them to only\none file on local fs. <src> is kept.";
        protected PathData dst = null;
        protected String delimiter = null;

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(null, 2, 3, new String[0]);
            cf.parse(args);
            this.delimiter = args.size() > 2 && Boolean.parseBoolean(args.removeLast()) ? "\n" : null;
            this.dst = new PathData(new File(args.removeLast()), this.getConf());
        }

        @Override
        protected void processPath(PathData src) throws IOException {
            FileUtil.copyMerge(src.fs, src.path, this.dst.fs, this.dst.path, false, this.getConf(), this.delimiter);
        }
    }
}

