/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtocolProxy;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcEngine;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;

@InterfaceStability.Evolving
public class WritableRpcEngine
implements RpcEngine {
    private static final Log LOG = LogFactory.getLog(RPC.class);
    public static long writableRpcVersion = 1L;
    private static ClientCache CLIENTS = new ClientCache();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    static Client getClient(Configuration conf) {
        return WritableRpcEngine.CLIENTS.getClient(conf);
    }

    @Override
    public <T> ProtocolProxy<T> getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout) throws IOException {
        Object proxy = Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)new Invoker(protocol, addr, ticket, conf, factory, rpcTimeout));
        return new ProtocolProxy<Object>(protocol, proxy, true);
    }

    @Override
    public void stopProxy(Object proxy) {
        ((Invoker)Proxy.getInvocationHandler(proxy)).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] call(Method method, Object[][] params, InetSocketAddress[] addrs, UserGroupInformation ticket, Configuration conf) throws IOException, InterruptedException {
        Writable[] invocations = new Invocation[params.length];
        for (int i = 0; i < params.length; ++i) {
            invocations[i] = new Invocation(method, params[i]);
        }
        Client client = WritableRpcEngine.CLIENTS.getClient(conf);
        try {
            Writable[] wrappedValues = client.call(invocations, addrs, method.getDeclaringClass(), ticket, conf);
            if (method.getReturnType() == Void.TYPE) {
                Object[] objectArray = null;
                return objectArray;
            }
            Object[] values = (Object[])Array.newInstance(method.getReturnType(), wrappedValues.length);
            for (int i = 0; i < values.length; ++i) {
                if (wrappedValues[i] == null) continue;
                values[i] = ((ObjectWritable)wrappedValues[i]).get();
            }
            Object[] objectArray = values;
            return objectArray;
        }
        finally {
            WritableRpcEngine.CLIENTS.stopClient(client);
        }
    }

    @Override
    public Server getServer(Class<?> protocol, Object instance, String bindAddress, int port, int numHandlers, boolean verbose, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager) throws IOException {
        return new Server(instance, conf, bindAddress, port, numHandlers, verbose, secretManager);
    }

    private static void log(String value) {
        if (value != null && value.length() > 55) {
            value = value.substring(0, 55) + "...";
        }
        LOG.info((Object)value);
    }

    public static class Server
    extends RPC.Server {
        private Object instance;
        private boolean verbose;

        public Server(Object instance, Configuration conf, String bindAddress, int port) throws IOException {
            this(instance, conf, bindAddress, port, 1, false, null);
        }

        private static String classNameBase(String className) {
            String[] names = className.split("\\.", -1);
            if (names == null || names.length == 0) {
                return className;
            }
            return names[names.length - 1];
        }

        public Server(Object instance, Configuration conf, String bindAddress, int port, int numHandlers, boolean verbose, SecretManager<? extends TokenIdentifier> secretManager) throws IOException {
            super(bindAddress, port, Invocation.class, numHandlers, conf, Server.classNameBase(instance.getClass().getName()), secretManager);
            this.instance = instance;
            this.verbose = verbose;
        }

        @Override
        public Writable call(Class<?> protocol, Writable param, long receivedTime) throws IOException {
            try {
                Invocation call = (Invocation)param;
                if (this.verbose) {
                    WritableRpcEngine.log("Call: " + call);
                }
                Method method = protocol.getMethod(call.getMethodName(), call.getParameterClasses());
                method.setAccessible(true);
                if (call.getRpcVersion() != writableRpcVersion) {
                    throw new IOException("WritableRpc version mismatch, client side version=" + call.getRpcVersion() + ", server side version=" + writableRpcVersion);
                }
                if (!method.getDeclaringClass().equals(VersionedProtocol.class)) {
                    long clientVersion = call.getProtocolVersion();
                    ProtocolSignature serverInfo = ((VersionedProtocol)this.instance).getProtocolSignature(protocol.getCanonicalName(), call.getProtocolVersion(), call.getClientMethodsHash());
                    long serverVersion = serverInfo.getVersion();
                    if (serverVersion != clientVersion) {
                        LOG.warn((Object)("Version mismatch: client version=" + clientVersion + ", server version=" + serverVersion));
                        throw new RPC.VersionMismatch(protocol.getName(), clientVersion, serverVersion);
                    }
                }
                long startTime = System.currentTimeMillis();
                Object value = method.invoke(this.instance, call.getParameters());
                int processingTime = (int)(System.currentTimeMillis() - startTime);
                int qTime = (int)(startTime - receivedTime);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Served: " + call.getMethodName() + " queueTime= " + qTime + " procesingTime= " + processingTime));
                }
                this.rpcMetrics.addRpcQueueTime(qTime);
                this.rpcMetrics.addRpcProcessingTime(processingTime);
                this.rpcDetailedMetrics.addProcessingTime(call.getMethodName(), processingTime);
                if (this.verbose) {
                    WritableRpcEngine.log("Return: " + value);
                }
                return new ObjectWritable(method.getReturnType(), value);
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof IOException) {
                    throw (IOException)target;
                }
                IOException ioe = new IOException(target.toString());
                ioe.setStackTrace(target.getStackTrace());
                throw ioe;
            }
            catch (Throwable e) {
                if (!(e instanceof IOException)) {
                    LOG.error((Object)"Unexpected throwable object ", e);
                }
                IOException ioe = new IOException(e.toString());
                ioe.setStackTrace(e.getStackTrace());
                throw ioe;
            }
        }
    }

    private static class Invoker
    implements InvocationHandler {
        private Client.ConnectionId remoteId;
        private Client client;
        private boolean isClosed = false;

        public Invoker(Class<?> protocol, InetSocketAddress address, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout) throws IOException {
            this.remoteId = Client.ConnectionId.getConnectionId(address, protocol, ticket, rpcTimeout, conf);
            this.client = CLIENTS.getClient(conf, factory);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            long startTime = 0L;
            if (LOG.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
            }
            ObjectWritable value = (ObjectWritable)this.client.call((Writable)new Invocation(method, args), this.remoteId);
            if (LOG.isDebugEnabled()) {
                long callTime = System.currentTimeMillis() - startTime;
                LOG.debug((Object)("Call: " + method.getName() + " " + callTime));
            }
            return value.get();
        }

        private synchronized void close() {
            if (!this.isClosed) {
                this.isClosed = true;
                CLIENTS.stopClient(this.client);
            }
        }
    }

    private static class ClientCache {
        private Map<SocketFactory, Client> clients = new HashMap<SocketFactory, Client>();

        private ClientCache() {
        }

        private synchronized Client getClient(Configuration conf, SocketFactory factory) {
            Client client = this.clients.get(factory);
            if (client == null) {
                client = new Client(ObjectWritable.class, conf, factory);
                this.clients.put(factory, client);
            } else {
                client.incCount();
            }
            return client;
        }

        private synchronized Client getClient(Configuration conf) {
            return this.getClient(conf, SocketFactory.getDefault());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopClient(Client client) {
            ClientCache clientCache = this;
            synchronized (clientCache) {
                client.decCount();
                if (client.isZeroReference()) {
                    this.clients.remove(client.getSocketFactory());
                }
            }
            if (client.isZeroReference()) {
                client.stop();
            }
        }
    }

    private static class Invocation
    implements Writable,
    Configurable {
        private String methodName;
        private Class<?>[] parameterClasses;
        private Object[] parameters;
        private Configuration conf;
        private long clientVersion;
        private int clientMethodsHash;
        private long rpcVersion;

        public Invocation() {
        }

        public Invocation(Method method, Object[] parameters) {
            this.methodName = method.getName();
            this.parameterClasses = method.getParameterTypes();
            this.parameters = parameters;
            this.rpcVersion = writableRpcVersion;
            if (method.getDeclaringClass().equals(VersionedProtocol.class)) {
                this.clientVersion = 0L;
                this.clientMethodsHash = 0;
            } else {
                try {
                    Field versionField = method.getDeclaringClass().getField("versionID");
                    versionField.setAccessible(true);
                    this.clientVersion = versionField.getLong(method.getDeclaringClass());
                }
                catch (NoSuchFieldException ex) {
                    throw new RuntimeException(ex);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
                this.clientMethodsHash = ProtocolSignature.getFingerprint(method.getDeclaringClass().getMethods());
            }
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Class<?>[] getParameterClasses() {
            return this.parameterClasses;
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        private long getProtocolVersion() {
            return this.clientVersion;
        }

        private int getClientMethodsHash() {
            return this.clientMethodsHash;
        }

        public long getRpcVersion() {
            return this.rpcVersion;
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.rpcVersion = in.readLong();
            this.methodName = UTF8.readString(in);
            this.clientVersion = in.readLong();
            this.clientMethodsHash = in.readInt();
            this.parameters = new Object[in.readInt()];
            this.parameterClasses = new Class[this.parameters.length];
            ObjectWritable objectWritable = new ObjectWritable();
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = ObjectWritable.readObject(in, objectWritable, this.conf);
                this.parameterClasses[i] = objectWritable.getDeclaredClass();
            }
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeLong(this.rpcVersion);
            UTF8.writeString(out, this.methodName);
            out.writeLong(this.clientVersion);
            out.writeInt(this.clientMethodsHash);
            out.writeInt(this.parameterClasses.length);
            for (int i = 0; i < this.parameterClasses.length; ++i) {
                ObjectWritable.writeObject(out, this.parameters[i], this.parameterClasses[i], this.conf);
            }
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.methodName);
            buffer.append("(");
            for (int i = 0; i < this.parameters.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.parameters[i]);
            }
            buffer.append(")");
            buffer.append(", rpc version=" + this.rpcVersion);
            buffer.append(", client version=" + this.clientVersion);
            buffer.append(", methodsFingerPrint=" + this.clientMethodsHash);
            return buffer.toString();
        }

        @Override
        public void setConf(Configuration conf) {
            this.conf = conf;
        }

        @Override
        public Configuration getConf() {
            return this.conf;
        }
    }
}

