/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.util.NativeCodeLoader;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class JniBasedUnixGroupsMapping
implements GroupMappingServiceProvider {
    private static final Log LOG = LogFactory.getLog(JniBasedUnixGroupsMapping.class);

    native String[] getGroupForUser(String var1);

    @Override
    public List<String> getGroups(String user) throws IOException {
        String[] groups = new String[]{};
        try {
            groups = this.getGroupForUser(user);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error getting groups for " + user), (Throwable)e);
            }
            LOG.info((Object)("Error getting groups for " + user + ": " + e.getMessage()));
        }
        return Arrays.asList(groups);
    }

    @Override
    public void cacheGroupsRefresh() throws IOException {
    }

    @Override
    public void cacheGroupsAdd(List<String> groups) throws IOException {
    }

    static {
        if (!NativeCodeLoader.isNativeCodeLoaded()) {
            throw new RuntimeException("Bailing out since native library couldn't be loaded");
        }
        LOG.debug((Object)"Using JniBasedUnixGroupsMapping for Group resolution");
    }
}

