/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.local;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DelegateToFileSystem;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.local.LocalConfigKeys;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Shell;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RawLocalFs
extends DelegateToFileSystem {
    RawLocalFs(Configuration conf) throws IOException, URISyntaxException {
        this(FsConstants.LOCAL_FS_URI, conf);
    }

    RawLocalFs(URI theUri, Configuration conf) throws IOException, URISyntaxException {
        super(theUri, new RawLocalFileSystem(), conf, FsConstants.LOCAL_FS_URI.getScheme(), false);
    }

    @Override
    public int getUriDefaultPort() {
        return -1;
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        return LocalConfigKeys.getServerDefaults();
    }

    @Override
    public boolean supportsSymlinks() {
        return true;
    }

    @Override
    public void createSymlink(Path target, Path link, boolean createParent) throws IOException {
        String targetScheme = target.toUri().getScheme();
        if (targetScheme != null && !"file".equals(targetScheme)) {
            throw new IOException("Unable to create symlink to non-local file system: " + target.toString());
        }
        if (createParent) {
            this.mkdir(link.getParent(), FsPermission.getDirDefault(), true);
        }
        try {
            Shell.execCommand(Shell.getSymlinkCommand(RawLocalFs.getPathWithoutSchemeAndAuthority(target).getPath(), RawLocalFs.getPathWithoutSchemeAndAuthority(link).getPath()));
        }
        catch (IOException x) {
            throw new IOException("Unable to create symlink: " + x.getMessage());
        }
    }

    private String readLink(Path p) {
        try {
            String path = p.toUri().getPath();
            return Shell.execCommand("readlink", path).trim();
        }
        catch (IOException x) {
            return "";
        }
    }

    @Override
    public FileStatus getFileLinkStatus(Path f) throws IOException {
        String target = this.readLink(f);
        try {
            FileStatus fs = this.getFileStatus(f);
            if ("".equals(target)) {
                return fs;
            }
            return new FileStatus(fs.getLen(), false, fs.getReplication(), fs.getBlockSize(), fs.getModificationTime(), fs.getAccessTime(), fs.getPermission(), fs.getOwner(), fs.getGroup(), new Path(target), f);
        }
        catch (FileNotFoundException e) {
            if (!"".equals(target)) {
                return new FileStatus(0L, false, 0, 0L, 0L, 0L, FsPermission.getDefault(), "", "", new Path(target), f);
            }
            throw e;
        }
    }

    @Override
    public Path getLinkTarget(Path f) throws IOException {
        throw new AssertionError();
    }

    private static File getPathWithoutSchemeAndAuthority(Path path) {
        Path newPath = path.isUriPathAbsolute() ? new Path(null, null, path.toUri().getPath()) : path;
        return new File(newPath.toString());
    }
}

