/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.util.StringUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Configuration
implements Iterable<Map.Entry<String, String>>,
Writable {
    private static final Log LOG = LogFactory.getLog(Configuration.class);
    private boolean quietmode = true;
    private ArrayList<Resource> resources = new ArrayList();
    static final String UNKNOWN_RESOURCE = "Unknown";
    private Set<String> finalParameters = new HashSet<String>();
    private boolean loadDefaults = true;
    private static final WeakHashMap<Configuration, Object> REGISTRY = new WeakHashMap();
    private static final CopyOnWriteArrayList<String> defaultResources = new CopyOnWriteArrayList();
    private static final Map<ClassLoader, Map<String, WeakReference<Class<?>>>> CACHE_CLASSES = new WeakHashMap();
    private static final Class<?> NEGATIVE_CACHE_SENTINEL = NegativeCacheSentinel.class;
    private HashMap<String, String[]> updatingResource;
    private static Map<String, DeprecatedKeyInfo> deprecatedKeyMap = new HashMap<String, DeprecatedKeyInfo>();
    private static Map<String, String> reverseDeprecatedKeyMap = new HashMap<String, String>();
    private Properties properties;
    private Properties overlay;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private static Pattern varPat;
    private static int MAX_SUBST;

    @Deprecated
    public static synchronized void addDeprecation(String key, String[] newKeys, String customMessage) {
        if (key == null || key.length() == 0 || newKeys == null || newKeys.length == 0) {
            throw new IllegalArgumentException();
        }
        if (!Configuration.isDeprecated(key)) {
            DeprecatedKeyInfo newKeyInfo = new DeprecatedKeyInfo(newKeys, customMessage);
            deprecatedKeyMap.put(key, newKeyInfo);
            for (String newKey : newKeys) {
                reverseDeprecatedKeyMap.put(newKey, key);
            }
        }
    }

    public static synchronized void addDeprecation(String key, String newKey, String customMessage) {
        Configuration.addDeprecation(key, new String[]{newKey}, customMessage);
    }

    @Deprecated
    public static synchronized void addDeprecation(String key, String[] newKeys) {
        Configuration.addDeprecation(key, newKeys, null);
    }

    public static synchronized void addDeprecation(String key, String newKey) {
        Configuration.addDeprecation(key, new String[]{newKey}, null);
    }

    public static boolean isDeprecated(String key) {
        return deprecatedKeyMap.containsKey(key);
    }

    private String[] getAlternateNames(String name) {
        String[] altNames = null;
        DeprecatedKeyInfo keyInfo = deprecatedKeyMap.get(name);
        if (keyInfo == null) {
            String[] stringArray;
            if (reverseDeprecatedKeyMap.get(name) != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = reverseDeprecatedKeyMap.get(name);
            } else {
                stringArray = altNames = null;
            }
            if (altNames != null && altNames.length > 0) {
                keyInfo = deprecatedKeyMap.get(altNames[0]);
            }
        }
        if (keyInfo != null && keyInfo.newKeys.length > 0) {
            ArrayList<String> list = new ArrayList<String>();
            if (altNames != null) {
                list.addAll(Arrays.asList(altNames));
            }
            list.addAll(Arrays.asList(keyInfo.newKeys));
            altNames = list.toArray(new String[list.size()]);
        }
        return altNames;
    }

    private String[] handleDeprecation(String name) {
        ArrayList<String> names = new ArrayList<String>();
        if (Configuration.isDeprecated(name)) {
            DeprecatedKeyInfo keyInfo = deprecatedKeyMap.get(name);
            this.warnOnceIfDeprecated(name);
            for (String newKey : keyInfo.newKeys) {
                if (newKey == null) continue;
                names.add(newKey);
            }
        }
        if (names.size() == 0) {
            names.add(name);
        }
        for (String n : names) {
            String deprecatedKey = reverseDeprecatedKeyMap.get(n);
            if (deprecatedKey == null || this.getOverlay().containsKey(n) || !this.getOverlay().containsKey(deprecatedKey)) continue;
            this.getProps().setProperty(n, this.getOverlay().getProperty(deprecatedKey));
            this.getOverlay().setProperty(n, this.getOverlay().getProperty(deprecatedKey));
        }
        return names.toArray(new String[names.size()]);
    }

    private void handleDeprecation() {
        LOG.debug((Object)"Handling deprecation for all properties in config...");
        HashSet<Object> keys = new HashSet<Object>();
        keys.addAll(this.getProps().keySet());
        for (Object e : keys) {
            LOG.debug((Object)("Handling deprecation for " + (String)e));
            this.handleDeprecation((String)e);
        }
    }

    public Configuration() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration(boolean loadDefaults) {
        if (this.classLoader == null) {
            this.classLoader = Configuration.class.getClassLoader();
        }
        this.loadDefaults = loadDefaults;
        this.updatingResource = new HashMap();
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            REGISTRY.put(this, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration(Configuration other) {
        if (this.classLoader == null) {
            this.classLoader = Configuration.class.getClassLoader();
        }
        this.resources = (ArrayList)other.resources.clone();
        Object object = other;
        synchronized (object) {
            if (other.properties != null) {
                this.properties = (Properties)other.properties.clone();
            }
            if (other.overlay != null) {
                this.overlay = (Properties)other.overlay.clone();
            }
            this.updatingResource = new HashMap<String, String[]>(other.updatingResource);
        }
        this.finalParameters = new HashSet<String>(other.finalParameters);
        object = Configuration.class;
        synchronized (Configuration.class) {
            REGISTRY.put(this, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.classLoader = other.classLoader;
            this.loadDefaults = other.loadDefaults;
            this.setQuietMode(other.getQuietMode());
            return;
        }
    }

    public static synchronized void addDefaultResource(String name) {
        if (!defaultResources.contains(name)) {
            defaultResources.add(name);
            for (Configuration conf : REGISTRY.keySet()) {
                if (!conf.loadDefaults) continue;
                conf.reloadConfiguration();
            }
        }
    }

    public void addResource(String name) {
        this.addResourceObject(new Resource(name));
    }

    public void addResource(URL url) {
        this.addResourceObject(new Resource(url));
    }

    public void addResource(Path file) {
        this.addResourceObject(new Resource(file));
    }

    public void addResource(InputStream in) {
        this.addResourceObject(new Resource(in));
    }

    public void addResource(InputStream in, String name) {
        this.addResourceObject(new Resource(in, name));
    }

    public synchronized void reloadConfiguration() {
        this.properties = null;
        this.finalParameters.clear();
    }

    private synchronized void addResourceObject(Resource resource) {
        this.resources.add(resource);
        this.reloadConfiguration();
    }

    private String substituteVars(String expr) {
        if (expr == null) {
            return null;
        }
        Matcher match = varPat.matcher("");
        String eval = expr;
        for (int s = 0; s < MAX_SUBST; ++s) {
            match.reset(eval);
            if (!match.find()) {
                return eval;
            }
            String var = match.group();
            var = var.substring(2, var.length() - 1);
            String val = null;
            try {
                val = System.getProperty(var);
            }
            catch (SecurityException se) {
                LOG.warn((Object)"Unexpected SecurityException in Configuration", (Throwable)se);
            }
            if (val == null) {
                val = this.getRaw(var);
            }
            if (val == null) {
                return eval;
            }
            eval = eval.substring(0, match.start()) + val + eval.substring(match.end());
        }
        throw new IllegalStateException("Variable substitution depth too large: " + MAX_SUBST + " " + expr);
    }

    public String get(String name) {
        String[] names = this.handleDeprecation(name);
        String result = null;
        for (String n : names) {
            result = this.substituteVars(this.getProps().getProperty(n));
        }
        return result;
    }

    public String getTrimmed(String name) {
        String value = this.get(name);
        if (null == value) {
            return null;
        }
        return value.trim();
    }

    public String getTrimmed(String name, String defaultValue) {
        String ret = this.getTrimmed(name);
        return ret == null ? defaultValue : ret;
    }

    public String getRaw(String name) {
        String[] names = this.handleDeprecation(name);
        String result = null;
        for (String n : names) {
            result = this.getProps().getProperty(n);
        }
        return result;
    }

    public void set(String name, String value) {
        this.set(name, value, null);
    }

    public void set(String name, String value, String source) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Property name must not be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Property value must not be null");
        if (deprecatedKeyMap.isEmpty()) {
            this.getProps();
        }
        this.getOverlay().setProperty(name, value);
        this.getProps().setProperty(name, value);
        if (source == null) {
            this.updatingResource.put(name, new String[]{"programatically"});
        } else {
            this.updatingResource.put(name, new String[]{source});
        }
        String[] altNames = this.getAlternateNames(name);
        if (altNames != null && altNames.length > 0) {
            String altSource = "because " + name + " is deprecated";
            for (String altName : altNames) {
                if (altName.equals(name)) continue;
                this.getOverlay().setProperty(altName, value);
                this.getProps().setProperty(altName, value);
                this.updatingResource.put(altName, new String[]{altSource});
            }
        }
        this.warnOnceIfDeprecated(name);
    }

    private void warnOnceIfDeprecated(String name) {
        DeprecatedKeyInfo keyInfo = deprecatedKeyMap.get(name);
        if (keyInfo != null && !keyInfo.accessed) {
            LOG.warn((Object)keyInfo.getWarningMessage(name));
        }
    }

    public synchronized void unset(String name) {
        String[] altNames = this.getAlternateNames(name);
        this.getOverlay().remove(name);
        this.getProps().remove(name);
        if (altNames != null && altNames.length > 0) {
            for (String altName : altNames) {
                this.getOverlay().remove(altName);
                this.getProps().remove(altName);
            }
        }
    }

    public synchronized void setIfUnset(String name, String value) {
        if (this.get(name) == null) {
            this.set(name, value);
        }
    }

    private synchronized Properties getOverlay() {
        if (this.overlay == null) {
            this.overlay = new Properties();
        }
        return this.overlay;
    }

    public String get(String name, String defaultValue) {
        String[] names = this.handleDeprecation(name);
        String result = null;
        for (String n : names) {
            result = this.substituteVars(this.getProps().getProperty(n, defaultValue));
        }
        return result;
    }

    public int getInt(String name, int defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        String hexString = this.getHexDigits(valueString);
        if (hexString != null) {
            return Integer.parseInt(hexString, 16);
        }
        return Integer.parseInt(valueString);
    }

    public int[] getInts(String name) {
        String[] strings = this.getTrimmedStrings(name);
        int[] ints = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            ints[i] = Integer.parseInt(strings[i]);
        }
        return ints;
    }

    public void setInt(String name, int value) {
        this.set(name, Integer.toString(value));
    }

    public long getLong(String name, long defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        String hexString = this.getHexDigits(valueString);
        if (hexString != null) {
            return Long.parseLong(hexString, 16);
        }
        return Long.parseLong(valueString);
    }

    public long getLongBytes(String name, long defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        return StringUtils.TraditionalBinaryPrefix.string2long(valueString);
    }

    private String getHexDigits(String value) {
        boolean negative = false;
        String str = value;
        String hexString = null;
        if (value.startsWith("-")) {
            negative = true;
            str = value.substring(1);
        }
        if (str.startsWith("0x") || str.startsWith("0X")) {
            hexString = str.substring(2);
            if (negative) {
                hexString = "-" + hexString;
            }
            return hexString;
        }
        return null;
    }

    public void setLong(String name, long value) {
        this.set(name, Long.toString(value));
    }

    public float getFloat(String name, float defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        return Float.parseFloat(valueString);
    }

    public void setFloat(String name, float value) {
        this.set(name, Float.toString(value));
    }

    public double getDouble(String name, double defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        return Double.parseDouble(valueString);
    }

    public void setDouble(String name, double value) {
        this.set(name, Double.toString(value));
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String valueString = this.getTrimmed(name);
        if (null == valueString || "".equals(valueString)) {
            return defaultValue;
        }
        if ("true".equals(valueString = valueString.toLowerCase())) {
            return true;
        }
        if ("false".equals(valueString)) {
            return false;
        }
        return defaultValue;
    }

    public void setBoolean(String name, boolean value) {
        this.set(name, Boolean.toString(value));
    }

    public void setBooleanIfUnset(String name, boolean value) {
        this.setIfUnset(name, Boolean.toString(value));
    }

    public <T extends Enum<T>> void setEnum(String name, T value) {
        this.set(name, value.toString());
    }

    public <T extends Enum<T>> T getEnum(String name, T defaultValue) {
        String val = this.get(name);
        return null == val ? defaultValue : Enum.valueOf(defaultValue.getDeclaringClass(), val);
    }

    public void setTimeDuration(String name, long value, TimeUnit unit) {
        this.set(name, value + ParsedTimeDuration.unitFor(unit).suffix());
    }

    public long getTimeDuration(String name, long defaultValue, TimeUnit unit) {
        String vStr = this.get(name);
        if (null == vStr) {
            return defaultValue;
        }
        ParsedTimeDuration vUnit = ParsedTimeDuration.unitFor(vStr = vStr.trim());
        if (null == vUnit) {
            LOG.warn((Object)("No unit for " + name + "(" + vStr + ") assuming " + (Object)((Object)unit)));
            vUnit = ParsedTimeDuration.unitFor(unit);
        } else {
            vStr = vStr.substring(0, vStr.lastIndexOf(vUnit.suffix()));
        }
        return unit.convert(Long.parseLong(vStr), vUnit.unit());
    }

    public Pattern getPattern(String name, Pattern defaultValue) {
        String valString = this.get(name);
        if (null == valString || "".equals(valString)) {
            return defaultValue;
        }
        try {
            return Pattern.compile(valString);
        }
        catch (PatternSyntaxException pse) {
            LOG.warn((Object)("Regular expression '" + valString + "' for property '" + name + "' not valid. Using default"), (Throwable)pse);
            return defaultValue;
        }
    }

    public void setPattern(String name, Pattern pattern) {
        if (null == pattern) {
            this.set(name, null);
        } else {
            this.set(name, pattern.pattern());
        }
    }

    @InterfaceStability.Unstable
    public synchronized String[] getPropertySources(String name) {
        if (this.properties == null) {
            this.getProps();
        }
        if (this.properties == null || this.updatingResource == null) {
            return null;
        }
        String[] source = this.updatingResource.get(name);
        if (source == null) {
            return null;
        }
        return Arrays.copyOf(source, source.length);
    }

    public IntegerRanges getRange(String name, String defaultValue) {
        return new IntegerRanges(this.get(name, defaultValue));
    }

    public Collection<String> getStringCollection(String name) {
        String valueString = this.get(name);
        return StringUtils.getStringCollection(valueString);
    }

    public String[] getStrings(String name) {
        String valueString = this.get(name);
        return StringUtils.getStrings(valueString);
    }

    public String[] getStrings(String name, String ... defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        return StringUtils.getStrings(valueString);
    }

    public Collection<String> getTrimmedStringCollection(String name) {
        String valueString = this.get(name);
        if (null == valueString) {
            ArrayList<String> empty = new ArrayList<String>();
            return empty;
        }
        return StringUtils.getTrimmedStringCollection(valueString);
    }

    public String[] getTrimmedStrings(String name) {
        String valueString = this.get(name);
        return StringUtils.getTrimmedStrings(valueString);
    }

    public String[] getTrimmedStrings(String name, String ... defaultValue) {
        String valueString = this.get(name);
        if (null == valueString) {
            return defaultValue;
        }
        return StringUtils.getTrimmedStrings(valueString);
    }

    public void setStrings(String name, String ... values) {
        this.set(name, StringUtils.arrayToString(values));
    }

    public InetSocketAddress getSocketAddr(String name, String defaultAddress, int defaultPort) {
        String address = this.get(name, defaultAddress);
        return NetUtils.createSocketAddr(address, defaultPort, name);
    }

    public void setSocketAddr(String name, InetSocketAddress addr) {
        this.set(name, NetUtils.getHostPortString(addr));
    }

    public InetSocketAddress updateConnectAddr(String name, InetSocketAddress addr) {
        InetSocketAddress connectAddr = NetUtils.getConnectAddress(addr);
        this.setSocketAddr(name, connectAddr);
        return connectAddr;
    }

    public Class<?> getClassByName(String name) throws ClassNotFoundException {
        Class<?> ret = this.getClassByNameOrNull(name);
        if (ret == null) {
            throw new ClassNotFoundException("Class " + name + " not found");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getClassByNameOrNull(String name) {
        Map<String, WeakReference<Class<Object>>> map;
        Map<ClassLoader, Map<String, WeakReference<Class<?>>>> map2 = CACHE_CLASSES;
        synchronized (map2) {
            map = CACHE_CLASSES.get(this.classLoader);
            if (map == null) {
                map = Collections.synchronizedMap(new WeakHashMap());
                CACHE_CLASSES.put(this.classLoader, map);
            }
        }
        Class<?> clazz = null;
        WeakReference<Class<Object>> ref = map.get(name);
        if (ref != null) {
            clazz = (Class<?>)ref.get();
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(name, true, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                map.put(name, new WeakReference(NEGATIVE_CACHE_SENTINEL));
                return null;
            }
            map.put(name, new WeakReference(clazz));
            return clazz;
        }
        if (clazz == NEGATIVE_CACHE_SENTINEL) {
            return null;
        }
        return clazz;
    }

    public Class<?>[] getClasses(String name, Class<?> ... defaultValue) {
        String[] classnames = this.getTrimmedStrings(name);
        if (classnames == null) {
            return defaultValue;
        }
        try {
            Class[] classes = new Class[classnames.length];
            for (int i = 0; i < classnames.length; ++i) {
                classes[i] = this.getClassByName(classnames[i]);
            }
            return classes;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getClass(String name, Class<?> defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return this.getClassByName(valueString);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public <U> Class<? extends U> getClass(String name, Class<? extends U> defaultValue, Class<U> xface) {
        try {
            Class<?> theClass = this.getClass(name, defaultValue);
            if (theClass != null && !xface.isAssignableFrom(theClass)) {
                throw new RuntimeException(theClass + " not " + xface.getName());
            }
            if (theClass != null) {
                return theClass.asSubclass(xface);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <U> List<U> getInstances(String name, Class<U> xface) {
        Class<?>[] classes;
        ArrayList ret = new ArrayList();
        for (Class<?> cl : classes = this.getClasses(name, new Class[0])) {
            if (!xface.isAssignableFrom(cl)) {
                throw new RuntimeException(cl + " does not implement " + xface);
            }
            ret.add(ReflectionUtils.newInstance(cl, this));
        }
        return ret;
    }

    public void setClass(String name, Class<?> theClass, Class<?> xface) {
        if (!xface.isAssignableFrom(theClass)) {
            throw new RuntimeException(theClass + " not " + xface.getName());
        }
        this.set(name, theClass.getName());
    }

    public Path getLocalPath(String dirsProp, String path) throws IOException {
        int index;
        int i;
        String[] dirs = this.getTrimmedStrings(dirsProp);
        int hashCode = path.hashCode();
        LocalFileSystem fs = FileSystem.getLocal(this);
        for (i = 0; i < dirs.length; ++i) {
            index = (hashCode + i & Integer.MAX_VALUE) % dirs.length;
            Path file = new Path(dirs[index], path);
            Path dir = file.getParent();
            if (!((FileSystem)fs).mkdirs(dir) && !fs.exists(dir)) continue;
            return file;
        }
        LOG.warn((Object)("Could not make " + path + " in local directories from " + dirsProp));
        for (i = 0; i < dirs.length; ++i) {
            index = (hashCode + i & Integer.MAX_VALUE) % dirs.length;
            LOG.warn((Object)(dirsProp + "[" + index + "]=" + dirs[index]));
        }
        throw new IOException("No valid local directories in property: " + dirsProp);
    }

    public File getFile(String dirsProp, String path) throws IOException {
        String[] dirs = this.getTrimmedStrings(dirsProp);
        int hashCode = path.hashCode();
        for (int i = 0; i < dirs.length; ++i) {
            int index = (hashCode + i & Integer.MAX_VALUE) % dirs.length;
            File file = new File(dirs[index], path);
            File dir = file.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) continue;
            return file;
        }
        throw new IOException("No valid local directories in property: " + dirsProp);
    }

    public URL getResource(String name) {
        return this.classLoader.getResource(name);
    }

    public InputStream getConfResourceAsInputStream(String name) {
        try {
            URL url = this.getResource(name);
            if (url == null) {
                LOG.info((Object)(name + " not found"));
                return null;
            }
            LOG.info((Object)("found resource " + name + " at " + url));
            return url.openStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Reader getConfResourceAsReader(String name) {
        try {
            URL url = this.getResource(name);
            if (url == null) {
                LOG.info((Object)(name + " not found"));
                return null;
            }
            LOG.info((Object)("found resource " + name + " at " + url));
            return new InputStreamReader(url.openStream());
        }
        catch (Exception e) {
            return null;
        }
    }

    protected synchronized Properties getProps() {
        if (this.properties == null) {
            this.properties = new Properties();
            HashMap<String, String[]> backup = new HashMap<String, String[]>(this.updatingResource);
            this.loadResources(this.properties, this.resources, this.quietmode);
            if (this.overlay != null) {
                this.properties.putAll((Map<?, ?>)this.overlay);
                for (Map.Entry<Object, Object> item : this.overlay.entrySet()) {
                    String key = (String)item.getKey();
                    this.updatingResource.put(key, backup.get(key));
                }
            }
        }
        return this.properties;
    }

    public int size() {
        return this.getProps().size();
    }

    public void clear() {
        this.getProps().clear();
        this.getOverlay().clear();
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> item : this.getProps().entrySet()) {
            if (!(item.getKey() instanceof String) || !(item.getValue() instanceof String)) continue;
            result.put((String)item.getKey(), (String)item.getValue());
        }
        return result.entrySet().iterator();
    }

    private Document parse(DocumentBuilder builder, URL url) throws IOException, SAXException {
        if (!this.quietmode) {
            LOG.info((Object)("parsing URL " + url));
        }
        if (url == null) {
            return null;
        }
        return this.parse(builder, url.openStream(), url.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document parse(DocumentBuilder builder, InputStream is, String systemId) throws IOException, SAXException {
        if (!this.quietmode) {
            LOG.info((Object)("parsing input stream " + is));
        }
        if (is == null) {
            return null;
        }
        try {
            Document document = systemId == null ? builder.parse(is) : builder.parse(is, systemId);
            return document;
        }
        finally {
            is.close();
        }
    }

    private void loadResources(Properties properties, ArrayList<Resource> resources, boolean quiet) {
        if (this.loadDefaults) {
            for (String resource : defaultResources) {
                this.loadResource(properties, new Resource(resource), quiet);
            }
            if (this.getResource("hadoop-site.xml") != null) {
                this.loadResource(properties, new Resource("hadoop-site.xml"), quiet);
            }
        }
        for (int i = 0; i < resources.size(); ++i) {
            Resource ret = this.loadResource(properties, resources.get(i), quiet);
            if (ret == null) continue;
            resources.set(i, ret);
        }
    }

    private Resource loadResource(Properties properties, Resource wrapper, boolean quiet) {
        String name = UNKNOWN_RESOURCE;
        try {
            Object resource = wrapper.getResource();
            name = wrapper.getName();
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setIgnoringComments(true);
            docBuilderFactory.setNamespaceAware(true);
            try {
                docBuilderFactory.setXIncludeAware(true);
            }
            catch (UnsupportedOperationException e) {
                LOG.error((Object)("Failed to set setXIncludeAware(true) for parser " + docBuilderFactory + ":" + e), (Throwable)e);
            }
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            Document doc = null;
            Element root = null;
            boolean returnCachedProperties = false;
            if (resource instanceof URL) {
                doc = this.parse(builder, (URL)resource);
            } else if (resource instanceof String) {
                URL url = this.getResource((String)resource);
                doc = this.parse(builder, url);
            } else if (resource instanceof Path) {
                File file = new File(((Path)resource).toUri().getPath()).getAbsoluteFile();
                if (file.exists()) {
                    if (!quiet) {
                        LOG.info((Object)("parsing File " + file));
                    }
                    doc = this.parse(builder, new BufferedInputStream(new FileInputStream(file)), ((Path)resource).toString());
                }
            } else if (resource instanceof InputStream) {
                doc = this.parse(builder, (InputStream)resource, null);
                returnCachedProperties = true;
            } else if (resource instanceof Properties) {
                this.overlay(properties, (Properties)resource);
            } else if (resource instanceof Element) {
                root = (Element)resource;
            }
            if (doc == null && root == null) {
                if (quiet) {
                    return null;
                }
                throw new RuntimeException(resource + " not found");
            }
            if (root == null) {
                root = doc.getDocumentElement();
            }
            Properties toAddTo = properties;
            if (returnCachedProperties) {
                toAddTo = new Properties();
            }
            if (!"configuration".equals(root.getTagName())) {
                LOG.fatal((Object)"bad conf file: top-level element not <configuration>");
            }
            NodeList props = root.getChildNodes();
            for (int i = 0; i < props.getLength(); ++i) {
                Node propNode = props.item(i);
                if (!(propNode instanceof Element)) continue;
                Element prop = (Element)propNode;
                if ("configuration".equals(prop.getTagName())) {
                    this.loadResource(toAddTo, new Resource(prop, name), quiet);
                    continue;
                }
                if (!"property".equals(prop.getTagName())) {
                    LOG.warn((Object)"bad conf file: element not <property>");
                }
                NodeList fields = prop.getChildNodes();
                String attr = null;
                String value = null;
                boolean finalParameter = false;
                LinkedList<String> source = new LinkedList<String>();
                for (int j = 0; j < fields.getLength(); ++j) {
                    Node fieldNode = fields.item(j);
                    if (!(fieldNode instanceof Element)) continue;
                    Element field = (Element)fieldNode;
                    if ("name".equals(field.getTagName()) && field.hasChildNodes()) {
                        attr = StringInterner.weakIntern(((Text)field.getFirstChild()).getData().trim());
                    }
                    if ("value".equals(field.getTagName()) && field.hasChildNodes()) {
                        value = StringInterner.weakIntern(((Text)field.getFirstChild()).getData());
                    }
                    if ("final".equals(field.getTagName()) && field.hasChildNodes()) {
                        finalParameter = "true".equals(((Text)field.getFirstChild()).getData());
                    }
                    if (!"source".equals(field.getTagName()) || !field.hasChildNodes()) continue;
                    source.add(StringInterner.weakIntern(((Text)field.getFirstChild()).getData()));
                }
                source.add(name);
                if (attr == null) continue;
                if (deprecatedKeyMap.containsKey(attr)) {
                    DeprecatedKeyInfo keyInfo = deprecatedKeyMap.get(attr);
                    keyInfo.accessed = false;
                    for (String key : keyInfo.newKeys) {
                        this.loadProperty(toAddTo, name, key, value, finalParameter, source.toArray(new String[source.size()]));
                    }
                    continue;
                }
                this.loadProperty(toAddTo, name, attr, value, finalParameter, source.toArray(new String[source.size()]));
            }
            if (returnCachedProperties) {
                this.overlay(properties, toAddTo);
                return new Resource(toAddTo, name);
            }
            return null;
        }
        catch (IOException e) {
            LOG.fatal((Object)("error parsing conf " + name), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (DOMException e) {
            LOG.fatal((Object)("error parsing conf " + name), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            LOG.fatal((Object)("error parsing conf " + name), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            LOG.fatal((Object)("error parsing conf " + name), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void overlay(Properties to, Properties from) {
        for (Map.Entry<Object, Object> entry : from.entrySet()) {
            to.put(entry.getKey(), entry.getValue());
        }
    }

    private void loadProperty(Properties properties, String name, String attr, String value, boolean finalParameter, String[] source) {
        if (value != null) {
            if (!this.finalParameters.contains(attr)) {
                properties.setProperty(attr, value);
                this.updatingResource.put(attr, source);
            } else {
                LOG.warn((Object)(name + ":an attempt to override final parameter: " + attr + ";  Ignoring."));
            }
        }
        if (finalParameter) {
            this.finalParameters.add(attr);
        }
    }

    public void writeXml(OutputStream out) throws IOException {
        this.writeXml(new OutputStreamWriter(out));
    }

    public void writeXml(Writer out) throws IOException {
        Document doc = this.asXmlDocument();
        try {
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (TransformerException te) {
            throw new IOException(te);
        }
    }

    private synchronized Document asXmlDocument() throws IOException {
        Document doc;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException pe) {
            throw new IOException(pe);
        }
        Element conf = doc.createElement("configuration");
        doc.appendChild(conf);
        conf.appendChild(doc.createTextNode("\n"));
        this.handleDeprecation();
        Enumeration<Object> e = this.properties.keys();
        while (e.hasMoreElements()) {
            String[] sources;
            String name = (String)e.nextElement();
            Object object = this.properties.get(name);
            String value = null;
            if (!(object instanceof String)) continue;
            value = (String)object;
            Element propNode = doc.createElement("property");
            conf.appendChild(propNode);
            Element nameNode = doc.createElement("name");
            nameNode.appendChild(doc.createTextNode(name));
            propNode.appendChild(nameNode);
            Element valueNode = doc.createElement("value");
            valueNode.appendChild(doc.createTextNode(value));
            propNode.appendChild(valueNode);
            if (this.updatingResource != null && (sources = this.updatingResource.get(name)) != null) {
                for (String s : sources) {
                    Element sourceNode = doc.createElement("source");
                    sourceNode.appendChild(doc.createTextNode(s));
                    propNode.appendChild(sourceNode);
                }
            }
            conf.appendChild(doc.createTextNode("\n"));
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpConfiguration(Configuration config, Writer out) throws IOException {
        JsonFactory dumpFactory = new JsonFactory();
        JsonGenerator dumpGenerator = dumpFactory.createJsonGenerator(out);
        dumpGenerator.writeStartObject();
        dumpGenerator.writeFieldName("properties");
        dumpGenerator.writeStartArray();
        dumpGenerator.flush();
        Configuration configuration = config;
        synchronized (configuration) {
            for (Map.Entry<Object, Object> item : config.getProps().entrySet()) {
                dumpGenerator.writeStartObject();
                dumpGenerator.writeStringField("key", (String)item.getKey());
                dumpGenerator.writeStringField("value", config.get((String)item.getKey()));
                dumpGenerator.writeBooleanField("isFinal", config.finalParameters.contains(item.getKey()));
                String[] resources = config.updatingResource.get(item.getKey());
                String resource = UNKNOWN_RESOURCE;
                if (resources != null && resources.length > 0) {
                    resource = resources[0];
                }
                dumpGenerator.writeStringField("resource", resource);
                dumpGenerator.writeEndObject();
            }
        }
        dumpGenerator.writeEndArray();
        dumpGenerator.writeEndObject();
        dumpGenerator.flush();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Configuration: ");
        if (this.loadDefaults) {
            this.toString(defaultResources, sb);
            if (this.resources.size() > 0) {
                sb.append(", ");
            }
        }
        this.toString(this.resources, sb);
        return sb.toString();
    }

    private <T> void toString(List<T> resources, StringBuilder sb) {
        ListIterator<T> i = resources.listIterator();
        while (i.hasNext()) {
            if (i.nextIndex() != 0) {
                sb.append(", ");
            }
            sb.append(i.next());
        }
    }

    public synchronized void setQuietMode(boolean quietmode) {
        this.quietmode = quietmode;
    }

    synchronized boolean getQuietMode() {
        return this.quietmode;
    }

    public static void main(String[] args) throws Exception {
        new Configuration().writeXml(System.out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.clear();
        int size = WritableUtils.readVInt(in);
        for (int i = 0; i < size; ++i) {
            String key = org.apache.hadoop.io.Text.readString(in);
            String value = org.apache.hadoop.io.Text.readString(in);
            this.set(key, value);
            String[] sources = WritableUtils.readCompressedStringArray(in);
            this.updatingResource.put(key, sources);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Properties props = this.getProps();
        WritableUtils.writeVInt(out, props.size());
        for (Map.Entry<Object, Object> item : props.entrySet()) {
            org.apache.hadoop.io.Text.writeString(out, (String)item.getKey());
            org.apache.hadoop.io.Text.writeString(out, (String)item.getValue());
            WritableUtils.writeCompressedStringArray(out, this.updatingResource.get(item.getKey()));
        }
    }

    public Map<String, String> getValByRegex(String regex) {
        Pattern p = Pattern.compile(regex);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> item : this.getProps().entrySet()) {
            Matcher m;
            if (!(item.getKey() instanceof String) || !(item.getValue() instanceof String) || !(m = p.matcher((String)item.getKey())).find()) continue;
            result.put((String)item.getKey(), (String)item.getValue());
        }
        return result;
    }

    private static void addDeprecatedKeys() {
        Configuration.addDeprecation("topology.script.file.name", new String[]{"net.topology.script.file.name"});
        Configuration.addDeprecation("topology.script.number.args", new String[]{"net.topology.script.number.args"});
        Configuration.addDeprecation("hadoop.configured.node.mapping", new String[]{"net.topology.configured.node.mapping"});
        Configuration.addDeprecation("topology.node.switch.mapping.impl", new String[]{"net.topology.node.switch.mapping.impl"});
        Configuration.addDeprecation("dfs.df.interval", new String[]{"fs.df.interval"});
        Configuration.addDeprecation("hadoop.native.lib", new String[]{"io.native.lib.available"});
        Configuration.addDeprecation("fs.default.name", new String[]{"fs.defaultFS"});
        Configuration.addDeprecation("dfs.umaskmode", new String[]{"fs.permissions.umask-mode"});
    }

    public static void dumpDeprecatedKeys() {
        for (Map.Entry<String, DeprecatedKeyInfo> entry : deprecatedKeyMap.entrySet()) {
            String newKeys = "";
            for (String newKey : entry.getValue().newKeys) {
                newKeys = newKeys + newKey + "\t";
            }
            System.out.println(entry.getKey() + "\t" + newKeys);
        }
    }

    static {
        ClassLoader cL = Thread.currentThread().getContextClassLoader();
        if (cL == null) {
            cL = Configuration.class.getClassLoader();
        }
        if (cL.getResource("hadoop-site.xml") != null) {
            LOG.warn((Object)"DEPRECATED: hadoop-site.xml found in the classpath. Usage of hadoop-site.xml is deprecated. Instead use core-site.xml, mapred-site.xml and hdfs-site.xml to override properties of core-default.xml, mapred-default.xml and hdfs-default.xml respectively");
        }
        Configuration.addDefaultResource("core-default.xml");
        Configuration.addDefaultResource("core-site.xml");
        Configuration.addDeprecatedKeys();
        varPat = Pattern.compile("\\$\\{[^\\}\\$ ]+\\}");
        MAX_SUBST = 20;
    }

    private static abstract class NegativeCacheSentinel {
        private NegativeCacheSentinel() {
        }
    }

    public static class IntegerRanges
    implements Iterable<Integer> {
        List<Range> ranges = new ArrayList<Range>();

        public IntegerRanges() {
        }

        public IntegerRanges(String newValue) {
            StringTokenizer itr = new StringTokenizer(newValue, ",");
            while (itr.hasMoreTokens()) {
                String rng = itr.nextToken().trim();
                String[] parts = rng.split("-", 3);
                if (parts.length < 1 || parts.length > 2) {
                    throw new IllegalArgumentException("integer range badly formed: " + rng);
                }
                Range r = new Range();
                r.start = IntegerRanges.convertToInt(parts[0], 0);
                r.end = parts.length == 2 ? IntegerRanges.convertToInt(parts[1], Integer.MAX_VALUE) : r.start;
                if (r.start > r.end) {
                    throw new IllegalArgumentException("IntegerRange from " + r.start + " to " + r.end + " is invalid");
                }
                this.ranges.add(r);
            }
        }

        private static int convertToInt(String value, int defaultValue) {
            String trim = value.trim();
            if (trim.length() == 0) {
                return defaultValue;
            }
            return Integer.parseInt(trim);
        }

        public boolean isIncluded(int value) {
            for (Range r : this.ranges) {
                if (r.start > value || value > r.end) continue;
                return true;
            }
            return false;
        }

        public boolean isEmpty() {
            return this.ranges == null || this.ranges.isEmpty();
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            boolean first = true;
            for (Range r : this.ranges) {
                if (first) {
                    first = false;
                } else {
                    result.append(',');
                }
                result.append(r.start);
                result.append('-');
                result.append(r.end);
            }
            return result.toString();
        }

        @Override
        public Iterator<Integer> iterator() {
            return new RangeNumberIterator(this.ranges);
        }

        private static class RangeNumberIterator
        implements Iterator<Integer> {
            Iterator<Range> internal;
            int at;
            int end;

            public RangeNumberIterator(List<Range> ranges) {
                if (ranges != null) {
                    this.internal = ranges.iterator();
                }
                this.at = -1;
                this.end = -2;
            }

            @Override
            public boolean hasNext() {
                if (this.at <= this.end) {
                    return true;
                }
                if (this.internal != null) {
                    return this.internal.hasNext();
                }
                return false;
            }

            @Override
            public Integer next() {
                Range found;
                if (this.at <= this.end) {
                    ++this.at;
                    return this.at - 1;
                }
                if (this.internal != null && (found = this.internal.next()) != null) {
                    this.at = found.start;
                    this.end = found.end;
                    ++this.at;
                    return this.at - 1;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        private static class Range {
            int start;
            int end;

            private Range() {
            }
        }
    }

    static enum ParsedTimeDuration {
        NS{

            @Override
            TimeUnit unit() {
                return TimeUnit.NANOSECONDS;
            }

            @Override
            String suffix() {
                return "ns";
            }
        }
        ,
        US{

            @Override
            TimeUnit unit() {
                return TimeUnit.MICROSECONDS;
            }

            @Override
            String suffix() {
                return "us";
            }
        }
        ,
        MS{

            @Override
            TimeUnit unit() {
                return TimeUnit.MILLISECONDS;
            }

            @Override
            String suffix() {
                return "ms";
            }
        }
        ,
        S{

            @Override
            TimeUnit unit() {
                return TimeUnit.SECONDS;
            }

            @Override
            String suffix() {
                return "s";
            }
        }
        ,
        M{

            @Override
            TimeUnit unit() {
                return TimeUnit.MINUTES;
            }

            @Override
            String suffix() {
                return "m";
            }
        }
        ,
        H{

            @Override
            TimeUnit unit() {
                return TimeUnit.HOURS;
            }

            @Override
            String suffix() {
                return "h";
            }
        }
        ,
        D{

            @Override
            TimeUnit unit() {
                return TimeUnit.DAYS;
            }

            @Override
            String suffix() {
                return "d";
            }
        };


        abstract TimeUnit unit();

        abstract String suffix();

        static ParsedTimeDuration unitFor(String s) {
            for (ParsedTimeDuration ptd : ParsedTimeDuration.values()) {
                if (!s.endsWith(ptd.suffix())) continue;
                return ptd;
            }
            return null;
        }

        static ParsedTimeDuration unitFor(TimeUnit unit) {
            for (ParsedTimeDuration ptd : ParsedTimeDuration.values()) {
                if (ptd.unit() != unit) continue;
                return ptd;
            }
            return null;
        }
    }

    private static class DeprecatedKeyInfo {
        private String[] newKeys;
        private String customMessage;
        private boolean accessed;

        DeprecatedKeyInfo(String[] newKeys, String customMessage) {
            this.newKeys = newKeys;
            this.customMessage = customMessage;
            this.accessed = false;
        }

        private final String getWarningMessage(String key) {
            String warningMessage;
            if (this.customMessage == null) {
                StringBuilder message = new StringBuilder(key);
                String deprecatedKeySuffix = " is deprecated. Instead, use ";
                message.append(deprecatedKeySuffix);
                for (int i = 0; i < this.newKeys.length; ++i) {
                    message.append(this.newKeys[i]);
                    if (i == this.newKeys.length - 1) continue;
                    message.append(", ");
                }
                warningMessage = message.toString();
            } else {
                warningMessage = this.customMessage;
            }
            this.accessed = true;
            return warningMessage;
        }
    }

    private static class Resource {
        private final Object resource;
        private final String name;

        public Resource(Object resource) {
            this(resource, resource.toString());
        }

        public Resource(Object resource, String name) {
            this.resource = resource;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Object getResource() {
            return this.resource;
        }

        public String toString() {
            return this.name;
        }
    }
}

