/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface SSLHostnameVerifier
extends HostnameVerifier {
    public static final SSLHostnameVerifier DEFAULT = new AbstractVerifier(){

        @Override
        public final void check(String[] hosts, String[] cns, String[] subjectAlts) throws SSLException {
            this.check(hosts, cns, subjectAlts, false, false);
        }

        public final String toString() {
            return "DEFAULT";
        }
    };
    public static final SSLHostnameVerifier DEFAULT_AND_LOCALHOST = new AbstractVerifier(){

        @Override
        public final void check(String[] hosts, String[] cns, String[] subjectAlts) throws SSLException {
            if (2.isLocalhost(hosts[0])) {
                return;
            }
            this.check(hosts, cns, subjectAlts, false, false);
        }

        public final String toString() {
            return "DEFAULT_AND_LOCALHOST";
        }
    };
    public static final SSLHostnameVerifier STRICT = new AbstractVerifier(){

        @Override
        public final void check(String[] host, String[] cns, String[] subjectAlts) throws SSLException {
            this.check(host, cns, subjectAlts, false, true);
        }

        public final String toString() {
            return "STRICT";
        }
    };
    public static final SSLHostnameVerifier STRICT_IE6 = new AbstractVerifier(){

        @Override
        public final void check(String[] host, String[] cns, String[] subjectAlts) throws SSLException {
            this.check(host, cns, subjectAlts, true, true);
        }

        public final String toString() {
            return "STRICT_IE6";
        }
    };
    public static final SSLHostnameVerifier ALLOW_ALL = new AbstractVerifier(){

        @Override
        public final void check(String[] host, String[] cns, String[] subjectAlts) {
        }

        public final String toString() {
            return "ALLOW_ALL";
        }
    };

    @Override
    public boolean verify(String var1, SSLSession var2);

    public void check(String var1, SSLSocket var2) throws IOException;

    public void check(String var1, X509Certificate var2) throws SSLException;

    public void check(String var1, String[] var2, String[] var3) throws SSLException;

    public void check(String[] var1, SSLSocket var2) throws IOException;

    public void check(String[] var1, X509Certificate var2) throws SSLException;

    public void check(String[] var1, String[] var2, String[] var3) throws SSLException;

    public static class Certificates {
        public static String[] getCNs(X509Certificate cert) {
            LinkedList<String> cnList = new LinkedList<String>();
            String subjectPrincipal = cert.getSubjectX500Principal().toString();
            StringTokenizer st = new StringTokenizer(subjectPrincipal, ",");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                int x = tok.indexOf("CN=");
                if (x < 0) continue;
                cnList.add(tok.substring(x + 3));
            }
            if (!cnList.isEmpty()) {
                String[] cns = new String[cnList.size()];
                cnList.toArray(cns);
                return cns;
            }
            return null;
        }

        public static String[] getDNSSubjectAlts(X509Certificate cert) {
            LinkedList<String> subjectAltList = new LinkedList<String>();
            Collection<List<?>> c = null;
            try {
                c = cert.getSubjectAlternativeNames();
            }
            catch (CertificateParsingException cpe) {
                cpe.printStackTrace();
            }
            if (c != null) {
                for (List<?> list : c) {
                    int type = (Integer)list.get(0);
                    if (type != 2) continue;
                    String s = (String)list.get(1);
                    subjectAltList.add(s);
                }
            }
            if (!subjectAltList.isEmpty()) {
                String[] subjectAlts = new String[subjectAltList.size()];
                subjectAltList.toArray(subjectAlts);
                return subjectAlts;
            }
            return null;
        }
    }

    public static abstract class AbstractVerifier
    implements SSLHostnameVerifier {
        private static final String[] BAD_COUNTRY_2LDS = new String[]{"ac", "co", "com", "ed", "edu", "go", "gouv", "gov", "info", "lg", "ne", "net", "or", "org"};
        private static final String[] LOCALHOSTS = new String[]{"::1", "127.0.0.1", "localhost", "localhost.localdomain"};

        protected AbstractVerifier() {
        }

        @Override
        public boolean verify(String host, SSLSession session) {
            try {
                Certificate[] certs = session.getPeerCertificates();
                X509Certificate x509 = (X509Certificate)certs[0];
                this.check(new String[]{host}, x509);
                return true;
            }
            catch (SSLException e) {
                return false;
            }
        }

        @Override
        public void check(String host, SSLSocket ssl) throws IOException {
            this.check(new String[]{host}, ssl);
        }

        @Override
        public void check(String host, X509Certificate cert) throws SSLException {
            this.check(new String[]{host}, cert);
        }

        @Override
        public void check(String host, String[] cns, String[] subjectAlts) throws SSLException {
            this.check(new String[]{host}, cns, subjectAlts);
        }

        @Override
        public void check(String[] host, SSLSocket ssl) throws IOException {
            Certificate[] certs;
            if (host == null) {
                throw new NullPointerException("host to verify is null");
            }
            SSLSession session = ssl.getSession();
            if (session == null) {
                InputStream in = ssl.getInputStream();
                in.available();
                session = ssl.getSession();
                if (session == null) {
                    ssl.startHandshake();
                    session = ssl.getSession();
                }
            }
            try {
                certs = session.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException spue) {
                InputStream in = ssl.getInputStream();
                in.available();
                throw spue;
            }
            X509Certificate x509 = (X509Certificate)certs[0];
            this.check(host, x509);
        }

        @Override
        public void check(String[] host, X509Certificate cert) throws SSLException {
            String[] cns = Certificates.getCNs(cert);
            String[] subjectAlts = Certificates.getDNSSubjectAlts(cert);
            this.check(host, cns, subjectAlts);
        }

        public void check(String[] hosts, String[] cns, String[] subjectAlts, boolean ie6, boolean strictWithSubDomains) throws SSLException {
            int i;
            StringBuffer buf = new StringBuffer(32);
            buf.append('<');
            for (int i2 = 0; i2 < hosts.length; ++i2) {
                String h = hosts[i2];
                hosts[i2] = h = h != null ? h.trim().toLowerCase() : "";
                if (i2 > 0) {
                    buf.append('/');
                }
                buf.append(h);
            }
            buf.append('>');
            String hostnames = buf.toString();
            TreeSet<String> names = new TreeSet<String>();
            if (cns != null && cns.length > 0 && cns[0] != null) {
                names.add(cns[0]);
                if (ie6) {
                    for (i = 1; i < cns.length; ++i) {
                        names.add(cns[i]);
                    }
                }
            }
            if (subjectAlts != null) {
                for (i = 0; i < subjectAlts.length; ++i) {
                    if (subjectAlts[i] == null) continue;
                    names.add(subjectAlts[i]);
                }
            }
            if (names.isEmpty()) {
                String msg = "Certificate for " + hosts[0] + " doesn't contain CN or DNS subjectAlt";
                throw new SSLException(msg);
            }
            buf = new StringBuffer();
            boolean match = false;
            Iterator it = names.iterator();
            block3: while (it.hasNext()) {
                String cn = (String)it.next();
                cn = cn.toLowerCase();
                buf.append(" <");
                buf.append(cn);
                buf.append('>');
                if (it.hasNext()) {
                    buf.append(" OR");
                }
                boolean doWildcard = cn.startsWith("*.") && cn.lastIndexOf(46) >= 0 && !AbstractVerifier.isIP4Address(cn) && AbstractVerifier.acceptableCountryWildcard(cn);
                for (int i3 = 0; i3 < hosts.length; ++i3) {
                    String hostName = hosts[i3].trim().toLowerCase();
                    if (doWildcard) {
                        match = hostName.endsWith(cn.substring(1));
                        if (match && strictWithSubDomains) {
                            match = AbstractVerifier.countDots(hostName) == AbstractVerifier.countDots(cn);
                        }
                    } else {
                        match = hostName.equals(cn);
                    }
                    if (match) break block3;
                }
            }
            if (!match) {
                throw new SSLException("hostname in certificate didn't match: " + hostnames + " !=" + buf);
            }
        }

        public static boolean isIP4Address(String cn) {
            boolean isIP4 = true;
            String tld = cn;
            int x = cn.lastIndexOf(46);
            if (x >= 0 && x + 1 < cn.length()) {
                tld = cn.substring(x + 1);
            }
            for (int i = 0; i < tld.length(); ++i) {
                if (Character.isDigit(tld.charAt(0))) continue;
                isIP4 = false;
                break;
            }
            return isIP4;
        }

        public static boolean acceptableCountryWildcard(String cn) {
            int cnLen = cn.length();
            if (cnLen >= 7 && cnLen <= 9 && cn.charAt(cnLen - 3) == '.') {
                String s = cn.substring(2, cnLen - 3);
                int x = Arrays.binarySearch(BAD_COUNTRY_2LDS, s);
                return x < 0;
            }
            return true;
        }

        public static boolean isLocalhost(String host) {
            int x;
            String string = host = host != null ? host.trim().toLowerCase() : "";
            if (host.startsWith("::1") && (x = host.lastIndexOf(37)) >= 0) {
                host = host.substring(0, x);
            }
            return (x = Arrays.binarySearch(LOCALHOSTS, host)) >= 0;
        }

        public static int countDots(String s) {
            int count = 0;
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) != '.') continue;
                ++count;
            }
            return count;
        }

        static {
            Arrays.sort(BAD_COUNTRY_2LDS);
            Arrays.sort(LOCALHOSTS);
        }
    }
}

