/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

public class SaslOutputStream
extends OutputStream {
    private final DataOutputStream outStream;
    private byte[] saslToken;
    private final SaslClient saslClient;
    private final SaslServer saslServer;
    private final byte[] ibuffer = new byte[1];

    public SaslOutputStream(OutputStream outStream, SaslServer saslServer) {
        this.outStream = new DataOutputStream(outStream);
        this.saslServer = saslServer;
        this.saslClient = null;
    }

    public SaslOutputStream(OutputStream outStream, SaslClient saslClient) {
        this.outStream = new DataOutputStream(outStream);
        this.saslServer = null;
        this.saslClient = saslClient;
    }

    private void disposeSasl() throws SaslException {
        if (this.saslClient != null) {
            this.saslClient.dispose();
        }
        if (this.saslServer != null) {
            this.saslServer.dispose();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.ibuffer[0] = (byte)b;
        this.write(this.ibuffer, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] inBuf, int off, int len) throws IOException {
        try {
            this.saslToken = this.saslServer != null ? this.saslServer.wrap(inBuf, off, len) : this.saslClient.wrap(inBuf, off, len);
        }
        catch (SaslException se) {
            try {
                this.disposeSasl();
            }
            catch (SaslException ignored) {
                // empty catch block
            }
            throw se;
        }
        if (this.saslToken != null) {
            this.outStream.writeInt(this.saslToken.length);
            this.outStream.write(this.saslToken, 0, this.saslToken.length);
            this.saslToken = null;
        }
    }

    @Override
    public void flush() throws IOException {
        this.outStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.disposeSasl();
        this.outStream.close();
    }
}

