/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation;

import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
public class AbstractDelegationTokenSelector<TokenIdent extends AbstractDelegationTokenIdentifier>
implements TokenSelector<TokenIdent> {
    private Text kindName;

    protected AbstractDelegationTokenSelector(Text kindName) {
        this.kindName = kindName;
    }

    @Override
    public Token<TokenIdent> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        for (Token<? extends TokenIdentifier> token : tokens) {
            if (!this.kindName.equals(token.getKind()) || !service.equals(token.getService())) continue;
            return token;
        }
        return null;
    }
}

