/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class DelegateToFileSystem
extends AbstractFileSystem {
    protected final FileSystem fsImpl;

    protected DelegateToFileSystem(URI theUri, FileSystem theFsImpl, Configuration conf, String supportedScheme, boolean authorityRequired) throws IOException, URISyntaxException {
        super(theUri, supportedScheme, authorityRequired, FileSystem.getDefaultUri(conf).getPort());
        this.fsImpl = theFsImpl;
        this.fsImpl.initialize(theUri, conf);
        this.fsImpl.statistics = this.getStatistics();
    }

    @Override
    protected Path getInitialWorkingDirectory() {
        return this.fsImpl.getInitialWorkingDirectory();
    }

    @Override
    protected FSDataOutputStream createInternal(Path f, EnumSet<CreateFlag> flag, FsPermission absolutePermission, int bufferSize, short replication, long blockSize, Progressable progress, int bytesPerChecksum, boolean createParent) throws IOException {
        this.checkPath(f);
        if (!createParent) {
            FileStatus stat = this.getFileStatus(f.getParent());
            if (stat == null) {
                throw new FileNotFoundException("Missing parent:" + f);
            }
            if (!stat.isDir()) {
                throw new ParentNotDirectoryException("parent is not a dir:" + f);
            }
        }
        return this.fsImpl.primitiveCreate(f, absolutePermission, flag, bufferSize, replication, blockSize, progress, bytesPerChecksum);
    }

    @Override
    protected boolean delete(Path f, boolean recursive) throws IOException {
        this.checkPath(f);
        return this.fsImpl.delete(f, recursive);
    }

    @Override
    protected BlockLocation[] getFileBlockLocations(Path f, long start, long len) throws IOException {
        this.checkPath(f);
        return this.fsImpl.getFileBlockLocations(f, start, len);
    }

    @Override
    protected FileChecksum getFileChecksum(Path f) throws IOException {
        this.checkPath(f);
        return this.fsImpl.getFileChecksum(f);
    }

    @Override
    protected FileStatus getFileStatus(Path f) throws IOException {
        this.checkPath(f);
        return this.fsImpl.getFileStatus(f);
    }

    @Override
    protected FileStatus getFileLinkStatus(Path f) throws IOException {
        return this.getFileStatus(f);
    }

    @Override
    protected FsStatus getFsStatus() throws IOException {
        return this.fsImpl.getStatus();
    }

    @Override
    protected FsServerDefaults getServerDefaults() throws IOException {
        return this.fsImpl.getServerDefaults();
    }

    @Override
    protected int getUriDefaultPort() {
        return 0;
    }

    @Override
    protected FileStatus[] listStatus(Path f) throws IOException {
        this.checkPath(f);
        return this.fsImpl.listStatus(f);
    }

    @Override
    protected void mkdir(Path dir, FsPermission permission, boolean createParent) throws IOException {
        this.checkPath(dir);
        this.fsImpl.primitiveMkdir(dir, permission, createParent);
    }

    @Override
    protected FSDataInputStream open(Path f, int bufferSize) throws IOException {
        this.checkPath(f);
        return this.fsImpl.open(f, bufferSize);
    }

    @Override
    protected void renameInternal(Path src, Path dst) throws IOException {
        this.checkPath(src);
        this.checkPath(dst);
        this.fsImpl.rename(src, dst, Options.Rename.NONE);
    }

    @Override
    protected void setOwner(Path f, String username, String groupname) throws IOException {
        this.checkPath(f);
        this.fsImpl.setOwner(f, username, groupname);
    }

    @Override
    protected void setPermission(Path f, FsPermission permission) throws IOException {
        this.checkPath(f);
        this.fsImpl.setPermission(f, permission);
    }

    @Override
    protected boolean setReplication(Path f, short replication) throws IOException {
        this.checkPath(f);
        return this.fsImpl.setReplication(f, replication);
    }

    @Override
    protected void setTimes(Path f, long mtime, long atime) throws IOException {
        this.checkPath(f);
        this.fsImpl.setTimes(f, mtime, atime);
    }

    @Override
    protected void setVerifyChecksum(boolean verifyChecksum) throws IOException {
        this.fsImpl.setVerifyChecksum(verifyChecksum);
    }

    @Override
    protected boolean supportsSymlinks() {
        return false;
    }

    @Override
    protected void createSymlink(Path target, Path link, boolean createParent) throws IOException {
        throw new IOException("File system does not support symlinks");
    }

    @Override
    protected Path getLinkTarget(Path f) throws IOException {
        throw new AssertionError();
    }
}

