/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.serializer.avro;

import java.util.HashSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.hadoop.io.serializer.avro.AvroReflectSerializable;
import org.apache.hadoop.io.serializer.avro.AvroSerialization;

public class AvroReflectSerialization
extends AvroSerialization<Object> {
    public static final String AVRO_REFLECT_PACKAGES = "avro.reflect.pkgs";
    private Set<String> packages;

    @Override
    public synchronized boolean accept(Class<?> c) {
        if (this.packages == null) {
            this.getPackages();
        }
        return AvroReflectSerializable.class.isAssignableFrom(c) || this.packages.contains(c.getPackage().getName());
    }

    private void getPackages() {
        String[] pkgList = this.getConf().getStrings(AVRO_REFLECT_PACKAGES);
        this.packages = new HashSet<String>();
        if (pkgList != null) {
            for (String pkg : pkgList) {
                this.packages.add(pkg.trim());
            }
        }
    }

    @Override
    public DatumReader getReader(Class<Object> clazz) {
        try {
            return new ReflectDatumReader(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Schema getSchema(Object t) {
        return ReflectData.get().getSchema(t.getClass());
    }

    @Override
    public DatumWriter getWriter(Class<Object> clazz) {
        return new ReflectDatumWriter();
    }
}

